/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.awt.EventQueue;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CookieAction;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OpenLayerFilesAction
extends CookieAction {
    protected void performAction(final Node[] activatedNodes) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    FileObject f = ((DataObject)activatedNodes[0].getCookie(DataObject.class)).getPrimaryFile();
                    OpenLayerFilesAction.this.openLayersForFile(f);
                }
                catch (FileStateInvalidException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private void openLayersForFile(FileObject f) throws FileStateInvalidException {
        URL[] location = (URL[])f.getAttribute("layers");
        if (location != null) {
            for (URL u : location) {
                FileObject layer = URLMapper.findFileObject((URL)u);
                if (layer == null) continue;
                try {
                    OpenLayerFilesAction.openLayerFileAndFind(DataObject.find((FileObject)layer), f);
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private static void openLayerFileAndFind(DataObject layerDataObject, FileObject originalF) {
        EditorCookie editorCookie = (EditorCookie)layerDataObject.getCookie(EditorCookie.class);
        if (editorCookie != null) {
            editorCookie.open();
            final LineCookie lineCookie = (LineCookie)layerDataObject.getCookie(LineCookie.class);
            if (lineCookie != null) {
                LinkedList<FileObject> lineage = new LinkedList<FileObject>();
                for (FileObject parent = originalF; parent != null; parent = parent.getParent()) {
                    if (parent.getParent() == null) continue;
                    lineage.add(0, parent);
                }
                try {
                    InputSource in = new InputSource(layerDataObject.getPrimaryFile().getURL().toExternalForm());
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    SAXParser parser = factory.newSAXParser();
                    final int[] line = new int[1];
                    class Handler
                    extends DefaultHandler {
                        private Locator locator;
                        private Iterator<FileObject> lineageIterator;
                        private FileObject lookingFor;
                        final /* synthetic */ int[] val$line;

                        Handler(List<FileObject> list) {
                            this.val$line = (int[])list;
                            this.lineageIterator = lineage.iterator();
                            this.lookingFor = this.lineageIterator.next();
                        }

                        @Override
                        public void setDocumentLocator(Locator l) {
                            this.locator = l;
                        }

                        @Override
                        public void startElement(String uri, String localname, String qname, Attributes attr) throws SAXException {
                            if (this.val$line[0] == 0 && (this.lookingFor.isFolder() ? "folder".equals(qname) : "file".equals(qname)) && this.lookingFor.getNameExt().equals(attr.getValue("name"))) {
                                if (this.lineageIterator.hasNext()) {
                                    this.lookingFor = this.lineageIterator.next();
                                } else {
                                    this.val$line[0] = this.locator.getLineNumber();
                                }
                            }
                        }
                    }
                    parser.parse(in, (DefaultHandler)new Handler(lineage, line));
                    if (line[0] < 1) {
                        return;
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            lineCookie.getLineSet().getCurrent(line[0] - 1).show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                        }
                    });
                }
                catch (Exception e) {
                    return;
                }
            }
        }
    }

    public String getName() {
        return NbBundle.getMessage(OpenLayerFilesAction.class, (String)"LBL_open_layer_files_action");
    }

    protected Class[] cookieClasses() {
        return new Class[]{DataObject.class};
    }

    protected int mode() {
        return 8;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }
}

