/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.properties.Element;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class PropertyPanel
extends JPanel {
    private final Element.ItemElem element;
    private JTextField keyText;
    private JTextField valueText;
    private JTextField commentText;

    PropertyPanel() {
        this((Element.ItemElem)null);
    }

    PropertyPanel(Element.ItemElem element) {
        this.element = element;
        this.initComponents();
        this.initInteraction();
        this.initAccessibility();
        if (element != null) {
            this.keyText.setText(element.getKey());
            this.valueText.setText(element.getValue());
            this.commentText.setText(element.getComment());
        }
        KeyStroke enterKeyStroke = KeyStroke.getKeyStroke(10, 0);
        this.keyText.getKeymap().removeKeyStrokeBinding(enterKeyStroke);
        this.valueText.getKeymap().removeKeyStrokeBinding(enterKeyStroke);
        this.commentText.getKeymap().removeKeyStrokeBinding(enterKeyStroke);
        HelpCtx.setHelpIDString((JComponent)this, (String)"propfiles.adding");
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"ACS_PropertyPanel"));
        AccessibleContext context = this.keyText.getAccessibleContext();
        context.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_CTL_KeyText"));
        context.setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"ACSD_CTL_KeyText"));
        context = this.valueText.getAccessibleContext();
        context.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_CTL_ValueText"));
        context.setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"ACSD_CTL_ValueText"));
        context = this.commentText.getAccessibleContext();
        context.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_CTL_CommentText"));
        context.setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"ACSD_CTL_CommentText"));
    }

    private void initComponents() {
        JLabel keyLabel = new JLabel();
        JLabel valueLabel = new JLabel();
        JLabel commentLabel = new JLabel();
        this.keyText = new JTextField(25);
        this.valueText = new JTextField(25);
        this.commentText = new JTextField(25);
        keyLabel.setLabelFor(this.keyText);
        valueLabel.setLabelFor(this.valueText);
        commentLabel.setLabelFor(this.commentText);
        Mnemonics.setLocalizedText((JLabel)keyLabel, (String)NbBundle.getMessage(this.getClass(), (String)"LBL_KeyLabel"));
        Mnemonics.setLocalizedText((JLabel)valueLabel, (String)NbBundle.getMessage(this.getClass(), (String)"LBL_ValueLabel"));
        Mnemonics.setLocalizedText((JLabel)commentLabel, (String)NbBundle.getMessage(this.getClass(), (String)"LBL_CommentLabel"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)keyLabel).add((Component)valueLabel).add((Component)commentLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.keyText, -1, -2, Short.MAX_VALUE).add((Component)this.valueText, -1, -2, Short.MAX_VALUE).add((Component)this.commentText, -1, -2, Short.MAX_VALUE)).addContainerGap());
        layout.setVerticalGroup((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)keyLabel).add((Component)this.keyText, -2, -2, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.valueText, -2, -2, -2).add((Component)valueLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.commentText, -2, -2, -2).add((Component)commentLabel)).addContainerGap());
    }

    private void initInteraction() {
        Listener listener = new Listener();
        this.keyText.addActionListener(listener);
        this.valueText.addActionListener(listener);
        this.commentText.addActionListener(listener);
        if (this.element != null) {
            this.keyText.addFocusListener(listener);
            this.valueText.addFocusListener(listener);
            this.commentText.addFocusListener(listener);
        }
    }

    String getKey() {
        return this.keyText.getText();
    }

    String getValue() {
        return this.valueText.getText();
    }

    String getComment() {
        return this.commentText.getText();
    }

    private void workaround11364() {
        JButton defaultButton;
        JRootPane root = this.getRootPane();
        if (root != null && (defaultButton = root.getDefaultButton()) != null) {
            defaultButton.doClick();
        }
    }

    private final class Listener
    extends FocusAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.storeText(e.getSource());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.storeText(e.getSource());
            PropertyPanel.this.workaround11364();
        }

        private void storeText(Object source) {
            if (PropertyPanel.this.element != null) {
                if (source == PropertyPanel.this.keyText) {
                    PropertyPanel.this.element.getKeyElem().setValue(PropertyPanel.this.keyText.getText());
                } else if (source == PropertyPanel.this.valueText) {
                    PropertyPanel.this.element.getValueElem().setValue(PropertyPanel.this.valueText.getText());
                } else if (source == PropertyPanel.this.commentText) {
                    PropertyPanel.this.element.getCommentElem().setValue(PropertyPanel.this.commentText.getText());
                } else assert (false);
            }
        }
    }
}

