/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.modules.ruby.debugger.DebuggerBreakpointAnnotation;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpoint;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyLineBreakpoint;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.AnnotationProvider;
import org.openide.text.Line;
import org.openide.util.Lookup;

public final class BreakpointAnnotationListener
extends DebuggerManagerAdapter
implements PropertyChangeListener,
AnnotationProvider {
    private Map<Breakpoint, Annotation> breakpointToAnnotation = new HashMap<Breakpoint, Annotation>();

    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    public void breakpointAdded(Breakpoint b) {
        if (!(b instanceof RubyLineBreakpoint)) {
            return;
        }
        this.addAnnotation(b);
    }

    public void breakpointRemoved(Breakpoint b) {
        if (!(b instanceof RubyBreakpoint)) {
            return;
        }
        this.removeAnnotation(b);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (propName == "enabled" || propName == "updated") {
            this.removeAnnotation((Breakpoint)evt.getSource());
            this.addAnnotation((Breakpoint)evt.getSource());
        }
    }

    private void addAnnotation(Breakpoint b) {
        DebuggerBreakpointAnnotation debugAnnotation = new DebuggerBreakpointAnnotation(b.isEnabled() ? "Breakpoint" : "DisabledBreakpoint", (Annotatable)((RubyLineBreakpoint)b).getLine(), b);
        this.breakpointToAnnotation.put(b, (Annotation)debugAnnotation);
        b.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void removeAnnotation(Breakpoint b) {
        Annotation annotation = this.breakpointToAnnotation.remove(b);
        if (annotation == null) {
            return;
        }
        annotation.detach();
        b.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void annotate(Line.Set set, Lookup context) {
        DebuggerManager.getDebuggerManager().getBreakpoints();
    }
}

