/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.executor;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.remove.RemoveCommand;
import org.netbeans.lib.cvsclient.command.remove.RemoveInformation;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class RemoveExecutor
extends ExecutorSupport {
    private Set refreshedFiles;

    public static RemoveExecutor[] splitCommand(RemoveCommand cmd, CvsVersioningSystem cvs, GlobalOptions options) {
        Command[] cmds = new Command[]{};
        if (cmd.getDisplayName() == null) {
            cmd.setDisplayName(NbBundle.getMessage(RemoveExecutor.class, (String)"MSG_RemoveExecutor_CmdDisplayName"));
        }
        try {
            cmds = RemoveExecutor.prepareBasicCommand((BasicCommand)cmd);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
        RemoveExecutor[] executors = new RemoveExecutor[cmds.length];
        for (int i = 0; i < cmds.length; ++i) {
            Command command = cmds[i];
            executors[i] = new RemoveExecutor(cvs, (RemoveCommand)command, options);
        }
        return executors;
    }

    private RemoveExecutor(CvsVersioningSystem cvs, RemoveCommand cmd, GlobalOptions options) {
        super(cvs, (Command)cmd, options);
    }

    @Override
    protected void commandFinished(ClientRuntime.Result result) {
        RemoveCommand xcmd = (RemoveCommand)this.cmd;
        this.refreshedFiles = new HashSet(this.toRefresh.size());
        for (RemoveInformation info : this.toRefresh) {
            if (info.getFile() == null) continue;
            int repositoryStatus = 0;
            repositoryStatus = info.isRemoved() ? 82 : 0;
            this.cache.refreshCached(info.getFile(), repositoryStatus);
            this.refreshedFiles.add(info.getFile());
        }
        if (this.cmd.hasFailed()) {
            return;
        }
        File[] files = xcmd.getFiles();
        for (int i = 0; i < files.length; ++i) {
            this.refreshRecursively(files[i]);
        }
    }

    private void refreshRecursively(File file) {
        if (this.cvs.isIgnoredFilename(file)) {
            return;
        }
        if (this.refreshedFiles.contains(file)) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.refreshRecursively(files[i]);
            }
            this.cache.refreshCached(file, 0);
        } else {
            this.cache.refreshCached(file, 0);
        }
    }
}

