/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.awt.Image;
import java.io.File;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.modules.diff.PatchAction;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.options.AnnotationColorProvider;
import org.netbeans.modules.versioning.system.cvss.ui.actions.ChangeCVSRootAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.checkout.CheckoutAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.ExcludeFromCommitAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.ExportDiffAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.ResolveConflictsAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.ignore.IgnoreAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.AnnotationsAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.SearchHistoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.project.AddToRepositoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.project.UpdateWithDependenciesAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.status.StatusAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.BranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.BranchesMenu;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.MergeBranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.SwitchBranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.TagAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.GetCleanAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateAction;
import org.netbeans.modules.versioning.system.cvss.ui.history.ViewRevisionAction;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class Annotator {
    private static String badgeModified = "org/netbeans/modules/versioning/system/cvss/resources/icons/modified-badge.png";
    private static String badgeConflicts = "org/netbeans/modules/versioning/system/cvss/resources/icons/conflicts-badge.png";
    private static String toolTipModified = "<img src=\"" + Annotator.class.getClassLoader().getResource(badgeModified) + "\">&nbsp;" + NbBundle.getMessage(Annotator.class, (String)"MSG_Contains_Modified_Locally");
    private static String toolTipConflict = "<img src=\"" + Annotator.class.getClassLoader().getResource(badgeConflicts) + "\">&nbsp;" + NbBundle.getMessage(Annotator.class, (String)"MSG_Contains_Conflicts");
    private static final int STATUS_TEXT_ANNOTABLE = 6622;
    private static final Pattern lessThan = Pattern.compile("<");
    private final FileStatusCache cache;
    private String lastAnnotationsFormat;
    private MessageFormat lastMessageFormat;
    private String lastEmptyAnnotation;
    private static final int STATUS_BADGEABLE = 12;

    Annotator(CvsVersioningSystem cvs) {
        this.cache = cvs.getStatusCache();
    }

    public String annotateNameHtml(String name, FileInformation info, File file) {
        String textAnnotation;
        name = this.htmlEncode(name);
        int status = info.getStatus();
        boolean annotationsVisible = VersioningSupport.getPreferences().getBoolean("textAnnotationsVisible", false);
        if (annotationsVisible && file != null && (status & 0x19DE) != 0) {
            textAnnotation = this.formatAnnotation(info, file);
            if (textAnnotation.equals(this.lastEmptyAnnotation)) {
                textAnnotation = "";
            }
        } else {
            textAnnotation = "";
        }
        if (textAnnotation.length() > 0) {
            textAnnotation = NbBundle.getMessage(Annotator.class, (String)"textAnnotation", (Object)textAnnotation);
        }
        switch (status) {
            case 0: 
            case 1: {
                return name;
            }
            case 8: {
                return this.getAnnotationProvider().UP_TO_DATE_FILE.getFormat().format(new Object[]{name, textAnnotation});
            }
            case 16: {
                return this.getAnnotationProvider().MODIFIED_LOCALLY_FILE.getFormat().format(new Object[]{name, textAnnotation});
            }
            case 4: {
                return this.getAnnotationProvider().NEW_LOCALLY_FILE.getFormat().format(new Object[]{name, textAnnotation});
            }
            case 256: {
                return this.getAnnotationProvider().REMOVED_LOCALLY_FILE.getFormat().format(new Object[]{name, textAnnotation});
            }
            case 2048: {
                return this.getAnnotationProvider().DELETED_LOCALLY_FILE.getFormat().format(new Object[]{name, textAnnotation});
            }
            case 512: {
                return this.getAnnotationProvider().NEW_IN_REPOSITORY_FILE.getFormat().format(new Object[]{name, textAnnotation});
            }
            case 32: {
                return this.getAnnotationProvider().MODIFIED_IN_REPOSITORY_FILE.getFormat().format(new Object[]{name, textAnnotation});
            }
            case 1024: {
                return this.getAnnotationProvider().REMOVED_IN_REPOSITORY_FILE.getFormat().format(new Object[]{name, textAnnotation});
            }
            case 4096: {
                return this.getAnnotationProvider().ADDED_LOCALLY_FILE.getFormat().format(new Object[]{name, textAnnotation});
            }
            case 128: {
                return this.getAnnotationProvider().MERGEABLE_FILE.getFormat().format(new Object[]{name, textAnnotation});
            }
            case 64: {
                return this.getAnnotationProvider().CONFLICT_FILE.getFormat().format(new Object[]{name, textAnnotation});
            }
            case 2: {
                return this.getAnnotationProvider().EXCLUDED_FILE.getFormat().format(new Object[]{name, textAnnotation});
            }
        }
        throw new IllegalArgumentException("Unknown status: " + status);
    }

    private String formatAnnotation(FileInformation info, File file) {
        String stickyString;
        this.updateMessageFormat();
        String statusString = "";
        int status = info.getStatus();
        if (status != 8) {
            statusString = info.getShortStatusText();
        }
        String revisionString = "";
        String binaryString = "";
        Entry entry = info.getEntry(file);
        if (entry != null) {
            revisionString = entry.getRevision();
            binaryString = entry.getOptions();
            if (!"-kb".equals(binaryString)) {
                binaryString = "";
            }
        }
        if ((stickyString = Utils.getSticky(file)) == null) {
            stickyString = "";
        }
        Object[] arguments = new Object[]{revisionString, statusString, stickyString, binaryString};
        return this.lastMessageFormat.format(arguments, new StringBuffer(), (FieldPosition)null).toString().trim();
    }

    private void updateMessageFormat() {
        String taf = CvsModuleConfig.getDefault().getPreferences().get("annotationsFormat", "[{status}; {tag}]");
        if (this.lastMessageFormat == null || !taf.equals(this.lastAnnotationsFormat)) {
            this.lastAnnotationsFormat = taf;
            if (!Utils.isAnnotationFormatValid(taf = Utils.createAnnotationFormat(taf))) {
                CvsVersioningSystem.LOG.log(Level.WARNING, "Bad annotation format, switching to defaults");
                taf = NbBundle.getMessage(Annotator.class, (String)"Annotator.defaultFormat");
            }
            this.lastMessageFormat = new MessageFormat(taf);
            this.lastEmptyAnnotation = this.lastMessageFormat.format(new Object[]{"", "", "", ""});
        }
    }

    private String annotateFolderNameHtml(String name, FileInformation info, File file) {
        String textAnnotation;
        name = this.htmlEncode(name);
        int status = info.getStatus();
        boolean annotationsVisible = VersioningSupport.getPreferences().getBoolean("textAnnotationsVisible", false);
        if (annotationsVisible && file != null && (status & 0xFFFFFFFE) != 0) {
            textAnnotation = this.formatAnnotation(info, file);
            if (textAnnotation.equals(this.lastEmptyAnnotation)) {
                textAnnotation = "";
            }
        } else {
            textAnnotation = "";
        }
        if (textAnnotation.length() > 0) {
            textAnnotation = NbBundle.getMessage(Annotator.class, (String)"textAnnotation", (Object)textAnnotation);
        }
        switch (status) {
            case 0: 
            case 1: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 512: 
            case 1024: 
            case 2048: {
                return name;
            }
            case 4: 
            case 8: 
            case 4096: {
                return this.getAnnotationProvider().UP_TO_DATE_FILE.getFormat().format(new Object[]{name, textAnnotation});
            }
            case 2: {
                return this.getAnnotationProvider().EXCLUDED_FILE.getFormat().format(new Object[]{name, textAnnotation});
            }
        }
        throw new IllegalArgumentException("Unknown status: " + status);
    }

    private String htmlEncode(String name) {
        if (name.indexOf(60) == -1) {
            return name;
        }
        return lessThan.matcher(name).replaceAll("&lt;");
    }

    public String annotateNameHtml(File file, FileInformation info) {
        return this.annotateNameHtml(file.getName(), info, file);
    }

    public String annotateNameHtml(String name, VCSContext context, int includeStatus) {
        FileInformation mostImportantInfo = null;
        File mostImportantFile = null;
        boolean folderAnnotation = false;
        for (File file : context.getRootFiles()) {
            FileInformation info = this.cache.getStatus(file);
            int status = info.getStatus();
            if ((status & includeStatus) == 0 || !this.isMoreImportant(info, mostImportantInfo)) continue;
            mostImportantInfo = info;
            mostImportantFile = file;
            folderAnnotation = file.isDirectory();
        }
        if (!folderAnnotation && context.getRootFiles().size() > 1) {
            boolean bl = folderAnnotation = !org.netbeans.modules.versioning.util.Utils.shareCommonDataObject((File[])context.getRootFiles().toArray(new File[context.getRootFiles().size()]));
        }
        if (mostImportantInfo == null) {
            return null;
        }
        return folderAnnotation ? this.annotateFolderNameHtml(name, mostImportantInfo, mostImportantFile) : this.annotateNameHtml(name, mostImportantInfo, mostImportantFile);
    }

    private boolean isMoreImportant(FileInformation a, FileInformation b) {
        if (b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return Utils.getComparableStatus(a.getStatus()) < Utils.getComparableStatus(b.getStatus());
    }

    public static Action[] getActions(VCSContext ctx, VCSAnnotator.ActionDestination destination) {
        ResourceBundle loc = NbBundle.getBundle(Annotator.class);
        ArrayList<Object> actions = new ArrayList<Object>(20);
        if (destination == VCSAnnotator.ActionDestination.MainMenu) {
            actions.add(SystemAction.get(CheckoutAction.class));
            actions.add(SystemAction.get(AddToRepositoryAction.class));
            actions.add(new ChangeCVSRootAction(loc.getString("CTL_MenuItem_ChangeCVSRoot"), ctx));
            actions.add(null);
            actions.add(SystemAction.get(UpdateWithDependenciesAction.class));
            actions.add(null);
            actions.add(SystemAction.get(StatusAction.class));
            actions.add(SystemAction.get(DiffAction.class));
            actions.add(SystemAction.get(UpdateAction.class));
            actions.add(SystemAction.get(CommitAction.class));
            actions.add(null);
            actions.add(SystemAction.get(ExportDiffAction.class));
            actions.add(SystemAction.get(PatchAction.class));
            actions.add(null);
            actions.add(SystemAction.get(TagAction.class));
            actions.add(new BranchesMenu());
            actions.add(null);
            actions.add(SystemAction.get(AnnotationsAction.class));
            actions.add(new ViewRevisionAction(ctx));
            actions.add(SystemAction.get(SearchHistoryAction.class));
            actions.add(null);
            actions.add(SystemAction.get(GetCleanAction.class));
            actions.add(SystemAction.get(ResolveConflictsAction.class));
            actions.add(SystemAction.get(IgnoreAction.class));
            actions.add(new ExcludeFromCommitAction(ctx));
        } else {
            Lookup context = ctx.getElements();
            File[] files = ctx.getRootFiles().toArray(new File[ctx.getRootFiles().size()]);
            boolean noneVersioned = Annotator.isNothingVersioned(files);
            if (noneVersioned) {
                actions.add(SystemActionBridge.createAction((Action)((AddToRepositoryAction)SystemAction.get(AddToRepositoryAction.class)).createContextAwareInstance(context), (String)loc.getString("CTL_PopupMenuItem_Import"), (Lookup)context));
            } else {
                boolean onlyFolders = Annotator.onlyFolders(files);
                Node[] nodes = ctx.getElements().lookupAll(Node.class).toArray(new Node[0]);
                boolean onlyProjects = Annotator.onlyProjects(nodes);
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(StatusAction.class), (String)loc.getString("CTL_PopupMenuItem_Status"), (Lookup)context));
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(DiffAction.class), (String)loc.getString("CTL_PopupMenuItem_Diff"), (Lookup)context));
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(UpdateAction.class), (String)loc.getString("CTL_PopupMenuItem_Update"), (Lookup)context));
                if (onlyProjects) {
                    actions.add(new SystemActionBridge((Action)SystemAction.get(UpdateWithDependenciesAction.class), loc.getString("CTL_PopupMenuItem_UpdateWithDeps")));
                }
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(CommitAction.class), (String)loc.getString("CTL_PopupMenuItem_Commit"), (Lookup)context));
                actions.add(null);
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(TagAction.class), (String)loc.getString("CTL_PopupMenuItem_Tag"), (Lookup)context));
                actions.add(null);
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(BranchAction.class), (String)loc.getString("CTL_PopupMenuItem_Branch"), (Lookup)context));
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(SwitchBranchAction.class), (String)loc.getString("CTL_PopupMenuItem_SwitchBranch"), (Lookup)context));
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(MergeBranchAction.class), (String)loc.getString("CTL_PopupMenuItem_MergeBranch"), (Lookup)context));
                actions.add(null);
                if (!onlyFolders) {
                    actions.add(SystemActionBridge.createAction((Action)SystemAction.get(AnnotationsAction.class), (String)(((AnnotationsAction)SystemAction.get(AnnotationsAction.class)).visible(nodes) ? loc.getString("CTL_PopupMenuItem_HideAnnotations") : loc.getString("CTL_PopupMenuItem_ShowAnnotations")), (Lookup)context));
                }
                actions.add(new ViewRevisionAction(loc.getString("CTL_PopupMenuItem_ViewRevision"), ctx));
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(SearchHistoryAction.class), (String)loc.getString("CTL_PopupMenuItem_SearchHistory"), (Lookup)context));
                actions.add(null);
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(GetCleanAction.class), (String)loc.getString("CTL_PopupMenuItem_GetClean"), (Lookup)context));
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(ResolveConflictsAction.class), (String)loc.getString("CTL_PopupMenuItem_ResolveConflicts"), (Lookup)context));
                if (!onlyProjects) {
                    actions.add(SystemActionBridge.createAction((Action)SystemAction.get(IgnoreAction.class), (String)(((IgnoreAction)SystemAction.get(IgnoreAction.class)).getActionStatus(nodes, true) == 2 ? loc.getString("CTL_PopupMenuItem_Unignore") : loc.getString("CTL_PopupMenuItem_Ignore")), (Lookup)context));
                }
                actions.add(new ExcludeFromCommitAction(ctx));
            }
        }
        return actions.toArray(new Action[actions.size()]);
    }

    private static boolean isNothingVersioned(File[] files) {
        for (File file : files) {
            if (!CvsVersioningSystem.isManaged(file)) continue;
            return false;
        }
        return true;
    }

    private static boolean onlyProjects(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return false;
        }
        for (Node node : nodes) {
            if (node.getLookup().lookup(Project.class) != null) continue;
            return false;
        }
        return true;
    }

    private static boolean onlyFolders(File[] files) {
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                return false;
            }
            FileInformation status = cache.getCachedStatus(files[i]);
            if (status != null && (files[i].exists() || status.isDirectory())) continue;
            return false;
        }
        return true;
    }

    private static MessageFormat getFormat(String key) {
        String format = NbBundle.getMessage(Annotator.class, (String)key);
        return new MessageFormat(format);
    }

    public Image annotateIcon(Image icon, VCSContext context, int includeStatus) {
        boolean folderAnnotation = false;
        for (File file : context.getRootFiles()) {
            if (!file.isDirectory()) continue;
            folderAnnotation = true;
            break;
        }
        if (!folderAnnotation && context.getRootFiles().size() > 1) {
            boolean bl = folderAnnotation = !org.netbeans.modules.versioning.util.Utils.shareCommonDataObject((File[])context.getRootFiles().toArray(new File[context.getRootFiles().size()]));
        }
        if (!folderAnnotation) {
            return this.annotateFileIcon(context, icon, includeStatus);
        }
        return this.annotateFolderIcon(context, icon);
    }

    private Image annotateFileIcon(VCSContext context, Image icon, int includeStatus) {
        FileInformation mostImportantInfo = null;
        for (File file : context.getRootFiles()) {
            FileInformation info = this.cache.getStatus(file);
            int status = info.getStatus();
            if ((status & includeStatus) == 0 || !this.isMoreImportant(info, mostImportantInfo)) continue;
            mostImportantInfo = info;
        }
        if (mostImportantInfo == null) {
            return null;
        }
        String statusText = null;
        int status = mostImportantInfo.getStatus();
        switch (status) {
            case 0: {
                break;
            }
            case 1: {
                statusText = null;
                break;
            }
            case 8: {
                statusText = null;
                break;
            }
            case 16: {
                statusText = this.getAnnotationProvider().MODIFIED_LOCALLY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
                break;
            }
            case 4: {
                statusText = this.getAnnotationProvider().NEW_LOCALLY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
                break;
            }
            case 256: {
                statusText = this.getAnnotationProvider().REMOVED_LOCALLY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
                break;
            }
            case 2048: {
                statusText = this.getAnnotationProvider().DELETED_LOCALLY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
                break;
            }
            case 512: {
                statusText = this.getAnnotationProvider().NEW_IN_REPOSITORY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
                break;
            }
            case 32: {
                statusText = this.getAnnotationProvider().MODIFIED_IN_REPOSITORY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
                break;
            }
            case 1024: {
                statusText = this.getAnnotationProvider().REMOVED_IN_REPOSITORY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
                break;
            }
            case 4096: {
                statusText = this.getAnnotationProvider().ADDED_LOCALLY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
                break;
            }
            case 128: {
                statusText = this.getAnnotationProvider().MERGEABLE_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
                break;
            }
            case 64: {
                statusText = this.getAnnotationProvider().CONFLICT_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
                break;
            }
            case 2: {
                statusText = this.getAnnotationProvider().EXCLUDED_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown status: " + status);
            }
        }
        return statusText != null ? ImageUtilities.addToolTipToImage((Image)icon, statusText) : null;
    }

    private Image annotateFolderIcon(VCSContext context, Image icon) {
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        boolean isVersioned = false;
        for (File file : context.getRootFiles()) {
            if ((cache.getStatus(file).getStatus() & 0xC) == 0) continue;
            isVersioned = true;
            break;
        }
        if (!isVersioned) {
            return null;
        }
        CvsModuleConfig config = CvsModuleConfig.getDefault();
        boolean allExcluded = true;
        boolean modified = false;
        Map<File, FileInformation> map = cache.getAllModifiedFiles();
        HashMap<File, FileInformation> modifiedFiles = new HashMap<File, FileInformation>();
        for (Map.Entry<File, FileInformation> entry : map.entrySet()) {
            FileInformation info = entry.getValue();
            if (info.isDirectory() || (info.getStatus() & 0x19D4) == 0) continue;
            modifiedFiles.put(entry.getKey(), info);
        }
        for (File file : context.getRootFiles()) {
            int status;
            FileInformation info;
            if (VersioningSupport.isFlat((File)file)) {
                for (File mf : modifiedFiles.keySet()) {
                    if (!mf.getParentFile().equals(file) || (info = (FileInformation)modifiedFiles.get(mf)).isDirectory()) continue;
                    status = info.getStatus();
                    if (status == 64) {
                        Image badge = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)badgeConflicts, (boolean)true), (String)toolTipConflict);
                        return ImageUtilities.mergeImages((Image)icon, (Image)badge, (int)16, (int)9);
                    }
                    modified = true;
                    allExcluded &= config.isExcludedFromCommit(mf);
                }
                continue;
            }
            for (File mf : modifiedFiles.keySet()) {
                if (!Utils.isParentOrEqual(file, mf)) continue;
                info = (FileInformation)modifiedFiles.get(mf);
                status = info.getStatus();
                if (status == 64) {
                    Image badge = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)badgeConflicts, (boolean)true), (String)toolTipConflict);
                    return ImageUtilities.mergeImages((Image)icon, (Image)badge, (int)16, (int)9);
                }
                modified = true;
                allExcluded &= config.isExcludedFromCommit(mf);
            }
        }
        if (modified && !allExcluded) {
            Image badge = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)badgeModified, (boolean)true), (String)toolTipModified);
            return ImageUtilities.mergeImages((Image)icon, (Image)badge, (int)16, (int)9);
        }
        return null;
    }

    private AnnotationColorProvider getAnnotationProvider() {
        return AnnotationColorProvider.getInstance();
    }
}

