/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.i18n.FactoryRegistry;
import org.netbeans.modules.i18n.I18nManager;
import org.netbeans.modules.i18n.I18nUtil;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class I18nAction
extends NodeAction {
    static final long serialVersionUID = 3322896507302889271L;

    public I18nAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected void performAction(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return;
        }
        Node node = activatedNodes[0];
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return;
        }
        EditorCookie editorCookie = (EditorCookie)node.getCookie(EditorCookie.class);
        if (editorCookie == null && (editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) == null) {
            return;
        }
        editorCookie.open();
        I18nManager.getDefault().internationalize(dataObject);
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        Node node = activatedNodes[0];
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null || dataObject.getPrimaryFile() == null) {
            return false;
        }
        EditorCookie editorCookie = (EditorCookie)node.getCookie(EditorCookie.class);
        if (editorCookie == null && (editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) == null) {
            return false;
        }
        if (!FactoryRegistry.hasFactory(dataObject.getClass())) {
            return false;
        }
        return FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile()) != null;
    }

    public String getName() {
        return I18nUtil.getBundle().getString("CTL_I18nAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("internation.autoinsert");
    }
}

