/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class TinySingletonMap<K, V>
implements Map<K, V> {
    private K key;
    private V value;

    public TinySingletonMap() {
    }

    public TinySingletonMap(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    @Override
    public int size() {
        if (this.key == null) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return this.key == null;
    }

    @Override
    public boolean containsKey(Object aKey) {
        if (this.key == null) {
            return false;
        }
        return this.key.equals(aKey);
    }

    @Override
    public boolean containsValue(Object aValue) {
        return this.value != null && this.value.equals(aValue);
    }

    @Override
    public V get(Object aKey) {
        if (this.key != null && this.key.equals(aKey)) {
            return this.value;
        }
        return null;
    }

    @Override
    public V put(K aKey, V aMacro) {
        V out = null;
        if (this.key != null && this.key.equals(aKey)) {
            out = this.value;
        }
        this.key = aKey;
        this.value = aMacro;
        return out;
    }

    @Override
    public V remove(Object aKey) {
        if (this.key == null) {
            return null;
        }
        if (this.key.equals(aKey)) {
            V res = this.value;
            this.key = null;
            this.value = null;
            return res;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clear() {
        this.key = null;
        this.value = null;
    }

    @Override
    public Set<K> keySet() {
        if (this.key == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.key);
    }

    @Override
    public Collection<V> values() {
        if (this.key == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.key == null) {
            return Collections.emptySet();
        }
        return new Set<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return 1;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private boolean last = false;

                    @Override
                    public boolean hasNext() {
                        return !this.last;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (!this.last) {
                            this.last = true;
                            return new Map.Entry<K, V>(){

                                @Override
                                public K getKey() {
                                    return TinySingletonMap.this.key;
                                }

                                @Override
                                public V getValue() {
                                    return TinySingletonMap.this.value;
                                }

                                @Override
                                public V setValue(V value) {
                                    Object res = TinySingletonMap.this.value;
                                    TinySingletonMap.this.value = value;
                                    return res;
                                }
                            };
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                };
            }

            @Override
            public boolean contains(Object o) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public <T> T[] toArray(T[] a) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean add(Map.Entry<K, V> o) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }
}

