module Manticore
  class Client
    module ProxiesInterface
      def respond_with(stubs)
        StubProxy.new(self, stubs)
      end

      # Causes the next request to be made asynchronously
      def async
        AsyncProxy.new(self)
      end

      # Causes the next request to be made immediately in the background
      def background
        BackgroundProxy.new(self)
      end
    end

    class BaseProxy
      include ProxiesInterface
      def initialize(client)
        @client = client
      end
    end

    class AsyncProxy < BaseProxy
      %w(get put head post options patch).each do |func|
        define_method func do |url, options = {}, &block|
          @client.send(func, url, options.merge(async: true), &block)
        end
      end
    end

    class StubProxy < BaseProxy
      def initialize(client, stubs)
        super(client)
        @stubs = stubs
      end

      %w(get put head post options patch).each do |func|
        define_method func do |url, options = {}, &block|
          @client.stub(url, @stubs)
          @client.send(func, url, options, &block).complete { @client.unstub url }
        end
      end
    end

    class BackgroundProxy < BaseProxy
      %w(get put head post options patch).each do |func|
        define_method func do |url, options = {}, &block|
          request = @client.send(func, url, options.merge(async: true), &block)
          @client.executor.java_method(:submit, [java.util.concurrent.Callable.java_class]).call request
        end
      end
    end
  end
end