/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jruby;

import java.io.IOException;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingService;
import org.msgpack.MessagePack;
import org.msgpack.packer.BufferPacker;

public class RubyObjectPacker {
    private final MessagePack msgPack;

    public RubyObjectPacker(MessagePack messagePack) {
        this.msgPack = messagePack;
    }

    public RubyString pack(IRubyObject iRubyObject, RubyHash rubyHash) throws IOException {
        return RubyString.newString((Ruby)iRubyObject.getRuntime(), (byte[])this.packRaw(iRubyObject, new CompiledOptions(iRubyObject.getRuntime(), rubyHash)));
    }

    @Deprecated
    public byte[] packRaw(IRubyObject iRubyObject) throws IOException {
        if (iRubyObject == null) {
            return new byte[]{-64};
        }
        return this.packRaw(iRubyObject.getRuntime(), iRubyObject);
    }

    public byte[] packRaw(Ruby ruby, IRubyObject iRubyObject) throws IOException {
        return this.packRaw(ruby, iRubyObject, null);
    }

    public byte[] packRaw(Ruby ruby, IRubyObject iRubyObject, RubyHash rubyHash) throws IOException {
        return this.packRaw(iRubyObject, new CompiledOptions(ruby, rubyHash));
    }

    byte[] packRaw(IRubyObject iRubyObject, CompiledOptions compiledOptions) throws IOException {
        BufferPacker bufferPacker = this.msgPack.createBufferPacker();
        this.write(bufferPacker, iRubyObject, compiledOptions);
        return bufferPacker.toByteArray();
    }

    private void write(BufferPacker bufferPacker, IRubyObject iRubyObject, CompiledOptions compiledOptions) throws IOException {
        if (iRubyObject == null || iRubyObject instanceof RubyNil) {
            bufferPacker.writeNil();
        } else if (iRubyObject instanceof RubyBoolean) {
            bufferPacker.write(((RubyBoolean)iRubyObject).isTrue());
        } else if (iRubyObject instanceof RubyBignum) {
            this.write(bufferPacker, (RubyBignum)iRubyObject);
        } else if (iRubyObject instanceof RubyInteger) {
            this.write(bufferPacker, (RubyInteger)iRubyObject);
        } else if (iRubyObject instanceof RubyFixnum) {
            this.write(bufferPacker, (RubyFixnum)iRubyObject);
        } else if (iRubyObject instanceof RubyFloat) {
            this.write(bufferPacker, (RubyFloat)iRubyObject);
        } else if (iRubyObject instanceof RubyString) {
            this.write(bufferPacker, (RubyString)iRubyObject, compiledOptions);
        } else if (iRubyObject instanceof RubySymbol) {
            this.write(bufferPacker, (RubySymbol)iRubyObject, compiledOptions);
        } else if (iRubyObject instanceof RubyArray) {
            this.write(bufferPacker, (RubyArray)iRubyObject, compiledOptions);
        } else if (iRubyObject instanceof RubyHash) {
            this.write(bufferPacker, (RubyHash)iRubyObject, compiledOptions);
        } else {
            throw iRubyObject.getRuntime().newArgumentError(String.format("Cannot pack type: %s", iRubyObject.getClass().getName()));
        }
    }

    private void write(BufferPacker bufferPacker, RubyBignum rubyBignum) throws IOException {
        bufferPacker.write(rubyBignum.getBigIntegerValue());
    }

    private void write(BufferPacker bufferPacker, RubyInteger rubyInteger) throws IOException {
        bufferPacker.write(rubyInteger.getLongValue());
    }

    private void write(BufferPacker bufferPacker, RubyFixnum rubyFixnum) throws IOException {
        bufferPacker.write(rubyFixnum.getLongValue());
    }

    private void write(BufferPacker bufferPacker, RubyFloat rubyFloat) throws IOException {
        bufferPacker.write(rubyFloat.getDoubleValue());
    }

    private void write(BufferPacker bufferPacker, RubyString rubyString, CompiledOptions compiledOptions) throws IOException {
        if (compiledOptions.encoding != null && rubyString.getEncoding() != compiledOptions.encoding) {
            Ruby ruby = rubyString.getRuntime();
            rubyString = (RubyString)rubyString.encode(ruby.getCurrentContext(), (IRubyObject)RubyEncoding.newEncoding((Ruby)ruby, (Encoding)compiledOptions.encoding));
        }
        bufferPacker.write(rubyString.getBytes());
    }

    private void write(BufferPacker bufferPacker, RubySymbol rubySymbol, CompiledOptions compiledOptions) throws IOException {
        this.write(bufferPacker, rubySymbol.asString(), compiledOptions);
    }

    private void write(BufferPacker bufferPacker, RubyArray rubyArray, CompiledOptions compiledOptions) throws IOException {
        int n = rubyArray.size();
        bufferPacker.writeArrayBegin(n);
        for (int i = 0; i < n; ++i) {
            this.write(bufferPacker, (IRubyObject)((RubyObject)rubyArray.entry(i)), compiledOptions);
        }
        bufferPacker.writeArrayEnd();
    }

    private void write(BufferPacker bufferPacker, RubyHash rubyHash, CompiledOptions compiledOptions) throws IOException {
        int n = rubyHash.size();
        bufferPacker.writeMapBegin(n);
        RubyArray rubyArray = rubyHash.keys();
        RubyArray rubyArray2 = rubyHash.rb_values();
        for (int i = 0; i < n; ++i) {
            this.write(bufferPacker, (IRubyObject)((RubyObject)rubyArray.entry(i)), compiledOptions);
            this.write(bufferPacker, (IRubyObject)((RubyObject)rubyArray2.entry(i)), compiledOptions);
        }
        bufferPacker.writeMapEnd();
    }

    static class CompiledOptions {
        public final Encoding encoding;

        public CompiledOptions(Ruby ruby, RubyHash rubyHash) {
            EncodingService encodingService = ruby.getEncodingService();
            Encoding encoding = null;
            if (rubyHash != null) {
                IRubyObject iRubyObject = rubyHash.fastARef((IRubyObject)ruby.newSymbol("encoding"));
                encoding = encodingService.getEncodingFromObject(iRubyObject);
            }
            if (encoding == null) {
                encoding = ruby.getDefaultExternalEncoding();
            }
            this.encoding = encoding != encodingService.getAscii8bitEncoding() ? encoding : null;
        }
    }
}

