/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene410;

import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.DirectReader;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;

class Lucene410DocValuesProducer
extends DocValuesProducer
implements Closeable {
    private final Map<Integer, NumericEntry> numerics;
    private final Map<Integer, BinaryEntry> binaries;
    private final Map<Integer, SortedSetEntry> sortedSets;
    private final Map<Integer, SortedSetEntry> sortedNumerics;
    private final Map<Integer, NumericEntry> ords;
    private final Map<Integer, NumericEntry> ordIndexes;
    private final AtomicLong ramBytesUsed;
    private final IndexInput data;
    private final int maxDoc;
    private final int version;
    private final Map<Integer, MonotonicBlockPackedReader> addressInstances;
    private final Map<Integer, MonotonicBlockPackedReader> ordIndexInstances;
    private final Map<Integer, ReverseTermsIndex> reverseIndexInstances;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Lucene410DocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        block7: {
            boolean success;
            block8: {
                ChecksumIndexInput in;
                block6: {
                    this.addressInstances = new HashMap<Integer, MonotonicBlockPackedReader>();
                    this.ordIndexInstances = new HashMap<Integer, MonotonicBlockPackedReader>();
                    this.reverseIndexInstances = new HashMap<Integer, ReverseTermsIndex>();
                    String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
                    in = state.directory.openChecksumInput(metaName, state.context);
                    this.maxDoc = state.segmentInfo.getDocCount();
                    success = false;
                    try {
                        this.version = CodecUtil.checkHeader(in, metaCodec, 0, 0);
                        this.numerics = new HashMap<Integer, NumericEntry>();
                        this.ords = new HashMap<Integer, NumericEntry>();
                        this.ordIndexes = new HashMap<Integer, NumericEntry>();
                        this.binaries = new HashMap<Integer, BinaryEntry>();
                        this.sortedSets = new HashMap<Integer, SortedSetEntry>();
                        this.sortedNumerics = new HashMap<Integer, SortedSetEntry>();
                        this.readFields(in, state.fieldInfos);
                        CodecUtil.checkFooter(in);
                        success = true;
                        if (!success) break block6;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            IOUtils.close(in);
                            throw throwable;
                        }
                        IOUtils.closeWhileHandlingException(in);
                        throw throwable;
                    }
                    IOUtils.close(in);
                    break block8;
                }
                IOUtils.closeWhileHandlingException(in);
            }
            String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
            this.data = state.directory.openInput(dataName, state.context);
            success = false;
            try {
                int version2 = CodecUtil.checkHeader(this.data, dataCodec, 0, 0);
                if (this.version != version2) {
                    throw new CorruptIndexException("Format versions mismatch");
                }
                CodecUtil.retrieveChecksum(this.data);
                success = true;
                if (success) break block7;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException(this.data);
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(this.data);
        }
        this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(this.getClass()));
    }

    private void readSortedField(int fieldNumber, IndexInput meta, FieldInfos infos) throws IOException {
        if (meta.readVInt() != fieldNumber) {
            throw new CorruptIndexException("sorted entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        if (meta.readByte() != 1) {
            throw new CorruptIndexException("sorted entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        BinaryEntry b = Lucene410DocValuesProducer.readBinaryEntry(meta);
        this.binaries.put(fieldNumber, b);
        if (meta.readVInt() != fieldNumber) {
            throw new CorruptIndexException("sorted entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sorted entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        NumericEntry n = Lucene410DocValuesProducer.readNumericEntry(meta);
        this.ords.put(fieldNumber, n);
    }

    private void readSortedSetFieldWithAddresses(int fieldNumber, IndexInput meta, FieldInfos infos) throws IOException {
        if (meta.readVInt() != fieldNumber) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        if (meta.readByte() != 1) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        BinaryEntry b = Lucene410DocValuesProducer.readBinaryEntry(meta);
        this.binaries.put(fieldNumber, b);
        if (meta.readVInt() != fieldNumber) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        NumericEntry n1 = Lucene410DocValuesProducer.readNumericEntry(meta);
        this.ords.put(fieldNumber, n1);
        if (meta.readVInt() != fieldNumber) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
        }
        NumericEntry n2 = Lucene410DocValuesProducer.readNumericEntry(meta);
        this.ordIndexes.put(fieldNumber, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            SortedSetEntry ss;
            if (infos.fieldInfo(fieldNumber) == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber + " (resource=" + meta + ")");
            }
            byte type = meta.readByte();
            if (type == 0) {
                this.numerics.put(fieldNumber, Lucene410DocValuesProducer.readNumericEntry(meta));
            } else if (type == 1) {
                BinaryEntry b = Lucene410DocValuesProducer.readBinaryEntry(meta);
                this.binaries.put(fieldNumber, b);
            } else if (type == 2) {
                this.readSortedField(fieldNumber, meta, infos);
            } else if (type == 3) {
                ss = this.readSortedSetEntry(meta);
                this.sortedSets.put(fieldNumber, ss);
                if (ss.format == 0) {
                    this.readSortedSetFieldWithAddresses(fieldNumber, meta, infos);
                } else {
                    if (ss.format != 1) throw new AssertionError();
                    if (meta.readVInt() != fieldNumber) {
                        throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
                    }
                    if (meta.readByte() != 2) {
                        throw new CorruptIndexException("sortedset entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
                    }
                    this.readSortedField(fieldNumber, meta, infos);
                }
            } else {
                if (type != 4) throw new CorruptIndexException("invalid type: " + type + ", resource=" + meta);
                ss = this.readSortedSetEntry(meta);
                this.sortedNumerics.put(fieldNumber, ss);
                if (meta.readVInt() != fieldNumber) {
                    throw new CorruptIndexException("sortednumeric entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
                }
                if (meta.readByte() != 0) {
                    throw new CorruptIndexException("sortednumeric entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
                }
                this.numerics.put(fieldNumber, Lucene410DocValuesProducer.readNumericEntry(meta));
                if (ss.format == 0) {
                    if (meta.readVInt() != fieldNumber) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
                    }
                    if (meta.readByte() != 0) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + fieldNumber + " is corrupt (resource=" + meta + ")");
                    }
                    NumericEntry ordIndex = Lucene410DocValuesProducer.readNumericEntry(meta);
                    this.ordIndexes.put(fieldNumber, ordIndex);
                } else if (ss.format != 1) {
                    throw new AssertionError();
                }
            }
            fieldNumber = meta.readVInt();
        }
    }

    static NumericEntry readNumericEntry(IndexInput meta) throws IOException {
        NumericEntry entry = new NumericEntry();
        entry.format = meta.readVInt();
        entry.missingOffset = meta.readLong();
        entry.offset = meta.readLong();
        entry.count = meta.readVLong();
        switch (entry.format) {
            case 1: {
                entry.minValue = meta.readLong();
                entry.gcd = meta.readLong();
                entry.bitsPerValue = meta.readVInt();
                break;
            }
            case 2: {
                int uniqueValues = meta.readVInt();
                if (uniqueValues > 256) {
                    throw new CorruptIndexException("TABLE_COMPRESSED cannot have more than 256 distinct values, input=" + meta);
                }
                entry.table = new long[uniqueValues];
                for (int i = 0; i < uniqueValues; ++i) {
                    entry.table[i] = meta.readLong();
                }
                entry.bitsPerValue = meta.readVInt();
                break;
            }
            case 0: {
                entry.minValue = meta.readLong();
                entry.bitsPerValue = meta.readVInt();
                break;
            }
            case 3: {
                entry.packedIntsVersion = meta.readVInt();
                entry.blockSize = meta.readVInt();
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + entry.format + ", input=" + meta);
            }
        }
        entry.endOffset = meta.readLong();
        return entry;
    }

    static BinaryEntry readBinaryEntry(IndexInput meta) throws IOException {
        BinaryEntry entry = new BinaryEntry();
        entry.format = meta.readVInt();
        entry.missingOffset = meta.readLong();
        entry.minLength = meta.readVInt();
        entry.maxLength = meta.readVInt();
        entry.count = meta.readVLong();
        entry.offset = meta.readLong();
        switch (entry.format) {
            case 0: {
                break;
            }
            case 2: {
                entry.addressesOffset = meta.readLong();
                entry.packedIntsVersion = meta.readVInt();
                entry.blockSize = meta.readVInt();
                entry.reverseIndexOffset = meta.readLong();
                break;
            }
            case 1: {
                entry.addressesOffset = meta.readLong();
                entry.packedIntsVersion = meta.readVInt();
                entry.blockSize = meta.readVInt();
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + entry.format + ", input=" + meta);
            }
        }
        return entry;
    }

    SortedSetEntry readSortedSetEntry(IndexInput meta) throws IOException {
        SortedSetEntry entry = new SortedSetEntry();
        entry.format = meta.readVInt();
        if (entry.format != 1 && entry.format != 0) {
            throw new CorruptIndexException("Unknown format: " + entry.format + ", input=" + meta);
        }
        return entry;
    }

    @Override
    public NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericEntry entry = this.numerics.get(field.number);
        return this.getNumeric(entry);
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.data);
    }

    LongValues getNumeric(NumericEntry entry) throws IOException {
        RandomAccessInput slice = this.data.randomAccessSlice(entry.offset, entry.endOffset - entry.offset);
        switch (entry.format) {
            case 0: {
                final long delta = entry.minValue;
                final LongValues values = DirectReader.getInstance(slice, entry.bitsPerValue);
                return new LongValues(){

                    @Override
                    public long get(long id) {
                        return delta + values.get(id);
                    }
                };
            }
            case 1: {
                final long min = entry.minValue;
                final long mult = entry.gcd;
                final LongValues quotientReader = DirectReader.getInstance(slice, entry.bitsPerValue);
                return new LongValues(){

                    @Override
                    public long get(long id) {
                        return min + mult * quotientReader.get(id);
                    }
                };
            }
            case 2: {
                final long[] table = entry.table;
                final LongValues ords = DirectReader.getInstance(slice, entry.bitsPerValue);
                return new LongValues(){

                    @Override
                    public long get(long id) {
                        return table[(int)ords.get(id)];
                    }
                };
            }
        }
        throw new AssertionError();
    }

    @Override
    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        BinaryEntry bytes = this.binaries.get(field.number);
        switch (bytes.format) {
            case 0: {
                return this.getFixedBinary(field, bytes);
            }
            case 1: {
                return this.getVariableBinary(field, bytes);
            }
            case 2: {
                return this.getCompressedBinary(field, bytes);
            }
        }
        throw new AssertionError();
    }

    private BinaryDocValues getFixedBinary(FieldInfo field, BinaryEntry bytes) throws IOException {
        final IndexInput data = this.data.slice("fixed-binary", bytes.offset, bytes.count * (long)bytes.maxLength);
        final BytesRef term = new BytesRef(bytes.maxLength);
        final byte[] buffer = term.bytes;
        final int length = term.length = bytes.maxLength;
        return new LongBinaryDocValues(){

            @Override
            public BytesRef get(long id) {
                try {
                    data.seek(id * (long)length);
                    data.readBytes(buffer, 0, buffer.length);
                    return term;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private synchronized MonotonicBlockPackedReader getAddressInstance(FieldInfo field, BinaryEntry bytes) throws IOException {
        MonotonicBlockPackedReader addresses = this.addressInstances.get(field.number);
        if (addresses == null) {
            this.data.seek(bytes.addressesOffset);
            addresses = MonotonicBlockPackedReader.of(this.data, bytes.packedIntsVersion, bytes.blockSize, bytes.count + 1L, false);
            this.addressInstances.put(field.number, addresses);
            this.ramBytesUsed.addAndGet(addresses.ramBytesUsed() + 4L);
        }
        return addresses;
    }

    private BinaryDocValues getVariableBinary(FieldInfo field, BinaryEntry bytes) throws IOException {
        final MonotonicBlockPackedReader addresses = this.getAddressInstance(field, bytes);
        final IndexInput data = this.data.slice("var-binary", bytes.offset, bytes.addressesOffset - bytes.offset);
        final BytesRef term = new BytesRef(Math.max(0, bytes.maxLength));
        final byte[] buffer = term.bytes;
        return new LongBinaryDocValues(){

            @Override
            public BytesRef get(long id) {
                long startAddress = addresses.get(id);
                long endAddress = addresses.get(id + 1L);
                int length = (int)(endAddress - startAddress);
                try {
                    data.seek(startAddress);
                    data.readBytes(buffer, 0, length);
                    term.length = length;
                    return term;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private synchronized MonotonicBlockPackedReader getIntervalInstance(FieldInfo field, BinaryEntry bytes) throws IOException {
        MonotonicBlockPackedReader addresses = this.addressInstances.get(field.number);
        if (addresses == null) {
            this.data.seek(bytes.addressesOffset);
            long size = bytes.count + 15L >>> 4;
            addresses = MonotonicBlockPackedReader.of(this.data, bytes.packedIntsVersion, bytes.blockSize, size, false);
            this.addressInstances.put(field.number, addresses);
            this.ramBytesUsed.addAndGet(addresses.ramBytesUsed() + 4L);
        }
        return addresses;
    }

    private synchronized ReverseTermsIndex getReverseIndexInstance(FieldInfo field, BinaryEntry bytes) throws IOException {
        ReverseTermsIndex index = this.reverseIndexInstances.get(field.number);
        if (index == null) {
            index = new ReverseTermsIndex();
            this.data.seek(bytes.reverseIndexOffset);
            long size = bytes.count + 1023L >>> 10;
            index.termAddresses = MonotonicBlockPackedReader.of(this.data, bytes.packedIntsVersion, bytes.blockSize, size, false);
            long dataSize = this.data.readVLong();
            PagedBytes pagedBytes = new PagedBytes(15);
            pagedBytes.copy(this.data, dataSize);
            index.terms = pagedBytes.freeze(true);
            this.reverseIndexInstances.put(field.number, index);
            this.ramBytesUsed.addAndGet(index.termAddresses.ramBytesUsed() + index.terms.ramBytesUsed());
        }
        return index;
    }

    private BinaryDocValues getCompressedBinary(FieldInfo field, BinaryEntry bytes) throws IOException {
        MonotonicBlockPackedReader addresses = this.getIntervalInstance(field, bytes);
        ReverseTermsIndex index = this.getReverseIndexInstance(field, bytes);
        assert (addresses.size() > 0L);
        IndexInput slice = this.data.slice("terms", bytes.offset, bytes.addressesOffset - bytes.offset);
        return new CompressedBinaryDocValues(bytes, addresses, index, slice);
    }

    @Override
    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        final int valueCount = (int)this.binaries.get((Object)Integer.valueOf((int)field.number)).count;
        final BinaryDocValues binary = this.getBinary(field);
        NumericEntry entry = this.ords.get(field.number);
        final LongValues ordinals = this.getNumeric(entry);
        return new SortedDocValues(){

            @Override
            public int getOrd(int docID) {
                return (int)ordinals.get(docID);
            }

            @Override
            public BytesRef lookupOrd(int ord) {
                return binary.get(ord);
            }

            @Override
            public int getValueCount() {
                return valueCount;
            }

            @Override
            public int lookupTerm(BytesRef key) {
                if (binary instanceof CompressedBinaryDocValues) {
                    return (int)((CompressedBinaryDocValues)binary).lookupTerm(key);
                }
                return super.lookupTerm(key);
            }

            @Override
            public TermsEnum termsEnum() {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).getTermsEnum();
                }
                return super.termsEnum();
            }
        };
    }

    private synchronized MonotonicBlockPackedReader getOrdIndexInstance(FieldInfo field, NumericEntry entry) throws IOException {
        MonotonicBlockPackedReader instance = this.ordIndexInstances.get(field.number);
        if (instance == null) {
            this.data.seek(entry.offset);
            instance = MonotonicBlockPackedReader.of(this.data, entry.packedIntsVersion, entry.blockSize, entry.count + 1L, false);
            this.ordIndexInstances.put(field.number, instance);
            this.ramBytesUsed.addAndGet(instance.ramBytesUsed() + 4L);
        }
        return instance;
    }

    @Override
    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        SortedSetEntry ss = this.sortedNumerics.get(field.number);
        NumericEntry numericEntry = this.numerics.get(field.number);
        final LongValues values = this.getNumeric(numericEntry);
        if (ss.format == 1) {
            Bits docsWithField = this.getMissingBits(numericEntry.missingOffset);
            return DocValues.singleton(values, docsWithField);
        }
        if (ss.format == 0) {
            final MonotonicBlockPackedReader ordIndex = this.getOrdIndexInstance(field, this.ordIndexes.get(field.number));
            return new SortedNumericDocValues(){
                long startOffset;
                long endOffset;

                @Override
                public void setDocument(int doc) {
                    this.startOffset = ordIndex.get(doc);
                    this.endOffset = ordIndex.get((long)doc + 1L);
                }

                @Override
                public long valueAt(int index) {
                    return values.get(this.startOffset + (long)index);
                }

                @Override
                public int count() {
                    return (int)(this.endOffset - this.startOffset);
                }
            };
        }
        throw new AssertionError();
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        SortedSetEntry ss = this.sortedSets.get(field.number);
        if (ss.format == 1) {
            SortedDocValues values = this.getSorted(field);
            return DocValues.singleton(values);
        }
        if (ss.format != 0) {
            throw new AssertionError();
        }
        final long valueCount = this.binaries.get((Object)Integer.valueOf((int)field.number)).count;
        final LongBinaryDocValues binary = (LongBinaryDocValues)this.getBinary(field);
        final LongValues ordinals = this.getNumeric(this.ords.get(field.number));
        final MonotonicBlockPackedReader ordIndex = this.getOrdIndexInstance(field, this.ordIndexes.get(field.number));
        return new RandomAccessOrds(){
            long startOffset;
            long offset;
            long endOffset;

            @Override
            public long nextOrd() {
                if (this.offset == this.endOffset) {
                    return -1L;
                }
                long ord = ordinals.get(this.offset);
                ++this.offset;
                return ord;
            }

            @Override
            public void setDocument(int docID) {
                this.startOffset = this.offset = ordIndex.get(docID);
                this.endOffset = ordIndex.get((long)docID + 1L);
            }

            @Override
            public BytesRef lookupOrd(long ord) {
                return binary.get(ord);
            }

            @Override
            public long getValueCount() {
                return valueCount;
            }

            @Override
            public long lookupTerm(BytesRef key) {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).lookupTerm(key);
                }
                return super.lookupTerm(key);
            }

            @Override
            public TermsEnum termsEnum() {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).getTermsEnum();
                }
                return super.termsEnum();
            }

            @Override
            public long ordAt(int index) {
                return ordinals.get(this.startOffset + (long)index);
            }

            @Override
            public int cardinality() {
                return (int)(this.endOffset - this.startOffset);
            }
        };
    }

    private Bits getMissingBits(long offset) throws IOException {
        if (offset == -1L) {
            return new Bits.MatchAllBits(this.maxDoc);
        }
        int length = (int)((long)this.maxDoc + 7L >>> 3);
        final RandomAccessInput in = this.data.randomAccessSlice(offset, length);
        return new Bits(){

            @Override
            public boolean get(int index) {
                try {
                    return (in.readByte(index >> 3) & 1 << (index & 7)) != 0;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public int length() {
                return Lucene410DocValuesProducer.this.maxDoc;
            }
        };
    }

    @Override
    public Bits getDocsWithField(FieldInfo field) throws IOException {
        switch (field.getDocValuesType()) {
            case SORTED_SET: {
                return DocValues.docsWithValue(this.getSortedSet(field), this.maxDoc);
            }
            case SORTED_NUMERIC: {
                return DocValues.docsWithValue(this.getSortedNumeric(field), this.maxDoc);
            }
            case SORTED: {
                return DocValues.docsWithValue(this.getSorted(field), this.maxDoc);
            }
            case BINARY: {
                BinaryEntry be = this.binaries.get(field.number);
                return this.getMissingBits(be.missingOffset);
            }
            case NUMERIC: {
                NumericEntry ne = this.numerics.get(field.number);
                return this.getMissingBits(ne.missingOffset);
            }
        }
        throw new AssertionError();
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    static final class CompressedBinaryDocValues
    extends LongBinaryDocValues {
        final long numValues;
        final long numIndexValues;
        final int maxTermLength;
        final MonotonicBlockPackedReader addresses;
        final IndexInput data;
        final CompressedBinaryTermsEnum termsEnum;
        final PagedBytes.Reader reverseTerms;
        final MonotonicBlockPackedReader reverseAddresses;
        final long numReverseIndexValues;

        public CompressedBinaryDocValues(BinaryEntry bytes, MonotonicBlockPackedReader addresses, ReverseTermsIndex index, IndexInput data) throws IOException {
            this.maxTermLength = bytes.maxLength;
            this.numValues = bytes.count;
            this.addresses = addresses;
            this.numIndexValues = addresses.size();
            this.data = data;
            this.reverseTerms = index.terms;
            this.reverseAddresses = index.termAddresses;
            this.numReverseIndexValues = this.reverseAddresses.size();
            this.termsEnum = this.getTermsEnum(data);
        }

        @Override
        public BytesRef get(long id) {
            try {
                this.termsEnum.seekExact(id);
                return this.termsEnum.term();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        long lookupTerm(BytesRef key) {
            try {
                switch (this.termsEnum.seekCeil(key)) {
                    case FOUND: {
                        return this.termsEnum.ord();
                    }
                    case NOT_FOUND: {
                        return -this.termsEnum.ord() - 1L;
                    }
                }
                return -this.numValues - 1L;
            }
            catch (IOException bogus) {
                throw new RuntimeException(bogus);
            }
        }

        TermsEnum getTermsEnum() {
            try {
                return this.getTermsEnum(this.data.clone());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private CompressedBinaryTermsEnum getTermsEnum(IndexInput input) throws IOException {
            return new CompressedBinaryTermsEnum(input);
        }

        class CompressedBinaryTermsEnum
        extends TermsEnum {
            private long currentOrd = -1L;
            private long currentBlockStart;
            private final IndexInput input;
            private final int[] offsets = new int[16];
            private final byte[] buffer = new byte[31];
            private final BytesRef term;
            private final BytesRef firstTerm;
            private final BytesRef scratch;

            CompressedBinaryTermsEnum(IndexInput input) throws IOException {
                this.term = new BytesRef(CompressedBinaryDocValues.this.maxTermLength);
                this.firstTerm = new BytesRef(CompressedBinaryDocValues.this.maxTermLength);
                this.scratch = new BytesRef();
                this.input = input;
                input.seek(0L);
            }

            private void readHeader() throws IOException {
                this.firstTerm.length = this.input.readVInt();
                this.input.readBytes(this.firstTerm.bytes, 0, this.firstTerm.length);
                this.input.readBytes(this.buffer, 0, 15);
                if (this.buffer[0] == -1) {
                    this.readShortAddresses();
                } else {
                    this.readByteAddresses();
                }
                this.currentBlockStart = this.input.getFilePointer();
            }

            private void readByteAddresses() throws IOException {
                int addr = 0;
                for (int i = 1; i < this.offsets.length; ++i) {
                    this.offsets[i] = addr += 2 + (this.buffer[i - 1] & 0xFF);
                }
            }

            private void readShortAddresses() throws IOException {
                this.input.readBytes(this.buffer, 15, 16);
                int addr = 0;
                for (int i = 1; i < this.offsets.length; ++i) {
                    int x = i << 1;
                    this.offsets[i] = addr += 2 + (this.buffer[x - 1] << 8 | this.buffer[x] & 0xFF);
                }
            }

            private void readFirstTerm() throws IOException {
                this.term.length = this.firstTerm.length;
                System.arraycopy(this.firstTerm.bytes, this.firstTerm.offset, this.term.bytes, 0, this.term.length);
            }

            private void readTerm(int offset) throws IOException {
                int start = this.input.readByte() & 0xFF;
                System.arraycopy(this.firstTerm.bytes, this.firstTerm.offset, this.term.bytes, 0, start);
                int suffix = this.offsets[offset] - this.offsets[offset - 1] - 1;
                this.input.readBytes(this.term.bytes, start, suffix);
                this.term.length = start + suffix;
            }

            @Override
            public BytesRef next() throws IOException {
                ++this.currentOrd;
                if (this.currentOrd >= CompressedBinaryDocValues.this.numValues) {
                    return null;
                }
                int offset = (int)(this.currentOrd & 0xFL);
                if (offset == 0) {
                    this.readHeader();
                    this.readFirstTerm();
                } else {
                    this.readTerm(offset);
                }
                return this.term;
            }

            long binarySearchIndex(BytesRef text) throws IOException {
                long low = 0L;
                long high = CompressedBinaryDocValues.this.numReverseIndexValues - 1L;
                while (low <= high) {
                    long mid = low + high >>> 1;
                    CompressedBinaryDocValues.this.reverseTerms.fill(this.scratch, CompressedBinaryDocValues.this.reverseAddresses.get(mid));
                    int cmp = this.scratch.compareTo(text);
                    if (cmp < 0) {
                        low = mid + 1L;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1L;
                        continue;
                    }
                    return mid;
                }
                return high;
            }

            long binarySearchBlock(BytesRef text, long low, long high) throws IOException {
                while (low <= high) {
                    long mid = low + high >>> 1;
                    this.input.seek(CompressedBinaryDocValues.this.addresses.get(mid));
                    this.term.length = this.input.readVInt();
                    this.input.readBytes(this.term.bytes, 0, this.term.length);
                    int cmp = this.term.compareTo(text);
                    if (cmp < 0) {
                        low = mid + 1L;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1L;
                        continue;
                    }
                    return mid;
                }
                return high;
            }

            @Override
            public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
                long block;
                long indexPos = this.binarySearchIndex(text);
                if (indexPos < 0L) {
                    block = 0L;
                } else {
                    long low = indexPos << 6;
                    long high = Math.min(CompressedBinaryDocValues.this.numIndexValues - 1L, low + 63L);
                    block = Math.max(low, this.binarySearchBlock(text, low, high));
                }
                this.input.seek(CompressedBinaryDocValues.this.addresses.get(block));
                this.currentOrd = (block << 4) - 1L;
                while (this.next() != null) {
                    int cmp = this.term.compareTo(text);
                    if (cmp == 0) {
                        return TermsEnum.SeekStatus.FOUND;
                    }
                    if (cmp <= 0) continue;
                    return TermsEnum.SeekStatus.NOT_FOUND;
                }
                return TermsEnum.SeekStatus.END;
            }

            @Override
            public void seekExact(long ord) throws IOException {
                long block = ord >>> 4;
                if (block != this.currentOrd >>> 4) {
                    this.input.seek(CompressedBinaryDocValues.this.addresses.get(block));
                    this.readHeader();
                }
                this.currentOrd = ord;
                int offset = (int)(ord & 0xFL);
                if (offset == 0) {
                    this.readFirstTerm();
                } else {
                    this.input.seek(this.currentBlockStart + (long)this.offsets[offset - 1]);
                    this.readTerm(offset);
                }
            }

            @Override
            public BytesRef term() throws IOException {
                return this.term;
            }

            @Override
            public long ord() throws IOException {
                return this.currentOrd;
            }

            @Override
            public int docFreq() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public long totalTermFreq() throws IOException {
                return -1L;
            }

            @Override
            public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Comparator<BytesRef> getComparator() {
                return BytesRef.getUTF8SortedAsUnicodeComparator();
            }
        }
    }

    static class ReverseTermsIndex {
        public MonotonicBlockPackedReader termAddresses;
        public PagedBytes.Reader terms;

        ReverseTermsIndex() {
        }
    }

    static abstract class LongBinaryDocValues
    extends BinaryDocValues {
        LongBinaryDocValues() {
        }

        @Override
        public final BytesRef get(int docID) {
            return this.get((long)docID);
        }

        abstract BytesRef get(long var1);
    }

    static class SortedSetEntry {
        int format;

        private SortedSetEntry() {
        }
    }

    static class BinaryEntry {
        long missingOffset;
        long offset;
        int format;
        public long count;
        int minLength;
        int maxLength;
        public long addressesOffset;
        public long reverseIndexOffset;
        public int packedIntsVersion;
        public int blockSize;

        private BinaryEntry() {
        }
    }

    static class NumericEntry {
        long missingOffset;
        public long offset;
        public long endOffset;
        public int bitsPerValue;
        int format;
        public int packedIntsVersion;
        public long count;
        public int blockSize;
        long minValue;
        long gcd;
        long[] table;

        private NumericEntry() {
        }
    }
}

