/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public class StringMethodPropertyWriter
extends OptimizedBeanPropertyWriter<StringMethodPropertyWriter> {
    public StringMethodPropertyWriter(BeanPropertyWriter beanPropertyWriter, BeanPropertyAccessor beanPropertyAccessor, int n, JsonSerializer<Object> jsonSerializer) {
        super(beanPropertyWriter, beanPropertyAccessor, n, jsonSerializer);
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> jsonSerializer) {
        return new StringMethodPropertyWriter(this, this._propertyAccessor, this._propertyIndex, jsonSerializer);
    }

    @Override
    public StringMethodPropertyWriter withAccessor(BeanPropertyAccessor beanPropertyAccessor) {
        if (beanPropertyAccessor == null) {
            throw new IllegalArgumentException();
        }
        return new StringMethodPropertyWriter(this, beanPropertyAccessor, this._propertyIndex, this._serializer);
    }

    @Override
    public void unsafeSerializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        String string = this._propertyAccessor.stringGetter(object, this._propertyIndex);
        if (string == null) {
            if (!this._suppressNulls) {
                jsonGenerator.writeFieldName(this._name);
                serializerProvider.defaultSerializeNull(jsonGenerator);
            }
            return;
        }
        jsonGenerator.writeFieldName(this._name);
        jsonGenerator.writeString(string);
    }
}

