/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public final class IntMethodPropertyWriter
extends OptimizedBeanPropertyWriter<IntMethodPropertyWriter> {
    private final int _suppressableInt;
    private final boolean _suppressableIntSet;

    public IntMethodPropertyWriter(BeanPropertyWriter beanPropertyWriter, BeanPropertyAccessor beanPropertyAccessor, int n, JsonSerializer<Object> jsonSerializer) {
        super(beanPropertyWriter, beanPropertyAccessor, n, jsonSerializer);
        if (this._suppressableValue != null && this._suppressableValue instanceof Integer) {
            this._suppressableInt = (Integer)this._suppressableValue;
            this._suppressableIntSet = true;
        } else {
            this._suppressableInt = 0;
            this._suppressableIntSet = false;
        }
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> jsonSerializer) {
        return new IntMethodPropertyWriter(this, this._propertyAccessor, this._propertyIndex, jsonSerializer);
    }

    @Override
    public IntMethodPropertyWriter withAccessor(BeanPropertyAccessor beanPropertyAccessor) {
        if (beanPropertyAccessor == null) {
            throw new IllegalArgumentException();
        }
        return new IntMethodPropertyWriter(this, beanPropertyAccessor, this._propertyIndex, this._serializer);
    }

    @Override
    public void unsafeSerializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        int n = this._propertyAccessor.intGetter(object, this._propertyIndex);
        if (!this._suppressableIntSet || this._suppressableInt != n) {
            jsonGenerator.writeFieldName(this._name);
            jsonGenerator.writeNumber(n);
        }
    }
}

