/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import nokogiri.internals.NokogiriEncodingReaderWrapper;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.UncloseableInputStream;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.TypeConverter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ParserContext
extends RubyObject {
    protected InputSource source = null;
    protected IRubyObject detected_encoding = null;
    protected int stringDataSize = -1;

    public ParserContext(Ruby ruby) {
        super(ruby, ruby.getObject());
    }

    public ParserContext(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    protected InputSource getInputSource() {
        return this.source;
    }

    public void setInputSource(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Object object;
        this.source = new InputSource();
        Ruby ruby = threadContext.getRuntime();
        ParserContext.setUrl(threadContext, this.source, iRubyObject2);
        if (this.setEncoding(threadContext, iRubyObject)) {
            return;
        }
        RubyString rubyString = null;
        if (Helpers.invoke((ThreadContext)threadContext, (IRubyObject)iRubyObject, (String)"respond_to?", (IRubyObject)ruby.newSymbol("to_io").to_sym()).isTrue()) {
            object = (RubyIO)TypeConverter.convertToType((IRubyObject)iRubyObject, (RubyClass)ruby.getIO(), (String)"to_io");
            this.source.setByteStream(new UncloseableInputStream(object.getInStream()));
        } else if (Helpers.invoke((ThreadContext)threadContext, (IRubyObject)iRubyObject, (String)"respond_to?", (IRubyObject)ruby.newSymbol("string").to_sym()).isTrue()) {
            rubyString = Helpers.invoke((ThreadContext)threadContext, (IRubyObject)iRubyObject, (String)"string").convertToString();
        } else if (iRubyObject instanceof RubyString) {
            rubyString = (RubyString)iRubyObject;
        } else {
            throw ruby.newArgumentError("must be kind_of String or respond to :to_io or :string");
        }
        if (rubyString != null) {
            object = null;
            if (rubyString.encoding(threadContext) != null) {
                object = rubyString.encoding(threadContext).toString();
            }
            Charset charset = null;
            if (object != null) {
                try {
                    charset = Charset.forName((String)object);
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    // empty catch block
                }
            }
            ByteList byteList = rubyString.getByteList();
            if (charset != null) {
                StringReader stringReader = new StringReader(new String(byteList.unsafeBytes(), byteList.begin(), byteList.length(), charset));
                this.source.setCharacterStream(stringReader);
                this.source.setEncoding(charset.name());
            } else {
                this.stringDataSize = byteList.length() - byteList.begin();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteList.unsafeBytes(), byteList.begin(), byteList.length());
                this.source.setByteStream(byteArrayInputStream);
            }
        }
    }

    public static void setUrl(ThreadContext threadContext, InputSource inputSource, IRubyObject iRubyObject) {
        String string = NokogiriHelpers.rubyStringToString(iRubyObject);
        if (string != null) {
            try {
                URI uRI = URI.create(string);
                inputSource.setSystemId(uRI.toURL().toString());
            }
            catch (Exception exception) {
                String string2;
                File file = new File(string);
                if (file.isAbsolute()) {
                    inputSource.setSystemId(string);
                }
                String string3 = threadContext.getRuntime().getCurrentDirectory();
                try {
                    string2 = new File(string3, string).getCanonicalPath();
                }
                catch (IOException iOException) {
                    string2 = new File(string3, string).getAbsolutePath();
                }
                inputSource.setSystemId(string2);
            }
        }
    }

    private boolean setEncoding(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject.getType().respondsTo("detect_encoding")) {
            NokogiriEncodingReaderWrapper nokogiriEncodingReaderWrapper = new NokogiriEncodingReaderWrapper(threadContext, (RubyObject)iRubyObject);
            this.source.setByteStream(nokogiriEncodingReaderWrapper);
            if (nokogiriEncodingReaderWrapper.detectEncoding()) {
                this.detected_encoding = nokogiriEncodingReaderWrapper.getEncoding();
                this.source.setEncoding(this.detected_encoding.asJavaString());
            }
            return true;
        }
        return false;
    }

    public void setInputSourceFile(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.source = new InputSource();
        ParserContext.setUrl(threadContext, this.source, iRubyObject);
    }

    public void setInputSource(InputStream inputStream) {
        this.source = new InputSource(inputStream);
    }

    public static class NokogiriXInlcudeEntityResolver
    implements EntityResolver {
        InputSource source;

        public NokogiriXInlcudeEntityResolver(InputSource inputSource) {
            this.source = inputSource;
        }

        @Override
        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (string2 != null) {
                this.source.setSystemId(string2);
            }
            if (string != null) {
                this.source.setPublicId(string);
            }
            return this.source;
        }
    }

    public static class Options {
        protected static final long STRICT = 0L;
        protected static final long RECOVER = 1L;
        protected static final long NOENT = 2L;
        protected static final long DTDLOAD = 4L;
        protected static final long DTDATTR = 8L;
        protected static final long DTDVALID = 16L;
        protected static final long NOERROR = 32L;
        protected static final long NOWARNING = 64L;
        protected static final long PEDANTIC = 128L;
        protected static final long NOBLANKS = 256L;
        protected static final long SAX1 = 512L;
        protected static final long XINCLUDE = 1024L;
        protected static final long NONET = 2048L;
        protected static final long NODICT = 4096L;
        protected static final long NSCLEAN = 8192L;
        protected static final long NOCDATA = 16384L;
        protected static final long NOXINCNODE = 32768L;
        public boolean strict;
        public boolean recover;
        public boolean noEnt;
        public boolean dtdLoad;
        public boolean dtdAttr;
        public boolean dtdValid;
        public boolean noError;
        public boolean noWarning;
        public boolean pedantic;
        public boolean noBlanks;
        public boolean sax1;
        public boolean xInclude;
        public boolean noNet;
        public boolean noDict;
        public boolean nsClean;
        public boolean noCdata;
        public boolean noXIncNode;

        protected static boolean test(long l, long l2) {
            return (l & l2) == l2;
        }

        public Options(long l) {
            this.strict = (l & 1L) == 0L;
            this.recover = Options.test(l, 1L);
            this.noEnt = Options.test(l, 2L);
            this.dtdLoad = Options.test(l, 4L);
            this.dtdAttr = Options.test(l, 8L);
            this.dtdValid = Options.test(l, 16L);
            this.noError = Options.test(l, 32L);
            this.noWarning = Options.test(l, 64L);
            this.pedantic = Options.test(l, 128L);
            this.noBlanks = Options.test(l, 256L);
            this.sax1 = Options.test(l, 512L);
            this.xInclude = Options.test(l, 1024L);
            this.noNet = Options.test(l, 2048L);
            this.noDict = Options.test(l, 4096L);
            this.nsClean = Options.test(l, 8192L);
            this.noCdata = Options.test(l, 16384L);
            this.noXIncNode = Options.test(l, 32768L);
        }
    }
}

