/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.util.LinkedList;
import nokogiri.XmlSyntaxError;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.XmlDeclHandler;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;

public class NokogiriHandler
extends DefaultHandler2
implements XmlDeclHandler {
    private StringBuffer buffer;
    private final Ruby ruby;
    private final RubyClass attrClass;
    private final IRubyObject object;
    private final LinkedList<XmlSyntaxError> errors = new LinkedList();
    private Locator locator;
    private static String htmlParserName = "Nokogiri::HTML::SAX::Parser";
    private boolean needEmptyAttrCheck = false;
    private static String[] emptyAttrs = new String[]{"checked", "compact", "declare", "defer", "disabled", "ismap", "multiple", "noresize", "nohref", "noshade", "nowrap", "readonly", "selected"};

    public NokogiriHandler(Ruby ruby, IRubyObject iRubyObject) {
        this.ruby = ruby;
        this.attrClass = (RubyClass)ruby.getClassFromPath("Nokogiri::XML::SAX::Parser::Attribute");
        this.object = iRubyObject;
        String string = iRubyObject.getMetaClass().getName();
        if (htmlParserName.equals(string)) {
            this.needEmptyAttrCheck = true;
        }
    }

    @Override
    public void skippedEntity(String string) {
        this.call("error", (IRubyObject)this.ruby.newString("Entity '" + string + "' not defined\n"));
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.call("start_document");
    }

    @Override
    public void xmlDecl(String string, String string2, String string3) {
        this.call("xmldecl", NokogiriHelpers.stringOrNil(this.ruby, string), NokogiriHelpers.stringOrNil(this.ruby, string2), NokogiriHelpers.stringOrNil(this.ruby, string3));
    }

    @Override
    public void endDocument() throws SAXException {
        this.call("end_document");
    }

    @Override
    public void processingInstruction(String string, String string2) {
        this.call("processing_instruction", (IRubyObject)this.ruby.newString(string), (IRubyObject)this.ruby.newString(string2));
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        RubyArray rubyArray = RubyArray.newArray((Ruby)this.ruby);
        RubyArray rubyArray2 = RubyArray.newArray((Ruby)this.ruby);
        ThreadContext threadContext = this.ruby.getCurrentContext();
        boolean bl = false;
        for (int i = 0; i < attributes.getLength(); ++i) {
            IRubyObject[] iRubyObjectArray;
            String string4 = attributes.getURI(i);
            String string5 = attributes.getQName(i);
            String string6 = attributes.getLocalName(i);
            String string7 = attributes.getValue(i);
            String string8 = NokogiriHelpers.getPrefix(string5);
            if (string6 == null || string6.equals("")) {
                string6 = NokogiriHelpers.getLocalPart(string5);
            }
            if (NokogiriHelpers.isNamespace(string5) && !bl) {
                iRubyObjectArray = RubyArray.newArray((Ruby)this.ruby, (int)2);
                if (string6.equals("xmlns")) {
                    string6 = null;
                }
                iRubyObjectArray.add((Object)NokogiriHelpers.stringOrNil(this.ruby, string6));
                iRubyObjectArray.add((Object)this.ruby.newString(string7));
                rubyArray2.add((Object)iRubyObjectArray);
                continue;
            }
            iRubyObjectArray = null;
            if (this.needEmptyAttrCheck && this.isEmptyAttr(string6)) {
                iRubyObjectArray = new IRubyObject[]{NokogiriHelpers.stringOrNil(this.ruby, string6), NokogiriHelpers.stringOrNil(this.ruby, string8), NokogiriHelpers.stringOrNil(this.ruby, string4)};
            }
            if (iRubyObjectArray == null) {
                iRubyObjectArray = new IRubyObject[]{NokogiriHelpers.stringOrNil(this.ruby, string6), NokogiriHelpers.stringOrNil(this.ruby, string8), NokogiriHelpers.stringOrNil(this.ruby, string4), NokogiriHelpers.stringOrNil(this.ruby, string7)};
            }
            IRubyObject iRubyObject = RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)this.attrClass, (String)"new", (IRubyObject[])iRubyObjectArray);
            rubyArray.add((Object)iRubyObject);
        }
        if (string2 == null || string2.equals("")) {
            string2 = NokogiriHelpers.getLocalPart(string3);
        }
        this.call("start_element_namespace", NokogiriHelpers.stringOrNil(this.ruby, string2), (IRubyObject)rubyArray, NokogiriHelpers.stringOrNil(this.ruby, NokogiriHelpers.getPrefix(string3)), NokogiriHelpers.stringOrNil(this.ruby, string), (IRubyObject)rubyArray2);
    }

    private boolean isEmptyAttr(String string) {
        for (String string2 : emptyAttrs) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public Integer getLine() {
        return this.locator.getLineNumber();
    }

    public Integer getColumn() {
        return this.locator.getColumnNumber() - 1;
    }

    private boolean isFromFragmentHandler() {
        String string;
        RubyObject rubyObject;
        IRubyObject iRubyObject;
        return this.object != null && this.object instanceof RubyObject && (iRubyObject = (rubyObject = (RubyObject)this.object).getInstanceVariable("@document")) != null && "Nokogiri::XML::FragmentHandler".equals(string = iRubyObject.getMetaClass().getName());
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.call("end_element_namespace", NokogiriHelpers.stringOrNil(this.ruby, string2), NokogiriHelpers.stringOrNil(this.ruby, NokogiriHelpers.getPrefix(string3)), NokogiriHelpers.stringOrNil(this.ruby, string));
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.buffer != null) {
            this.buffer.append(new String(cArray, n, n2));
        } else {
            this.call("characters", (IRubyObject)this.ruby.newString(new String(cArray, n, n2)));
        }
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.call("comment", (IRubyObject)this.ruby.newString(new String(cArray, n, n2)));
    }

    @Override
    public void startCDATA() throws SAXException {
        this.buffer = new StringBuffer();
    }

    @Override
    public void endCDATA() throws SAXException {
        this.call("cdata_block", (IRubyObject)this.ruby.newString(this.buffer.toString()));
        this.buffer = null;
    }

    @Override
    public void error(SAXParseException sAXParseException) {
        this.addError(XmlSyntaxError.createError(this.ruby, sAXParseException));
        this.call("error", (IRubyObject)this.ruby.newString(sAXParseException.getMessage()));
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.addError(XmlSyntaxError.createFatalError(this.ruby, sAXParseException));
        this.call("error", (IRubyObject)this.ruby.newString(sAXParseException.getMessage()));
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        this.call("warning", (IRubyObject)this.ruby.newString(sAXParseException.getMessage()));
    }

    protected synchronized void addError(XmlSyntaxError xmlSyntaxError) {
        this.errors.add(xmlSyntaxError);
    }

    public synchronized int getErrorCount() {
        return this.errors.size();
    }

    public synchronized IRubyObject getLastError() {
        return (IRubyObject)this.errors.getLast();
    }

    private void call(String string) {
        ThreadContext threadContext = this.ruby.getCurrentContext();
        RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)this.document(threadContext), (String)string);
    }

    private void call(String string, IRubyObject iRubyObject) {
        ThreadContext threadContext = this.ruby.getCurrentContext();
        RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)this.document(threadContext), (String)string, (IRubyObject)iRubyObject);
    }

    private void call(String string, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        ThreadContext threadContext = this.ruby.getCurrentContext();
        RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)this.document(threadContext), (String)string, (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2);
    }

    private void call(String string, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        ThreadContext threadContext = this.ruby.getCurrentContext();
        RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)this.document(threadContext), (String)string, (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2, (IRubyObject)iRubyObject3);
    }

    private void call(String string, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, IRubyObject iRubyObject5) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[]{iRubyObject, iRubyObject2, iRubyObject3, iRubyObject4, iRubyObject5};
        ThreadContext threadContext = this.ruby.getCurrentContext();
        RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)this.document(threadContext), (String)string, (IRubyObject[])iRubyObjectArray);
    }

    private IRubyObject document(ThreadContext threadContext) {
        if (this.object instanceof RubyObject) {
            return ((RubyObject)this.object).fastGetInstanceVariable("@document");
        }
        return threadContext.getRuntime().getNil();
    }
}

