/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.bbox;

import com.spatial4j.core.shape.Rectangle;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.spatial.bbox.BBoxStrategy;
import org.apache.lucene.util.Bits;

class BBoxValueSource
extends ValueSource {
    private final BBoxStrategy strategy;

    public BBoxValueSource(BBoxStrategy strategy) {
        this.strategy = strategy;
    }

    public String description() {
        return "bboxShape(" + this.strategy.getFieldName() + ")";
    }

    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        AtomicReader reader = readerContext.reader();
        final NumericDocValues minX = DocValues.getNumeric((AtomicReader)reader, (String)this.strategy.field_minX);
        final NumericDocValues minY = DocValues.getNumeric((AtomicReader)reader, (String)this.strategy.field_minY);
        final NumericDocValues maxX = DocValues.getNumeric((AtomicReader)reader, (String)this.strategy.field_maxX);
        final NumericDocValues maxY = DocValues.getNumeric((AtomicReader)reader, (String)this.strategy.field_maxY);
        final Bits validBits = DocValues.getDocsWithField((AtomicReader)reader, (String)this.strategy.field_minX);
        final Rectangle rect = this.strategy.getSpatialContext().makeRectangle(0.0, 0.0, 0.0, 0.0);
        return new FunctionValues(){

            public Object objectVal(int doc) {
                if (!validBits.get(doc)) {
                    return null;
                }
                rect.reset(Double.longBitsToDouble(minX.get(doc)), Double.longBitsToDouble(maxX.get(doc)), Double.longBitsToDouble(minY.get(doc)), Double.longBitsToDouble(maxY.get(doc)));
                return rect;
            }

            public String strVal(int doc) {
                Object v = this.objectVal(doc);
                return v == null ? null : v.toString();
            }

            public boolean exists(int doc) {
                return validBits.get(doc);
            }

            public Explanation explain(int doc) {
                return new Explanation(Float.NaN, this.toString(doc));
            }

            public String toString(int doc) {
                return BBoxValueSource.this.description() + '=' + this.strVal(doc);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BBoxValueSource that = (BBoxValueSource)((Object)o);
        return this.strategy.equals(that.strategy);
    }

    public int hashCode() {
        return this.strategy.hashCode();
    }
}

