/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.ContextHolder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.transport.TransportAddress;

public abstract class TransportMessage<TM extends TransportMessage<TM>>
extends ContextHolder
implements Streamable {
    private Map<String, Object> headers;
    private TransportAddress remoteAddress;

    protected TransportMessage() {
    }

    protected TransportMessage(TM message) {
        if (((TransportMessage)message).headers != null) {
            this.headers = new HashMap<String, Object>(((TransportMessage)message).headers);
        }
        this.copyContextFrom((ContextHolder)message);
    }

    public void remoteAddress(TransportAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public TransportAddress remoteAddress() {
        return this.remoteAddress;
    }

    public final TM putHeader(String key, Object value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>();
        }
        this.headers.put(key, value);
        return (TM)this;
    }

    public final <V> V getHeader(String key) {
        return (V)(this.headers != null ? this.headers.get(key) : null);
    }

    public final boolean hasHeader(String key) {
        return this.headers != null && this.headers.containsKey(key);
    }

    public Set<String> getHeaders() {
        return this.headers != null ? this.headers.keySet() : Collections.emptySet();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.headers = in.readBoolean() ? in.readMap() : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.headers == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeMap(this.headers);
        }
    }
}

