/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.stats.AbstractTDigest;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.TDigestState;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

abstract class AbstractInternalPercentiles
extends InternalNumericMetricsAggregation.MultiValue {
    protected double[] keys;
    protected TDigestState state;
    private boolean keyed;

    AbstractInternalPercentiles() {
    }

    public AbstractInternalPercentiles(String name, double[] keys, TDigestState state, boolean keyed) {
        super(name);
        this.keys = keys;
        this.state = state;
        this.keyed = keyed;
    }

    @Override
    public double value(String name) {
        return this.value(Double.parseDouble(name));
    }

    public abstract double value(double var1);

    @Override
    public AbstractInternalPercentiles reduce(InternalAggregation.ReduceContext reduceContext) {
        List<InternalAggregation> aggregations = reduceContext.aggregations();
        AbstractTDigest merged = null;
        for (InternalAggregation aggregation : aggregations) {
            AbstractInternalPercentiles percentiles = (AbstractInternalPercentiles)aggregation;
            if (merged == null) {
                merged = new TDigestState(percentiles.state.compression());
            }
            merged.add(percentiles.state);
        }
        return this.createReduced(this.getName(), this.keys, (TDigestState)merged, this.keyed);
    }

    protected abstract AbstractInternalPercentiles createReduced(String var1, double[] var2, TDigestState var3, boolean var4);

    @Override
    public void readFrom(StreamInput in) throws IOException {
        byte id;
        this.name = in.readString();
        this.valueFormatter = ValueFormatterStreams.readOptional(in);
        if (in.getVersion().before(Version.V_1_2_0) && (id = in.readByte()) != 0) {
            throw new ElasticsearchIllegalArgumentException("Unexpected percentiles aggregator id [" + id + "]");
        }
        this.keys = new double[in.readInt()];
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = in.readDouble();
        }
        this.state = TDigestState.read(in);
        this.keyed = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        ValueFormatterStreams.writeOptional(this.valueFormatter, out);
        if (out.getVersion().before(Version.V_1_2_0)) {
            out.writeByte((byte)0);
        }
        out.writeInt(this.keys.length);
        for (int i = 0; i < this.keys.length; ++i) {
            out.writeDouble(this.keys[i]);
        }
        TDigestState.write(this.state, out);
        out.writeBoolean(this.keyed);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject(InternalAggregation.CommonFields.VALUES);
            for (int i = 0; i < this.keys.length; ++i) {
                String key = String.valueOf(this.keys[i]);
                double value = this.value(this.keys[i]);
                builder.field(key, value);
                if (this.valueFormatter == null) continue;
                builder.field(key + "_as_string", this.valueFormatter.format(value));
            }
            builder.endObject();
        } else {
            builder.startArray(InternalAggregation.CommonFields.VALUES);
            for (int i = 0; i < this.keys.length; ++i) {
                double value = this.value(this.keys[i]);
                builder.startObject();
                builder.field(InternalAggregation.CommonFields.KEY, this.keys[i]);
                builder.field(InternalAggregation.CommonFields.VALUE, value);
                if (this.valueFormatter != null) {
                    builder.field(InternalAggregation.CommonFields.VALUE_AS_STRING, this.valueFormatter.format(value));
                }
                builder.endObject();
            }
            builder.endArray();
        }
        return builder;
    }
}

