/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.text.BytesText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;

public class StringTerms
extends InternalTerms {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("terms", "sterms");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public StringTerms readResult(StreamInput in) throws IOException {
            StringTerms buckets = new StringTerms();
            buckets.readFrom(in);
            return buckets;
        }
    };

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    StringTerms() {
    }

    public StringTerms(String name, InternalOrder order, int requiredSize, int shardSize, long minDocCount, List<InternalTerms.Bucket> buckets, boolean showTermDocCountError, long docCountError, long otherDocCount) {
        super(name, order, requiredSize, shardSize, minDocCount, buckets, showTermDocCountError, docCountError, otherDocCount);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    protected InternalTerms newAggregation(String name, List<InternalTerms.Bucket> buckets, boolean showTermDocCountError, long docCountError, long otherDocCount) {
        return new StringTerms(name, this.order, this.requiredSize, this.shardSize, this.minDocCount, buckets, showTermDocCountError, docCountError, otherDocCount);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.docCountError = in.getVersion().onOrAfter(Version.V_1_4_0_Beta1) ? in.readLong() : -1L;
        this.order = InternalOrder.Streams.readOrder(in);
        this.requiredSize = StringTerms.readSize(in);
        if (in.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            this.shardSize = StringTerms.readSize(in);
            this.showTermDocCountError = in.readBoolean();
        } else {
            this.shardSize = this.requiredSize;
            this.showTermDocCountError = false;
        }
        this.minDocCount = in.readVLong();
        if (in.getVersion().onOrAfter(Version.V_1_4_0)) {
            this.otherDocCount = in.readVLong();
        }
        int size = in.readVInt();
        ArrayList<Bucket> buckets = new ArrayList<Bucket>(size);
        for (int i = 0; i < size; ++i) {
            BytesRef termBytes = in.readBytesRef();
            long docCount = in.readVLong();
            long bucketDocCountError = -1L;
            if (in.getVersion().onOrAfter(Version.V_1_4_0_Beta1) && this.showTermDocCountError) {
                bucketDocCountError = in.readLong();
            }
            InternalAggregations aggregations = InternalAggregations.readAggregations(in);
            buckets.add(new Bucket(termBytes, docCount, aggregations, this.showTermDocCountError, bucketDocCountError));
        }
        this.buckets = buckets;
        this.bucketMap = null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            out.writeLong(this.docCountError);
        }
        InternalOrder.Streams.writeOrder(this.order, out);
        StringTerms.writeSize(this.requiredSize, out);
        if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            StringTerms.writeSize(this.shardSize, out);
            out.writeBoolean(this.showTermDocCountError);
        }
        out.writeVLong(this.minDocCount);
        if (out.getVersion().onOrAfter(Version.V_1_4_0)) {
            out.writeVLong(this.otherDocCount);
        }
        out.writeVInt(this.buckets.size());
        for (InternalTerms.Bucket bucket : this.buckets) {
            out.writeBytesRef(((Bucket)bucket).termBytes);
            out.writeVLong(bucket.getDocCount());
            if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1) && this.showTermDocCountError) {
                out.writeLong(bucket.docCountError);
            }
            ((InternalAggregations)bucket.getAggregations()).writeTo(out);
        }
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("doc_count_error_upper_bound", this.docCountError);
        builder.field("sum_other_doc_count", this.otherDocCount);
        builder.startArray(InternalAggregation.CommonFields.BUCKETS);
        for (InternalTerms.Bucket bucket : this.buckets) {
            builder.startObject();
            builder.utf8Field(InternalAggregation.CommonFields.KEY, ((Bucket)bucket).termBytes);
            builder.field(InternalAggregation.CommonFields.DOC_COUNT, bucket.getDocCount());
            if (this.showTermDocCountError) {
                builder.field("doc_count_error_upper_bound", bucket.getDocCountError());
            }
            ((InternalAggregations)bucket.getAggregations()).toXContentInternal(builder, params);
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    public static class Bucket
    extends InternalTerms.Bucket {
        BytesRef termBytes;

        public Bucket(BytesRef term, long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError) {
            super(docCount, aggregations, showDocCountError, docCountError);
            this.termBytes = term;
        }

        @Override
        public String getKey() {
            return this.termBytes.utf8ToString();
        }

        @Override
        public Text getKeyAsText() {
            return new BytesText(new BytesArray(this.termBytes));
        }

        @Override
        public Number getKeyAsNumber() {
            return Double.parseDouble(this.termBytes.utf8ToString());
        }

        @Override
        int compareTerm(Terms.Bucket other) {
            return BytesRef.getUTF8SortedAsUnicodeComparator().compare(this.termBytes, ((Bucket)other).termBytes);
        }

        @Override
        Object getKeyAsObject() {
            return this.getKeyAsText();
        }

        @Override
        Bucket newBucket(long docCount, InternalAggregations aggs, long docCountError) {
            return new Bucket(this.termBytes, docCount, aggs, this.showDocCountError, docCountError);
        }
    }
}

