/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant.heuristics;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicBuilder;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicParser;

public abstract class NXYSignificanceHeuristic
extends SignificanceHeuristic {
    protected static final ParseField BACKGROUND_IS_SUPERSET = new ParseField("background_is_superset", new String[0]);
    protected static final ParseField INCLUDE_NEGATIVES_FIELD = new ParseField("include_negatives", new String[0]);
    protected static final String SCORE_ERROR_MESSAGE = ", does your background filter not include all documents in the bucket? If so and it is intentional, set \"" + BACKGROUND_IS_SUPERSET.getPreferredName() + "\": false";
    protected final boolean backgroundIsSuperset;
    protected final boolean includeNegatives;

    public NXYSignificanceHeuristic(boolean includeNegatives, boolean backgroundIsSuperset) {
        this.includeNegatives = includeNegatives;
        this.backgroundIsSuperset = backgroundIsSuperset;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.includeNegatives);
        out.writeBoolean(this.backgroundIsSuperset);
    }

    public boolean equals(Object other) {
        return ((NXYSignificanceHeuristic)other).includeNegatives == this.includeNegatives && ((NXYSignificanceHeuristic)other).backgroundIsSuperset == this.backgroundIsSuperset;
    }

    public int hashCode() {
        int result = this.includeNegatives ? 1 : 0;
        result = 31 * result + (this.backgroundIsSuperset ? 1 : 0);
        return result;
    }

    protected Frequencies computeNxys(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize, String scoreFunctionName) {
        this.checkFrequencies(subsetFreq, subsetSize, supersetFreq, supersetSize, scoreFunctionName);
        Frequencies frequencies = new Frequencies();
        if (this.backgroundIsSuperset) {
            frequencies.N00 = supersetSize - supersetFreq - (subsetSize - subsetFreq);
            frequencies.N01 = subsetSize - subsetFreq;
            frequencies.N10 = supersetFreq - subsetFreq;
            frequencies.N11 = subsetFreq;
            frequencies.N0_ = supersetSize - supersetFreq;
            frequencies.N1_ = supersetFreq;
            frequencies.N_0 = supersetSize - subsetSize;
            frequencies.N_1 = subsetSize;
            frequencies.N = supersetSize;
        } else {
            frequencies.N00 = supersetSize - supersetFreq;
            frequencies.N01 = subsetSize - subsetFreq;
            frequencies.N10 = supersetFreq;
            frequencies.N11 = subsetFreq;
            frequencies.N0_ = supersetSize - supersetFreq + subsetSize - subsetFreq;
            frequencies.N1_ = supersetFreq + subsetFreq;
            frequencies.N_0 = supersetSize;
            frequencies.N_1 = subsetSize;
            frequencies.N = supersetSize + subsetSize;
        }
        return frequencies;
    }

    protected void checkFrequencies(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize, String scoreFunctionName) {
        this.checkFrequencyValidity(subsetFreq, subsetSize, supersetFreq, supersetSize, scoreFunctionName);
        if (this.backgroundIsSuperset) {
            if (subsetFreq > supersetFreq) {
                throw new ElasticsearchIllegalArgumentException("subsetFreq > supersetFreq" + SCORE_ERROR_MESSAGE);
            }
            if (subsetSize > supersetSize) {
                throw new ElasticsearchIllegalArgumentException("subsetSize > supersetSize" + SCORE_ERROR_MESSAGE);
            }
            if (supersetFreq - subsetFreq > supersetSize - subsetSize) {
                throw new ElasticsearchIllegalArgumentException("supersetFreq - subsetFreq > supersetSize - subsetSize" + SCORE_ERROR_MESSAGE);
            }
        }
    }

    protected static abstract class NXYBuilder
    implements SignificanceHeuristicBuilder {
        protected boolean includeNegatives = true;
        protected boolean backgroundIsSuperset = true;

        public NXYBuilder(boolean includeNegatives, boolean backgroundIsSuperset) {
            this.includeNegatives = includeNegatives;
            this.backgroundIsSuperset = backgroundIsSuperset;
        }

        protected void build(XContentBuilder builder) throws IOException {
            builder.field(INCLUDE_NEGATIVES_FIELD.getPreferredName(), this.includeNegatives).field(BACKGROUND_IS_SUPERSET.getPreferredName(), this.backgroundIsSuperset);
        }
    }

    public static abstract class NXYParser
    implements SignificanceHeuristicParser {
        @Override
        public SignificanceHeuristic parse(XContentParser parser) throws IOException, QueryParsingException {
            String givenName = parser.currentName();
            boolean includeNegatives = false;
            boolean backgroundIsSuperset = true;
            XContentParser.Token token = parser.nextToken();
            while (!token.equals((Object)XContentParser.Token.END_OBJECT)) {
                if (INCLUDE_NEGATIVES_FIELD.match(parser.currentName())) {
                    parser.nextToken();
                    includeNegatives = parser.booleanValue();
                } else if (BACKGROUND_IS_SUPERSET.match(parser.currentName())) {
                    parser.nextToken();
                    backgroundIsSuperset = parser.booleanValue();
                } else {
                    throw new ElasticsearchParseException("Field " + parser.currentName().toString() + " unknown for " + givenName);
                }
                token = parser.nextToken();
            }
            return this.newHeuristic(includeNegatives, backgroundIsSuperset);
        }

        protected abstract SignificanceHeuristic newHeuristic(boolean var1, boolean var2);
    }

    protected static class Frequencies {
        double N00;
        double N01;
        double N10;
        double N11;
        double N0_;
        double N1_;
        double N_0;
        double N_1;
        double N;

        protected Frequencies() {
        }
    }
}

