/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.bucket.significant.BucketSignificancePriorityQueue;
import org.elasticsearch.search.aggregations.bucket.significant.InternalSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantLongTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTermsAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.terms.LongTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.format.ValueFormat;
import org.elasticsearch.search.internal.ContextIndexSearcher;

public class SignificantLongTermsAggregator
extends LongTermsAggregator {
    protected long numCollectedDocs;
    private final SignificantTermsAggregatorFactory termsAggFactory;

    public SignificantLongTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Numeric valuesSource, @Nullable ValueFormat format, long estimatedBucketCount, TermsAggregator.BucketCountThresholds bucketCountThresholds, AggregationContext aggregationContext, Aggregator parent, SignificantTermsAggregatorFactory termsAggFactory) {
        super(name, factories, valuesSource, format, estimatedBucketCount, null, bucketCountThresholds, aggregationContext, parent, Aggregator.SubAggCollectionMode.DEPTH_FIRST, false);
        this.termsAggFactory = termsAggFactory;
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        super.collect(doc, owningBucketOrdinal);
        ++this.numCollectedDocs;
    }

    @Override
    public SignificantLongTerms buildAggregation(long owningBucketOrdinal) {
        assert (owningBucketOrdinal == 0L);
        int size = (int)Math.min(this.bucketOrds.size(), (long)this.bucketCountThresholds.getShardSize());
        long supersetSize = this.termsAggFactory.prepareBackground(this.context);
        long subsetSize = this.numCollectedDocs;
        BucketSignificancePriorityQueue ordered = new BucketSignificancePriorityQueue(size);
        SignificantLongTerms.Bucket spare = null;
        for (long i = 0L; i < this.bucketOrds.size(); ++i) {
            if (spare == null) {
                spare = new SignificantLongTerms.Bucket(0L, 0L, 0L, 0L, 0L, null);
            }
            spare.term = this.bucketOrds.get(i);
            spare.subsetDf = this.bucketDocCount(i);
            spare.subsetSize = subsetSize;
            spare.supersetDf = this.termsAggFactory.getBackgroundFrequency(spare.term);
            spare.supersetSize = supersetSize;
            spare.updateScore(this.termsAggFactory.getSignificanceHeuristic());
            spare.bucketOrd = i;
            if (spare.subsetDf < this.bucketCountThresholds.getShardMinDocCount()) continue;
            spare = (SignificantLongTerms.Bucket)ordered.insertWithOverflow(spare);
        }
        InternalSignificantTerms.Bucket[] list = new InternalSignificantTerms.Bucket[ordered.size()];
        for (int i = ordered.size() - 1; i >= 0; --i) {
            SignificantLongTerms.Bucket bucket = (SignificantLongTerms.Bucket)ordered.pop();
            bucket.aggregations = this.bucketAggregations(bucket.bucketOrd);
            list[i] = bucket;
        }
        return new SignificantLongTerms(subsetSize, supersetSize, this.name, this.formatter, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.termsAggFactory.getSignificanceHeuristic(), Arrays.asList(list));
    }

    @Override
    public SignificantLongTerms buildEmptyAggregation() {
        ContextIndexSearcher searcher = this.context.searchContext().searcher();
        IndexReader topReader = searcher.getIndexReader();
        int supersetSize = topReader.numDocs();
        return new SignificantLongTerms(0L, supersetSize, this.name, this.formatter, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.termsAggFactory.getSignificanceHeuristic(), Collections.emptyList());
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds, this.termsAggFactory);
    }
}

