/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.nested;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.lucene.ReaderContextAware;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.index.cache.fixedbitset.FixedBitSetFilter;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.nested.InternalNested;
import org.elasticsearch.search.aggregations.bucket.nested.ReverseNestedAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.internal.SearchContext;

public class NestedAggregator
extends SingleBucketAggregator
implements ReaderContextAware {
    private final String nestedPath;
    private final Aggregator parentAggregator;
    private FixedBitSetFilter parentFilter;
    private final FixedBitSetFilter childFilter;
    private Bits childDocs;
    private FixedBitSet parentDocs;

    public NestedAggregator(String name, AggregatorFactories factories, String nestedPath, AggregationContext aggregationContext, Aggregator parentAggregator) {
        super(name, factories, aggregationContext, parentAggregator);
        this.nestedPath = nestedPath;
        this.parentAggregator = parentAggregator;
        MapperService.SmartNameObjectMapper mapper = aggregationContext.searchContext().smartNameObjectMapper(nestedPath);
        if (mapper == null) {
            throw new AggregationExecutionException("[nested] nested path [" + nestedPath + "] not found");
        }
        ObjectMapper objectMapper = mapper.mapper();
        if (objectMapper == null) {
            throw new AggregationExecutionException("[nested] nested path [" + nestedPath + "] not found");
        }
        if (!objectMapper.nested().isNested()) {
            throw new AggregationExecutionException("[nested] nested path [" + nestedPath + "] is not nested");
        }
        this.childFilter = aggregationContext.searchContext().fixedBitSetFilterCache().getFixedBitSetFilter(objectMapper.nestedTypeFilter());
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        if (this.parentFilter == null) {
            Filter parentFilterNotCached = NestedAggregator.findClosestNestedPath(this.parentAggregator);
            if (parentFilterNotCached == null) {
                parentFilterNotCached = NonNestedDocsFilter.INSTANCE;
            }
            this.parentFilter = SearchContext.current().fixedBitSetFilterCache().getFixedBitSetFilter(parentFilterNotCached);
        }
        try {
            FixedBitSet docIdSet = this.parentFilter.getDocIdSet(reader, null);
            this.childDocs = DocIdSets.toSafeBits(reader.reader(), (DocIdSet)this.childFilter.getDocIdSet(reader, null));
            this.parentDocs = DocIdSets.isEmpty((DocIdSet)docIdSet) ? null : docIdSet;
        }
        catch (IOException ioe) {
            throw new AggregationExecutionException("Failed to aggregate [" + this.name + "]", ioe);
        }
    }

    @Override
    public void collect(int parentDoc, long bucketOrd) throws IOException {
        if (parentDoc == 0 || this.parentDocs == null) {
            return;
        }
        int prevParentDoc = this.parentDocs.prevSetBit(parentDoc - 1);
        int numChildren = 0;
        for (int childDocId = prevParentDoc + 1; childDocId < parentDoc; ++childDocId) {
            if (!this.childDocs.get(childDocId)) continue;
            ++numChildren;
            this.collectBucketNoCounts(childDocId, bucketOrd);
        }
        this.incrementBucketDocCount(bucketOrd, numChildren);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        return new InternalNested(this.name, this.bucketDocCount(owningBucketOrdinal), this.bucketAggregations(owningBucketOrdinal));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalNested(this.name, 0L, this.buildEmptySubAggregations());
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    private static Filter findClosestNestedPath(Aggregator parent) {
        while (parent != null) {
            if (parent instanceof NestedAggregator) {
                return ((NestedAggregator)parent).childFilter;
            }
            if (parent instanceof ReverseNestedAggregator) {
                return ((ReverseNestedAggregator)parent).getParentFilter();
            }
            parent = parent.parent();
        }
        return null;
    }

    public static class Factory
    extends AggregatorFactory {
        private final String path;

        public Factory(String name, String path) {
            super(name, InternalNested.TYPE.name());
            this.path = path;
        }

        @Override
        public Aggregator create(AggregationContext context, Aggregator parent, long expectedBucketsCount) {
            return new NestedAggregator(this.name, this.factories, this.path, context, parent);
        }
    }
}

