/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.util.packed.PackedLongValues;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.RecordingBucketCollector;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public class RecordingPerReaderBucketCollector
extends RecordingBucketCollector {
    final List<PerSegmentCollects> perSegmentCollections = new ArrayList<PerSegmentCollects>();
    private PerSegmentCollects currentCollection;
    private boolean recordingComplete;

    public RecordingPerReaderBucketCollector(AggregationContext context) {
        context.ensureScoreDocsInOrder();
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        if (this.recordingComplete) {
            return;
        }
        this.stowLastSegmentCollection();
        this.currentCollection = new PerSegmentCollects(reader);
    }

    private void stowLastSegmentCollection() {
        if (this.currentCollection != null) {
            if (this.currentCollection.hasItems()) {
                this.currentCollection.endCollect();
                this.perSegmentCollections.add(this.currentCollection);
            }
            this.currentCollection = null;
        }
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        this.currentCollection.collect(doc, owningBucketOrdinal);
    }

    @Override
    public void replayCollection(BucketCollector collector) throws IOException {
        for (PerSegmentCollects collection : this.perSegmentCollections) {
            collection.replay(collector);
        }
        collector.postCollection();
    }

    @Override
    public void postCollection() throws IOException {
        this.recordingComplete = true;
        this.stowLastSegmentCollection();
    }

    @Override
    public void close() throws ElasticsearchException {
    }

    static class PerSegmentCollects {
        AtomicReaderContext readerContext;
        PackedLongValues.Builder docs;
        PackedLongValues.Builder buckets;
        int lastDocId = 0;

        PerSegmentCollects(AtomicReaderContext readerContext) {
            this.readerContext = readerContext;
        }

        void collect(int doc, long owningBucketOrdinal) throws IOException {
            if (this.docs == null) {
                this.docs = PackedLongValues.packedBuilder((float)0.0f);
            }
            this.docs.add((long)(doc - this.lastDocId));
            this.lastDocId = doc;
            if (this.buckets == null) {
                if (owningBucketOrdinal != 0L) {
                    this.buckets = PackedLongValues.packedBuilder((float)0.0f);
                    int i = 0;
                    while ((long)i < this.docs.size() - 1L) {
                        this.buckets.add(0L);
                        ++i;
                    }
                    this.buckets.add(owningBucketOrdinal);
                }
            } else {
                this.buckets.add(owningBucketOrdinal);
            }
        }

        void endCollect() {
        }

        boolean hasItems() {
            return this.docs != null;
        }

        void replay(BucketCollector collector) throws IOException {
            this.lastDocId = 0;
            collector.setNextReader(this.readerContext);
            if (!this.hasItems()) {
                return;
            }
            if (this.buckets == null) {
                PackedLongValues.Iterator docsIter = this.docs.build().iterator();
                while (docsIter.hasNext()) {
                    this.lastDocId += (int)docsIter.next();
                    collector.collect(this.lastDocId, 0L);
                }
            } else {
                assert (this.docs.size() == this.buckets.size());
                PackedLongValues.Iterator docsIter = this.docs.build().iterator();
                PackedLongValues.Iterator bucketsIter = this.buckets.build().iterator();
                while (docsIter.hasNext()) {
                    this.lastDocId += (int)docsIter.next();
                    collector.collect(this.lastDocId, bucketsIter.next());
                }
            }
        }
    }
}

