/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.get;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;

public class RestGetIndicesAction
extends BaseRestHandler {
    @Inject
    public RestGetIndicesAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/{index}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}", this);
    }

    @Override
    public void handleRequest(final RestRequest request, RestChannel channel, Client client) {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        String[] features = request.paramAsStringArray("type", null);
        if (features == null && indices.length > 0 && indices[0] != null && indices[0].startsWith("_") && !"_all".equals(indices[0])) {
            features = indices;
            indices = new String[]{"_all"};
        }
        final GetIndexRequest getIndexRequest = new GetIndexRequest();
        getIndexRequest.indices(indices);
        if (features != null) {
            getIndexRequest.features(features);
        }
        IndicesOptions defaultIndicesOptions = getIndexRequest.indicesOptions();
        getIndexRequest.indicesOptions(IndicesOptions.fromRequest(request, defaultIndicesOptions));
        getIndexRequest.local(request.paramAsBoolean("local", getIndexRequest.local()));
        client.admin().indices().getIndex(getIndexRequest, (ActionListener<GetIndexResponse>)new RestBuilderListener<GetIndexResponse>(channel){

            @Override
            public RestResponse buildResponse(GetIndexResponse response, XContentBuilder builder) throws Exception {
                String[] features = getIndexRequest.features();
                String[] indices = response.indices();
                builder.startObject();
                for (String index : indices) {
                    builder.startObject(index);
                    String[] arr$ = features;
                    int len$ = arr$.length;
                    block16: for (int i$ = 0; i$ < len$; ++i$) {
                        String feature;
                        switch (feature = arr$[i$]) {
                            case "_alias": 
                            case "_aliases": {
                                this.writeAliases(response.aliases().get(index), builder, request);
                                continue block16;
                            }
                            case "_mapping": 
                            case "_mappings": {
                                this.writeMappings(response.mappings().get(index), builder, request);
                                continue block16;
                            }
                            case "_settings": {
                                this.writeSettings(response.settings().get(index), builder, request);
                                continue block16;
                            }
                            case "_warmer": 
                            case "_warmers": {
                                this.writeWarmers(response.warmers().get(index), builder, request);
                                continue block16;
                            }
                            default: {
                                throw new ElasticsearchIllegalStateException("feature [" + feature + "] is not valid");
                            }
                        }
                    }
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }

            private void writeAliases(ImmutableList<AliasMetaData> aliases, XContentBuilder builder, ToXContent.Params params) throws IOException {
                if (aliases != null) {
                    builder.startObject(Fields.ALIASES);
                    for (AliasMetaData alias : aliases) {
                        AliasMetaData.Builder.toXContent(alias, builder, params);
                    }
                    builder.endObject();
                }
            }

            private void writeMappings(ImmutableOpenMap<String, MappingMetaData> mappings, XContentBuilder builder, ToXContent.Params params) throws IOException {
                if (mappings != null) {
                    builder.startObject(Fields.MAPPINGS);
                    for (ObjectObjectCursor<String, MappingMetaData> objectObjectCursor : mappings) {
                        builder.field((String)objectObjectCursor.key);
                        builder.map(((MappingMetaData)objectObjectCursor.value).sourceAsMap());
                    }
                    builder.endObject();
                }
            }

            private void writeSettings(Settings settings, XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject(Fields.SETTINGS);
                settings.toXContent(builder, params);
                builder.endObject();
            }

            private void writeWarmers(ImmutableList<IndexWarmersMetaData.Entry> warmers, XContentBuilder builder, ToXContent.Params params) throws IOException {
                if (warmers != null) {
                    builder.startObject(Fields.WARMERS);
                    for (IndexWarmersMetaData.Entry warmer : warmers) {
                        IndexWarmersMetaData.FACTORY.toXContent(warmer, builder, params);
                    }
                    builder.endObject();
                }
            }
        });
    }

    static class Fields {
        static final XContentBuilderString ALIASES = new XContentBuilderString("aliases");
        static final XContentBuilderString MAPPINGS = new XContentBuilderString("mappings");
        static final XContentBuilderString SETTINGS = new XContentBuilderString("settings");
        static final XContentBuilderString WARMERS = new XContentBuilderString("warmers");

        Fields() {
        }
    }
}

