/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.memory.ExtendedMemoryIndex;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CloseableThreadLocal;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.percolate.PercolateResponse;
import org.elasticsearch.action.percolate.PercolateShardRequest;
import org.elasticsearch.action.percolate.PercolateShardResponse;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.hppc.ByteObjectOpenHashMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.XCollector;
import org.elasticsearch.common.lucene.search.XConstantScoreQuery;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.BytesText;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.percolator.stats.ShardPercolateService;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.percolator.MultiDocumentPercolatorIndex;
import org.elasticsearch.percolator.PercolateContext;
import org.elasticsearch.percolator.PercolateException;
import org.elasticsearch.percolator.PercolatorIndex;
import org.elasticsearch.percolator.QueryCollector;
import org.elasticsearch.percolator.SingleDocumentPercolatorIndex;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.AggregationPhase;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhase;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.InternalFacets;
import org.elasticsearch.search.highlight.HighlightField;
import org.elasticsearch.search.highlight.HighlightPhase;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.sort.SortParseElement;

public class PercolatorService
extends AbstractComponent {
    public static final float NO_SCORE = Float.NEGATIVE_INFINITY;
    public static final String TYPE_NAME = ".percolator";
    private final IndicesService indicesService;
    private final ByteObjectOpenHashMap<PercolatorType> percolatorTypes;
    private final CacheRecycler cacheRecycler;
    private final PageCacheRecycler pageCacheRecycler;
    private final BigArrays bigArrays;
    private final ClusterService clusterService;
    private final PercolatorIndex single;
    private final PercolatorIndex multi;
    private final FacetPhase facetPhase;
    private final HighlightPhase highlightPhase;
    private final AggregationPhase aggregationPhase;
    private final SortParseElement sortParseElement;
    private final ScriptService scriptService;
    private final MappingUpdatedAction mappingUpdatedAction;
    private final CloseableThreadLocal<MemoryIndex> cache;
    private final PercolatorType countPercolator = new PercolatorType(){

        @Override
        public byte id() {
            return 1;
        }

        @Override
        public ReduceResult reduce(List<PercolateShardResponse> shardResults) {
            long finalCount = 0L;
            for (PercolateShardResponse shardResponse : shardResults) {
                finalCount += shardResponse.count();
            }
            assert (!shardResults.isEmpty());
            InternalFacets reducedFacets = PercolatorService.this.reduceFacets(shardResults);
            InternalAggregations reducedAggregations = PercolatorService.this.reduceAggregations(shardResults);
            return new ReduceResult(finalCount, reducedFacets, reducedAggregations);
        }

        @Override
        public PercolateShardResponse doPercolate(PercolateShardRequest request, PercolateContext context, boolean isNested) {
            long count = 0L;
            Lucene.EarlyTerminatingCollector collector = Lucene.createExistsCollector();
            for (Map.Entry entry : context.percolateQueries().entrySet()) {
                try {
                    if (isNested) {
                        Lucene.exists(context.docSearcher(), (Query)entry.getValue(), NonNestedDocsFilter.INSTANCE, collector);
                    } else {
                        Lucene.exists(context.docSearcher(), (Query)entry.getValue(), collector);
                    }
                }
                catch (Throwable e) {
                    PercolatorService.this.logger.debug("[" + entry.getKey() + "] failed to execute query", e, new Object[0]);
                    throw new PercolateException(context.indexShard().shardId(), "failed to execute", e);
                }
                if (!collector.exists()) continue;
                ++count;
            }
            return new PercolateShardResponse(count, context, request.shardId());
        }
    };
    private final PercolatorType queryCountPercolator = new PercolatorType(){

        @Override
        public byte id() {
            return 2;
        }

        @Override
        public ReduceResult reduce(List<PercolateShardResponse> shardResults) {
            return PercolatorService.this.countPercolator.reduce(shardResults);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PercolateShardResponse doPercolate(PercolateShardRequest request, PercolateContext context, boolean isNested) {
            long count = 0L;
            try (Engine.Searcher percolatorSearcher = context.indexShard().acquireSearcher("percolate");){
                QueryCollector.Count countCollector = QueryCollector.count(PercolatorService.this.logger, context, isNested);
                PercolatorService.this.queryBasedPercolating(percolatorSearcher, context, countCollector);
                count = countCollector.counter();
            }
            return new PercolateShardResponse(count, context, request.shardId());
        }
    };
    private final PercolatorType matchPercolator = new PercolatorType(){

        @Override
        public byte id() {
            return 3;
        }

        @Override
        public ReduceResult reduce(List<PercolateShardResponse> shardResults) {
            long foundMatches = 0L;
            int numMatches = 0;
            for (PercolateShardResponse response : shardResults) {
                foundMatches += response.count();
                numMatches += response.matches().length;
            }
            int requestedSize = shardResults.get(0).requestedSize();
            ArrayList<PercolateResponse.Match> finalMatches = new ArrayList<PercolateResponse.Match>(requestedSize == 0 ? numMatches : requestedSize);
            block1: for (PercolateShardResponse response : shardResults) {
                StringText index = new StringText(response.getIndex());
                for (int i = 0; i < response.matches().length; ++i) {
                    float score = response.scores().length == 0 ? Float.NEGATIVE_INFINITY : response.scores()[i];
                    BytesText match = new BytesText(new BytesArray(response.matches()[i]));
                    Map<String, HighlightField> hl = response.hls().isEmpty() ? null : response.hls().get(i);
                    finalMatches.add(new PercolateResponse.Match(index, match, score, hl));
                    if (requestedSize != 0 && finalMatches.size() == requestedSize) break block1;
                }
            }
            assert (!shardResults.isEmpty());
            InternalFacets reducedFacets = PercolatorService.this.reduceFacets(shardResults);
            InternalAggregations reducedAggregations = PercolatorService.this.reduceAggregations(shardResults);
            return new ReduceResult(foundMatches, finalMatches.toArray(new PercolateResponse.Match[finalMatches.size()]), reducedFacets, reducedAggregations);
        }

        @Override
        public PercolateShardResponse doPercolate(PercolateShardRequest request, PercolateContext context, boolean isNested) {
            long count = 0L;
            ArrayList matches = new ArrayList();
            ArrayList<Map<String, HighlightField>> hls = new ArrayList<Map<String, HighlightField>>();
            Lucene.EarlyTerminatingCollector collector = Lucene.createExistsCollector();
            for (Map.Entry entry : context.percolateQueries().entrySet()) {
                if (context.highlight() != null) {
                    context.parsedQuery(new ParsedQuery((Query)entry.getValue(), ImmutableMap.of()));
                    context.hitContext().cache().clear();
                }
                try {
                    if (isNested) {
                        Lucene.exists(context.docSearcher(), (Query)entry.getValue(), NonNestedDocsFilter.INSTANCE, collector);
                    } else {
                        Lucene.exists(context.docSearcher(), (Query)entry.getValue(), collector);
                    }
                }
                catch (Throwable e) {
                    PercolatorService.this.logger.debug("[" + entry.getKey() + "] failed to execute query", e, new Object[0]);
                    throw new PercolateException(context.indexShard().shardId(), "failed to execute", e);
                }
                if (!collector.exists()) continue;
                if (!context.limit || count < (long)context.size()) {
                    matches.add(entry.getKey());
                    if (context.highlight() != null) {
                        PercolatorService.this.highlightPhase.hitExecute(context, context.hitContext());
                        hls.add(context.hitContext().hit().getHighlightFields());
                    }
                }
                ++count;
            }
            BytesRef[] finalMatches = matches.toArray(new BytesRef[matches.size()]);
            return new PercolateShardResponse(finalMatches, hls, count, context, request.shardId());
        }
    };
    private final PercolatorType queryPercolator = new PercolatorType(){

        @Override
        public byte id() {
            return 4;
        }

        @Override
        public ReduceResult reduce(List<PercolateShardResponse> shardResults) {
            return PercolatorService.this.matchPercolator.reduce(shardResults);
        }

        @Override
        public PercolateShardResponse doPercolate(PercolateShardRequest request, PercolateContext context, boolean isNested) {
            try (Engine.Searcher percolatorSearcher = context.indexShard().acquireSearcher("percolate");){
                QueryCollector.Match match = QueryCollector.match(PercolatorService.this.logger, context, PercolatorService.this.highlightPhase, isNested);
                PercolatorService.this.queryBasedPercolating(percolatorSearcher, context, match);
                List<BytesRef> matches = match.matches();
                List<Map<String, HighlightField>> hls = match.hls();
                long count = match.counter();
                BytesRef[] finalMatches = matches.toArray(new BytesRef[matches.size()]);
                PercolateShardResponse percolateShardResponse = new PercolateShardResponse(finalMatches, hls, count, context, request.shardId());
                return percolateShardResponse;
            }
        }
    };
    private final PercolatorType scoringPercolator = new PercolatorType(){

        @Override
        public byte id() {
            return 5;
        }

        @Override
        public ReduceResult reduce(List<PercolateShardResponse> shardResults) {
            return PercolatorService.this.matchPercolator.reduce(shardResults);
        }

        @Override
        public PercolateShardResponse doPercolate(PercolateShardRequest request, PercolateContext context, boolean isNested) {
            try (Engine.Searcher percolatorSearcher = context.indexShard().acquireSearcher("percolate");){
                QueryCollector.MatchAndScore matchAndScore = QueryCollector.matchAndScore(PercolatorService.this.logger, context, PercolatorService.this.highlightPhase, isNested);
                PercolatorService.this.queryBasedPercolating(percolatorSearcher, context, matchAndScore);
                List<BytesRef> matches = matchAndScore.matches();
                List<Map<String, HighlightField>> hls = matchAndScore.hls();
                float[] scores = matchAndScore.scores().toArray();
                long count = matchAndScore.counter();
                BytesRef[] finalMatches = matches.toArray(new BytesRef[matches.size()]);
                PercolateShardResponse percolateShardResponse = new PercolateShardResponse(finalMatches, hls, count, scores, context, request.shardId());
                return percolateShardResponse;
            }
        }
    };
    private final PercolatorType topMatchingPercolator = new PercolatorType(){

        @Override
        public byte id() {
            return 6;
        }

        @Override
        public ReduceResult reduce(List<PercolateShardResponse> shardResults) {
            long foundMatches = 0L;
            int nonEmptyResponses = 0;
            int firstNonEmptyIndex = 0;
            for (int i = 0; i < shardResults.size(); ++i) {
                PercolateShardResponse response = shardResults.get(i);
                foundMatches += response.count();
                if (response.matches().length == 0) continue;
                if (firstNonEmptyIndex == 0) {
                    firstNonEmptyIndex = i;
                }
                ++nonEmptyResponses;
            }
            int requestedSize = shardResults.get(0).requestedSize();
            ArrayList<PercolateResponse.Match> finalMatches = new ArrayList<PercolateResponse.Match>(requestedSize);
            if (nonEmptyResponses == 1) {
                PercolateShardResponse response = shardResults.get(firstNonEmptyIndex);
                StringText index = new StringText(response.getIndex());
                for (int i = 0; i < response.matches().length; ++i) {
                    float score = response.scores().length == 0 ? Float.NaN : response.scores()[i];
                    BytesText match = new BytesText(new BytesArray(response.matches()[i]));
                    if (!response.hls().isEmpty()) {
                        Map<String, HighlightField> hl = response.hls().get(i);
                        finalMatches.add(new PercolateResponse.Match(index, match, score, hl));
                        continue;
                    }
                    finalMatches.add(new PercolateResponse.Match(index, match, score));
                }
            } else {
                int[] slots = new int[shardResults.size()];
                do {
                    float score;
                    float lowestScore = Float.NEGATIVE_INFINITY;
                    int requestIndex = -1;
                    int itemIndex = -1;
                    for (int i = 0; i < shardResults.size(); ++i) {
                        int cmp;
                        int scoreIndex = slots[i];
                        float[] scores = shardResults.get(i).scores();
                        if (scoreIndex >= scores.length || (cmp = Float.compare(lowestScore, score = scores[scoreIndex])) >= 0) continue;
                        requestIndex = i;
                        itemIndex = scoreIndex;
                        lowestScore = score;
                    }
                    if (requestIndex == -1) break;
                    int n = requestIndex;
                    slots[n] = slots[n] + 1;
                    PercolateShardResponse shardResponse = shardResults.get(requestIndex);
                    StringText index = new StringText(shardResponse.getIndex());
                    BytesText match = new BytesText(new BytesArray(shardResponse.matches()[itemIndex]));
                    score = shardResponse.scores()[itemIndex];
                    if (!shardResponse.hls().isEmpty()) {
                        Map<String, HighlightField> hl = shardResponse.hls().get(itemIndex);
                        finalMatches.add(new PercolateResponse.Match(index, match, score, hl));
                        continue;
                    }
                    finalMatches.add(new PercolateResponse.Match(index, match, score));
                } while (finalMatches.size() != requestedSize);
            }
            assert (!shardResults.isEmpty());
            InternalFacets reducedFacets = PercolatorService.this.reduceFacets(shardResults);
            InternalAggregations reducedAggregations = PercolatorService.this.reduceAggregations(shardResults);
            return new ReduceResult(foundMatches, finalMatches.toArray(new PercolateResponse.Match[finalMatches.size()]), reducedFacets, reducedAggregations);
        }

        @Override
        public PercolateShardResponse doPercolate(PercolateShardRequest request, PercolateContext context, boolean isNested) {
            try (Engine.Searcher percolatorSearcher = context.indexShard().acquireSearcher("percolate");){
                PercolateShardResponse percolateShardResponse;
                QueryCollector.MatchAndSort matchAndSort = QueryCollector.matchAndSort(PercolatorService.this.logger, context, isNested);
                PercolatorService.this.queryBasedPercolating(percolatorSearcher, context, matchAndSort);
                TopDocs topDocs = matchAndSort.topDocs();
                long count = topDocs.totalHits;
                ArrayList<BytesRef> matches = new ArrayList<BytesRef>(topDocs.scoreDocs.length);
                float[] scores = new float[topDocs.scoreDocs.length];
                ArrayList<Map<String, HighlightField>> hls = null;
                if (context.highlight() != null) {
                    hls = new ArrayList<Map<String, HighlightField>>(topDocs.scoreDocs.length);
                }
                FieldMapper idMapper = context.mapperService().smartNameFieldMapper("_id");
                Object idFieldData = context.fieldData().getForField(idMapper);
                int i = 0;
                for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                    int segmentIdx = ReaderUtil.subIndex((int)scoreDoc.doc, (List)percolatorSearcher.reader().leaves());
                    AtomicReaderContext atomicReaderContext = (AtomicReaderContext)percolatorSearcher.reader().leaves().get(segmentIdx);
                    SortedBinaryDocValues values = idFieldData.load(atomicReaderContext).getBytesValues();
                    int localDocId = scoreDoc.doc - atomicReaderContext.docBase;
                    values.setDocument(localDocId);
                    int numValues = values.count();
                    assert (numValues == 1);
                    BytesRef bytes = values.valueAt(0);
                    matches.add(BytesRef.deepCopyOf((BytesRef)bytes));
                    if (hls != null) {
                        Query query = (Query)context.percolateQueries().get(bytes);
                        context.parsedQuery(new ParsedQuery(query, ImmutableMap.of()));
                        context.hitContext().cache().clear();
                        PercolatorService.this.highlightPhase.hitExecute(context, context.hitContext());
                        hls.add(i, context.hitContext().hit().getHighlightFields());
                    }
                    scores[i++] = scoreDoc.score;
                }
                if (hls != null) {
                    percolateShardResponse = new PercolateShardResponse(matches.toArray(new BytesRef[matches.size()]), hls, count, scores, context, request.shardId());
                    return percolateShardResponse;
                }
                percolateShardResponse = new PercolateShardResponse(matches.toArray(new BytesRef[matches.size()]), count, scores, context, request.shardId());
                return percolateShardResponse;
            }
        }
    };

    @Inject
    public PercolatorService(Settings settings, IndicesService indicesService, CacheRecycler cacheRecycler, PageCacheRecycler pageCacheRecycler, BigArrays bigArrays, HighlightPhase highlightPhase, ClusterService clusterService, FacetPhase facetPhase, AggregationPhase aggregationPhase, ScriptService scriptService, MappingUpdatedAction mappingUpdatedAction) {
        super(settings);
        this.indicesService = indicesService;
        this.cacheRecycler = cacheRecycler;
        this.pageCacheRecycler = pageCacheRecycler;
        this.bigArrays = bigArrays;
        this.clusterService = clusterService;
        this.highlightPhase = highlightPhase;
        this.facetPhase = facetPhase;
        this.aggregationPhase = aggregationPhase;
        this.scriptService = scriptService;
        this.mappingUpdatedAction = mappingUpdatedAction;
        this.sortParseElement = new SortParseElement();
        final long maxReuseBytes = settings.getAsBytesSize("indices.memory.memory_index.size_per_thread", new ByteSizeValue(1L, ByteSizeUnit.MB)).bytes();
        this.cache = new CloseableThreadLocal<MemoryIndex>(){

            protected MemoryIndex initialValue() {
                return new ExtendedMemoryIndex(true, maxReuseBytes);
            }
        };
        this.single = new SingleDocumentPercolatorIndex(this.cache);
        this.multi = new MultiDocumentPercolatorIndex(this.cache);
        this.percolatorTypes = new ByteObjectOpenHashMap(6);
        this.percolatorTypes.put(this.countPercolator.id(), this.countPercolator);
        this.percolatorTypes.put(this.queryCountPercolator.id(), this.queryCountPercolator);
        this.percolatorTypes.put(this.matchPercolator.id(), this.matchPercolator);
        this.percolatorTypes.put(this.queryPercolator.id(), this.queryPercolator);
        this.percolatorTypes.put(this.scoringPercolator.id(), this.scoringPercolator);
        this.percolatorTypes.put(this.topMatchingPercolator.id(), this.topMatchingPercolator);
    }

    public ReduceResult reduce(byte percolatorTypeId, List<PercolateShardResponse> shardResults) {
        PercolatorType percolatorType = this.percolatorTypes.get(percolatorTypeId);
        return percolatorType.reduce(shardResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PercolateShardResponse percolate(PercolateShardRequest request) {
        IndexService percolateIndexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard indexShard = percolateIndexService.shardSafe(request.shardId().id());
        indexShard.readAllowed();
        ShardPercolateService shardPercolateService = indexShard.shardPercolateService();
        shardPercolateService.prePercolate();
        long startTime = System.nanoTime();
        SearchShardTarget searchShardTarget = new SearchShardTarget(this.clusterService.localNode().id(), request.shardId().getIndex(), request.shardId().id());
        PercolateContext context = new PercolateContext(request, searchShardTarget, indexShard, percolateIndexService, this.cacheRecycler, this.pageCacheRecycler, this.bigArrays, this.scriptService);
        try {
            PercolatorIndex percolatorIndex;
            ParsedDocument parsedDocument = this.parseRequest(percolateIndexService, request, context);
            if (context.percolateQueries().isEmpty()) {
                PercolateShardResponse percolateShardResponse = new PercolateShardResponse(context, request.shardId());
                return percolateShardResponse;
            }
            if (request.docSource() != null && request.docSource().length() != 0) {
                parsedDocument = this.parseFetchedDoc(context, request.docSource(), percolateIndexService, request.documentType());
            } else if (parsedDocument == null) {
                throw new ElasticsearchIllegalArgumentException("Nothing to percolate");
            }
            if (context.percolateQuery() == null && (context.trackScores() || context.doSort || context.facets() != null || context.aggregations() != null)) {
                context.percolateQuery((Query)new MatchAllDocsQuery());
            }
            if (context.doSort && !context.limit) {
                throw new ElasticsearchIllegalArgumentException("Can't sort if size isn't specified");
            }
            if (context.highlight() != null && !context.limit) {
                throw new ElasticsearchIllegalArgumentException("Can't highlight if size isn't specified");
            }
            if (context.size() < 0) {
                context.size(0);
            }
            boolean isNested = indexShard.mapperService().documentMapper(request.documentType()).hasNestedObjects();
            if (parsedDocument.docs().size() > 1) {
                assert (isNested);
                percolatorIndex = this.multi;
            } else {
                percolatorIndex = this.single;
            }
            PercolatorType action = request.onlyCount() ? (context.percolateQuery() != null ? this.queryCountPercolator : this.countPercolator) : (context.doSort ? this.topMatchingPercolator : (context.percolateQuery() != null ? (context.trackScores() ? this.scoringPercolator : this.queryPercolator) : this.matchPercolator));
            context.percolatorTypeId = action.id();
            percolatorIndex.prepare(context, parsedDocument);
            PercolateShardResponse percolateShardResponse = action.doPercolate(request, context, isNested);
            return percolateShardResponse;
        }
        finally {
            context.close();
            shardPercolateService.postPercolate(System.nanoTime() - startTime);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ParsedDocument parseRequest(IndexService documentIndexService, PercolateShardRequest request, PercolateContext context) throws ElasticsearchException {
        BytesReference source = request.source();
        if (source == null) return null;
        if (source.length() == 0) {
            return null;
        }
        Map<String, ? extends SearchParseElement> hlElements = this.highlightPhase.parseElements();
        Map<String, ? extends SearchParseElement> facetElements = this.facetPhase.parseElements();
        Map<String, ? extends SearchParseElement> aggregationElements = this.aggregationPhase.parseElements();
        ParsedDocument doc = null;
        XContentParser parser = null;
        String[] previousTypes = context.types();
        context.types(new String[]{TYPE_NAME});
        SearchContext.setCurrent(context);
        try {
            XContentParser.Token token;
            parser = XContentFactory.xContent(source).createParser(source);
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    if (!"doc".equals(currentFieldName)) continue;
                    if (doc != null) {
                        throw new ElasticsearchParseException("Either specify doc or get, not both");
                    }
                    MapperService mapperService = documentIndexService.mapperService();
                    Tuple<DocumentMapper, Boolean> docMapper = mapperService.documentMapperWithAutoCreate(request.documentType());
                    doc = docMapper.v1().parse(SourceToParse.source(parser).type(request.documentType()).flyweight(true)).setMappingsModified(docMapper);
                    if (doc.mappingsModified()) {
                        this.mappingUpdatedAction.updateMappingOnMaster(request.shardId().getIndex(), docMapper.v1(), documentIndexService.indexUUID());
                    }
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    SearchParseElement element = hlElements.get(currentFieldName);
                    if (element == null && (element = facetElements.get(currentFieldName)) == null) {
                        element = aggregationElements.get(currentFieldName);
                    }
                    if ("query".equals(currentFieldName)) {
                        if (context.percolateQuery() != null) {
                            throw new ElasticsearchParseException("Either specify query or filter, not both");
                        }
                        context.percolateQuery(documentIndexService.queryParserService().parse(parser).query());
                        continue;
                    }
                    if ("filter".equals(currentFieldName)) {
                        if (context.percolateQuery() != null) {
                            throw new ElasticsearchParseException("Either specify query or filter, not both");
                        }
                        Filter filter = documentIndexService.queryParserService().parseInnerFilter(parser).filter();
                        context.percolateQuery((Query)new XConstantScoreQuery(filter));
                        continue;
                    }
                    if ("sort".equals(currentFieldName)) {
                        this.parseSort(parser, context);
                        continue;
                    }
                    if (element == null) continue;
                    element.parse(parser, context);
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (!"sort".equals(currentFieldName)) continue;
                    this.parseSort(parser, context);
                    continue;
                }
                if (token == null) break;
                if (!token.isValue()) continue;
                if ("size".equals(currentFieldName)) {
                    context.size(parser.intValue());
                    if (context.size() >= 0) continue;
                    throw new ElasticsearchParseException("size is set to [" + context.size() + "] and is expected to be higher or equal to 0");
                }
                if ("sort".equals(currentFieldName)) {
                    this.parseSort(parser, context);
                    continue;
                }
                if (!"track_scores".equals(currentFieldName) && !"trackScores".equals(currentFieldName)) continue;
                context.trackScores(parser.booleanValue());
            }
            if (context.highlight() == null) return doc;
            parser.close();
            currentFieldName = null;
            parser = XContentFactory.xContent(source).createParser(source);
            token = parser.nextToken();
            assert (token == XContentParser.Token.START_OBJECT);
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("doc".equals(currentFieldName)) {
                        BytesStreamOutput bStream = new BytesStreamOutput();
                        XContentBuilder builder = XContentFactory.contentBuilder(XContentType.SMILE, bStream);
                        builder.copyCurrentStructure(parser);
                        builder.close();
                        doc.setSource(bStream.bytes());
                        return doc;
                    }
                    parser.skipChildren();
                    continue;
                }
                if (token == null) return doc;
            }
            return doc;
        }
        catch (Throwable e) {
            throw new ElasticsearchParseException("failed to parse request", e);
        }
        finally {
            context.types(previousTypes);
            SearchContext.removeCurrent();
            if (parser != null) {
                parser.close();
            }
        }
    }

    private void parseSort(XContentParser parser, PercolateContext context) throws Exception {
        this.sortParseElement.parse(parser, context);
        if (context.sort() != null) {
            throw new ElasticsearchParseException("Only _score desc is supported");
        }
        context.doSort = true;
    }

    private ParsedDocument parseFetchedDoc(PercolateContext context, BytesReference fetchedDoc, IndexService documentIndexService, String type) {
        ParsedDocument doc = null;
        try (XContentParser parser = null;){
            parser = XContentFactory.xContent(fetchedDoc).createParser(fetchedDoc);
            MapperService mapperService = documentIndexService.mapperService();
            Tuple<DocumentMapper, Boolean> docMapper = mapperService.documentMapperWithAutoCreate(type);
            doc = docMapper.v1().parse(SourceToParse.source(parser).type(type).flyweight(true));
            if (context.highlight() != null) {
                doc.setSource(fetchedDoc);
            }
        }
        if (doc == null) {
            throw new ElasticsearchParseException("No doc to percolate in the request");
        }
        return doc;
    }

    public void close() {
        this.cache.close();
    }

    private void queryBasedPercolating(Engine.Searcher percolatorSearcher, PercolateContext context, QueryCollector percolateCollector) throws IOException {
        Filter percolatorTypeFilter = context.indexService().mapperService().documentMapper(TYPE_NAME).typeFilter();
        percolatorTypeFilter = context.indexService().cache().filter().cache(percolatorTypeFilter);
        XFilteredQuery query = new XFilteredQuery(context.percolateQuery(), percolatorTypeFilter);
        percolatorSearcher.searcher().search((Query)query, (Collector)percolateCollector);
        for (Collector queryCollector : percolateCollector.facetAndAggregatorCollector) {
            if (!(queryCollector instanceof XCollector)) continue;
            ((XCollector)queryCollector).postCollection();
        }
        if (context.facets() != null) {
            this.facetPhase.execute(context);
        }
        if (context.aggregations() != null) {
            this.aggregationPhase.execute(context);
        }
    }

    private InternalFacets reduceFacets(List<PercolateShardResponse> shardResults) {
        if (shardResults.get(0).facets() == null) {
            return null;
        }
        if (shardResults.size() == 1) {
            return shardResults.get(0).facets();
        }
        PercolateShardResponse firstShardResponse = shardResults.get(0);
        ArrayList<Facet> aggregatedFacets = Lists.newArrayList();
        ArrayList<Facet> namedFacets = Lists.newArrayList();
        for (Facet facet : firstShardResponse.facets()) {
            namedFacets.clear();
            for (PercolateShardResponse entry : shardResults) {
                for (Facet facet1 : entry.facets()) {
                    if (!facet.getName().equals(facet1.getName())) continue;
                    namedFacets.add(facet1);
                }
            }
            if (namedFacets.isEmpty()) continue;
            Facet aggregatedFacet = ((InternalFacet)namedFacets.get(0)).reduce(new InternalFacet.ReduceContext(this.cacheRecycler, namedFacets));
            aggregatedFacets.add(aggregatedFacet);
        }
        return new InternalFacets(aggregatedFacets);
    }

    private InternalAggregations reduceAggregations(List<PercolateShardResponse> shardResults) {
        if (shardResults.get(0).aggregations() == null) {
            return null;
        }
        if (shardResults.size() == 1) {
            return shardResults.get(0).aggregations();
        }
        ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(shardResults.size());
        for (PercolateShardResponse shardResult : shardResults) {
            aggregationsList.add(shardResult.aggregations());
        }
        return InternalAggregations.reduce(aggregationsList, new InternalAggregation.ReduceContext(null, this.bigArrays, this.scriptService));
    }

    static /* synthetic */ ESLogger access$600(PercolatorService x0) {
        return x0.logger;
    }

    static /* synthetic */ ESLogger access$1100(PercolatorService x0) {
        return x0.logger;
    }

    static /* synthetic */ ESLogger access$1300(PercolatorService x0) {
        return x0.logger;
    }

    static /* synthetic */ ESLogger access$1500(PercolatorService x0) {
        return x0.logger;
    }

    public static final class ReduceResult {
        private final long count;
        private final PercolateResponse.Match[] matches;
        private final InternalFacets reducedFacets;
        private final InternalAggregations reducedAggregations;

        ReduceResult(long count, PercolateResponse.Match[] matches, InternalFacets reducedFacets, InternalAggregations reducedAggregations) {
            this.count = count;
            this.matches = matches;
            this.reducedFacets = reducedFacets;
            this.reducedAggregations = reducedAggregations;
        }

        public ReduceResult(long count, InternalFacets reducedFacets, InternalAggregations reducedAggregations) {
            this.count = count;
            this.matches = null;
            this.reducedFacets = reducedFacets;
            this.reducedAggregations = reducedAggregations;
        }

        public long count() {
            return this.count;
        }

        public PercolateResponse.Match[] matches() {
            return this.matches;
        }

        public InternalFacets reducedFacets() {
            return this.reducedFacets;
        }

        public InternalAggregations reducedAggregations() {
            return this.reducedAggregations;
        }
    }

    static interface PercolatorType {
        public byte id();

        public ReduceResult reduce(List<PercolateShardResponse> var1);

        public PercolateShardResponse doPercolate(PercolateShardRequest var1, PercolateContext var2, boolean var3);
    }
}

