/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportResponse;

class RecoveryResponse
extends TransportResponse {
    List<String> phase1FileNames = Lists.newArrayList();
    List<Long> phase1FileSizes = Lists.newArrayList();
    List<String> phase1ExistingFileNames = Lists.newArrayList();
    List<Long> phase1ExistingFileSizes = Lists.newArrayList();
    long phase1TotalSize;
    long phase1ExistingTotalSize;
    long phase1Time;
    long phase1ThrottlingWaitTime;
    long startTime;
    int phase2Operations;
    long phase2Time;
    int phase3Operations;
    long phase3Time;

    RecoveryResponse() {
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        super.readFrom(in);
        int size = in.readVInt();
        this.phase1FileNames = Lists.newArrayListWithCapacity(size);
        for (i = 0; i < size; ++i) {
            this.phase1FileNames.add(in.readString());
        }
        size = in.readVInt();
        this.phase1FileSizes = Lists.newArrayListWithCapacity(size);
        for (i = 0; i < size; ++i) {
            this.phase1FileSizes.add(in.readVLong());
        }
        size = in.readVInt();
        this.phase1ExistingFileNames = Lists.newArrayListWithCapacity(size);
        for (i = 0; i < size; ++i) {
            this.phase1ExistingFileNames.add(in.readString());
        }
        size = in.readVInt();
        this.phase1ExistingFileSizes = Lists.newArrayListWithCapacity(size);
        for (i = 0; i < size; ++i) {
            this.phase1ExistingFileSizes.add(in.readVLong());
        }
        this.phase1TotalSize = in.readVLong();
        this.phase1ExistingTotalSize = in.readVLong();
        this.phase1Time = in.readVLong();
        this.phase1ThrottlingWaitTime = in.readVLong();
        this.startTime = in.readVLong();
        this.phase2Operations = in.readVInt();
        this.phase2Time = in.readVLong();
        this.phase3Operations = in.readVInt();
        this.phase3Time = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        long size;
        super.writeTo(out);
        out.writeVInt(this.phase1FileNames.size());
        for (String name : this.phase1FileNames) {
            out.writeString(name);
        }
        out.writeVInt(this.phase1FileSizes.size());
        Iterator<Object> i$ = this.phase1FileSizes.iterator();
        while (i$.hasNext()) {
            size = (Long)i$.next();
            out.writeVLong(size);
        }
        out.writeVInt(this.phase1ExistingFileNames.size());
        for (String name : this.phase1ExistingFileNames) {
            out.writeString(name);
        }
        out.writeVInt(this.phase1ExistingFileSizes.size());
        i$ = this.phase1ExistingFileSizes.iterator();
        while (i$.hasNext()) {
            size = (Long)i$.next();
            out.writeVLong(size);
        }
        out.writeVLong(this.phase1TotalSize);
        out.writeVLong(this.phase1ExistingTotalSize);
        out.writeVLong(this.phase1Time);
        out.writeVLong(this.phase1ThrottlingWaitTime);
        out.writeVLong(this.startTime);
        out.writeVInt(this.phase2Operations);
        out.writeVLong(this.phase2Time);
        out.writeVInt(this.phase3Operations);
        out.writeVLong(this.phase3Time);
    }
}

