/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.Channels;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.TranslogStream;
import org.elasticsearch.index.translog.TranslogStreams;
import org.elasticsearch.index.translog.fs.FsChannelSnapshot;
import org.elasticsearch.index.translog.fs.FsTranslogFile;
import org.elasticsearch.index.translog.fs.RafReference;

public class SimpleFsTranslogFile
implements FsTranslogFile {
    private final long id;
    private final ShardId shardId;
    private final RafReference raf;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private final TranslogStream translogStream;
    private final int headerSize;
    private volatile int operationCounter = 0;
    private volatile long lastPosition = 0L;
    private volatile long lastWrittenPosition = 0L;
    private volatile long lastSyncPosition = 0L;

    public SimpleFsTranslogFile(ShardId shardId, long id, RafReference raf) throws IOException {
        this.shardId = shardId;
        this.id = id;
        this.raf = raf;
        raf.raf().setLength(0L);
        this.translogStream = TranslogStreams.translogStreamFor(this.raf.file());
        this.headerSize = this.translogStream.writeHeader(raf.channel());
        this.lastPosition += (long)this.headerSize;
        this.lastWrittenPosition += (long)this.headerSize;
        this.lastSyncPosition += (long)this.headerSize;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public int estimatedNumberOfOperations() {
        return this.operationCounter;
    }

    @Override
    public long translogSizeInBytes() {
        return this.lastWrittenPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Translog.Location add(BytesReference data) throws IOException {
        this.rwl.writeLock().lock();
        try {
            long position = this.lastPosition;
            data.writeTo(this.raf.channel());
            this.lastPosition += (long)data.length();
            this.lastWrittenPosition += (long)data.length();
            ++this.operationCounter;
            Translog.Location location = new Translog.Location(this.id, position, data.length());
            return location;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read(Translog.Location location) throws IOException {
        this.rwl.readLock().lock();
        try {
            byte[] byArray = Channels.readFromFileChannel(this.raf.channel(), location.translogLocation, location.size);
            return byArray;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean delete) {
        block6: {
            if (!this.closed.compareAndSet(false, true)) {
                return;
            }
            try {
                if (delete) break block6;
                try {
                    this.sync();
                }
                catch (Exception e) {
                    throw new TranslogException(this.shardId, "failed to sync on close", (Throwable)e);
                }
            }
            finally {
                this.raf.decreaseRefCount(delete);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FsChannelSnapshot snapshot() throws TranslogException {
        if (this.raf.increaseRefCount()) {
            boolean success = false;
            try {
                this.rwl.writeLock().lock();
                try {
                    FsChannelSnapshot snapshot = new FsChannelSnapshot(this.id, this.raf, this.lastWrittenPosition, this.operationCounter);
                    snapshot.seekTo(this.headerSize);
                    success = true;
                    FsChannelSnapshot fsChannelSnapshot = snapshot;
                    this.rwl.writeLock().unlock();
                    return fsChannelSnapshot;
                }
                catch (Throwable throwable) {
                    try {
                        this.rwl.writeLock().unlock();
                        throw throwable;
                    }
                    catch (FileNotFoundException e) {
                        throw new TranslogException(this.shardId, "failed to create snapshot", (Throwable)e);
                    }
                }
            }
            finally {
                if (!success) {
                    this.raf.decreaseRefCount(false);
                }
            }
        }
        return null;
    }

    @Override
    public boolean syncNeeded() {
        return this.lastWrittenPosition != this.lastSyncPosition;
    }

    @Override
    public TranslogStream getStream() {
        return this.translogStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() throws IOException {
        if (!this.syncNeeded()) {
            return;
        }
        this.rwl.writeLock().lock();
        try {
            this.lastSyncPosition = this.lastWrittenPosition;
            this.raf.channel().force(false);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public void reuse(FsTranslogFile other) {
    }

    @Override
    public void updateBufferSize(int bufferSize) throws TranslogException {
    }
}

