/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.snapshots;

import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.cluster.routing.RestoreSource;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.engine.SnapshotFailedEngineException;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.index.snapshots.IndexShardRepository;
import org.elasticsearch.index.snapshots.IndexShardRestoreFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.snapshots.RestoreService;

public class IndexShardSnapshotAndRestoreService
extends AbstractIndexShardComponent {
    private final InternalIndexShard indexShard;
    private final RepositoriesService repositoriesService;
    private final RestoreService restoreService;

    @Inject
    public IndexShardSnapshotAndRestoreService(ShardId shardId, @IndexSettings Settings indexSettings, IndexShard indexShard, RepositoriesService repositoriesService, RestoreService restoreService) {
        super(shardId, indexSettings);
        this.indexShard = (InternalIndexShard)indexShard;
        this.repositoriesService = repositoriesService;
        this.restoreService = restoreService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapshot(SnapshotId snapshotId, IndexShardSnapshotStatus snapshotStatus) {
        IndexShardRepository indexShardRepository = this.repositoriesService.indexShardRepository(snapshotId.getRepository());
        if (!this.indexShard.routingEntry().primary()) {
            throw new IndexShardSnapshotFailedException(this.shardId, "snapshot should be performed only on primary");
        }
        if (this.indexShard.routingEntry().relocating()) {
            throw new IndexShardSnapshotFailedException(this.shardId, "cannot snapshot while relocating");
        }
        if (this.indexShard.state() == IndexShardState.CREATED || this.indexShard.state() == IndexShardState.RECOVERING) {
            throw new IndexShardSnapshotFailedException(this.shardId, "shard didn't fully recover yet");
        }
        try (SnapshotIndexCommit snapshotIndexCommit = this.indexShard.snapshotIndex();){
            indexShardRepository.snapshot(snapshotId, this.shardId, snapshotIndexCommit, snapshotStatus);
            if (this.logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("snapshot (").append(snapshotId.getSnapshot()).append(") completed to ").append(indexShardRepository).append(", took [").append(TimeValue.timeValueMillis(snapshotStatus.time())).append("]\n");
                sb.append("    index    : version [").append(snapshotStatus.indexVersion()).append("], number_of_files [").append(snapshotStatus.numberOfFiles()).append("] with total_size [").append(new ByteSizeValue(snapshotStatus.totalSize())).append("]\n");
                this.logger.debug(sb.toString(), new Object[0]);
            }
        }
        catch (SnapshotFailedEngineException e) {
            throw e;
        }
        catch (IndexShardSnapshotFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IndexShardSnapshotFailedException(this.shardId, "Failed to snapshot", e);
        }
    }

    public void restore(RecoveryState recoveryState) {
        RestoreSource restoreSource = this.indexShard.routingEntry().restoreSource();
        if (restoreSource == null) {
            throw new IndexShardRestoreFailedException(this.shardId, "empty restore source");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] restoring shard  [{}]", restoreSource.snapshotId(), this.shardId);
        }
        try {
            IndexShardRepository indexShardRepository = this.repositoriesService.indexShardRepository(restoreSource.snapshotId().getRepository());
            ShardId snapshotShardId = this.shardId;
            if (!this.shardId.getIndex().equals(restoreSource.index())) {
                snapshotShardId = new ShardId(restoreSource.index(), this.shardId.id());
            }
            indexShardRepository.restore(restoreSource.snapshotId(), this.shardId, snapshotShardId, recoveryState);
            this.restoreService.indexShardRestoreCompleted(restoreSource.snapshotId(), this.shardId);
        }
        catch (Throwable t) {
            if (Lucene.isCorruptionException(t)) {
                this.restoreService.failRestore(restoreSource.snapshotId(), this.shardId());
            }
            throw new IndexShardRestoreFailedException(this.shardId, "restore failed", t);
        }
    }
}

