/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermFilter;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.search.AndFilter;
import org.elasticsearch.common.lucene.search.OrFilter;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.lucene.search.XBooleanFilter;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.indices.cache.filter.terms.IndicesTermsFilterCache;
import org.elasticsearch.indices.cache.filter.terms.TermsLookup;

public class TermsFilterParser
implements FilterParser {
    public static final String NAME = "terms";
    private IndicesTermsFilterCache termsFilterCache;
    public static final String EXECUTION_KEY = "execution";
    public static final String EXECUTION_VALUE_PLAIN = "plain";
    public static final String EXECUTION_VALUE_FIELDDATA = "fielddata";
    public static final String EXECUTION_VALUE_BOOL = "bool";
    public static final String EXECUTION_VALUE_BOOL_NOCACHE = "bool_nocache";
    public static final String EXECUTION_VALUE_AND = "and";
    public static final String EXECUTION_VALUE_AND_NOCACHE = "and_nocache";
    public static final String EXECUTION_VALUE_OR = "or";
    public static final String EXECUTION_VALUE_OR_NOCACHE = "or_nocache";

    @Inject
    public TermsFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "in"};
    }

    @Inject(optional=true)
    public void setIndicesTermsFilterCache(IndicesTermsFilterCache termsFilterCache) {
        this.termsFilterCache = termsFilterCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        block84: {
            block82: {
                block83: {
                    block85: {
                        parser = parseContext.parser();
                        cache = null;
                        filterName = null;
                        currentFieldName = null;
                        lookupIndex = parseContext.index().name();
                        lookupType = null;
                        lookupId = null;
                        lookupPath = null;
                        lookupRouting = null;
                        lookupCache = true;
                        cacheKey = null;
                        execution = "plain";
                        terms = Lists.newArrayList();
                        fieldName = null;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.START_ARRAY) {
                                if (fieldName != null) {
                                    throw new QueryParsingException(parseContext.index(), "[terms] filter does not support multiple fields");
                                }
                                fieldName = currentFieldName;
                                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                    value = parser.objectBytes();
                                    if (value == null) {
                                        throw new QueryParsingException(parseContext.index(), "No value specified for terms filter");
                                    }
                                    terms.add(value);
                                }
                                continue;
                            }
                            if (token == XContentParser.Token.START_OBJECT) {
                                fieldName = currentFieldName;
                                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                                    if (token == XContentParser.Token.FIELD_NAME) {
                                        currentFieldName = parser.currentName();
                                        continue;
                                    }
                                    if (!token.isValue()) continue;
                                    if ("index".equals(currentFieldName)) {
                                        lookupIndex = parser.text();
                                        continue;
                                    }
                                    if ("type".equals(currentFieldName)) {
                                        lookupType = parser.text();
                                        continue;
                                    }
                                    if ("id".equals(currentFieldName)) {
                                        lookupId = parser.text();
                                        continue;
                                    }
                                    if ("path".equals(currentFieldName)) {
                                        lookupPath = parser.text();
                                        continue;
                                    }
                                    if ("routing".equals(currentFieldName)) {
                                        lookupRouting = parser.textOrNull();
                                        continue;
                                    }
                                    if ("cache".equals(currentFieldName)) {
                                        lookupCache = parser.booleanValue();
                                        continue;
                                    }
                                    throw new QueryParsingException(parseContext.index(), "[terms] filter does not support [" + currentFieldName + "] within lookup element");
                                }
                                if (lookupType == null) {
                                    throw new QueryParsingException(parseContext.index(), "[terms] filter lookup element requires specifying the type");
                                }
                                if (lookupId == null) {
                                    throw new QueryParsingException(parseContext.index(), "[terms] filter lookup element requires specifying the id");
                                }
                                if (lookupPath != null) continue;
                                throw new QueryParsingException(parseContext.index(), "[terms] filter lookup element requires specifying the path");
                            }
                            if (!token.isValue()) continue;
                            if ("execution".equals(currentFieldName)) {
                                execution = parser.text();
                                continue;
                            }
                            if ("_name".equals(currentFieldName)) {
                                filterName = parser.text();
                                continue;
                            }
                            if ("_cache".equals(currentFieldName)) {
                                cache = parser.booleanValue();
                                continue;
                            }
                            if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                                cacheKey = new CacheKeyFilter.Key(parser.text());
                                continue;
                            }
                            throw new QueryParsingException(parseContext.index(), "[terms] filter does not support [" + currentFieldName + "]");
                        }
                        if (fieldName == null) {
                            throw new QueryParsingException(parseContext.index(), "terms filter requires a field name, followed by array of terms");
                        }
                        fieldMapper = null;
                        smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
                        previousTypes = null;
                        if (smartNameFieldMappers != null) {
                            if (smartNameFieldMappers.hasMapper()) {
                                fieldMapper = smartNameFieldMappers.mapper();
                                fieldName = fieldMapper.names().indexName();
                            }
                            if (smartNameFieldMappers.explicitTypeInNameWithDocMapper()) {
                                previousTypes = QueryParseContext.setTypesWithPrevious(new String[]{smartNameFieldMappers.docMapper().type()});
                            }
                        }
                        if (lookupId != null) {
                            if (fieldMapper == null) {
                                return Queries.MATCH_NO_FILTER;
                            }
                            termsLookup = new TermsLookup(fieldMapper, lookupIndex, lookupType, lookupId, lookupRouting, lookupPath, parseContext);
                            filter = this.termsFilterCache.termsFilter(termsLookup, lookupCache, cacheKey);
                            if (filter == null) {
                                return null;
                            }
                            if (cache == null || cache.booleanValue()) {
                                filter = parseContext.cacheFilter(filter, cacheKey);
                            }
                            return filter;
                        }
                        if (terms.isEmpty()) {
                            return Queries.MATCH_NO_FILTER;
                        }
                        if (!"plain".equals(execution)) break block85;
                        if (fieldMapper != null) {
                            filter = fieldMapper.termsFilter(terms, parseContext);
                        } else {
                            filterValues = new BytesRef[terms.size()];
                            for (i = 0; i < filterValues.length; ++i) {
                                filterValues[i] = BytesRefs.toBytesRef(terms.get(i));
                            }
                            filter = new TermsFilter(fieldName, filterValues);
                        }
                        if (cache == null || cache.booleanValue()) {
                            filter = parseContext.cacheFilter(filter, cacheKey);
                        }
                        ** GOTO lbl220
                    }
                    if (!"fielddata".equals(execution)) ** GOTO lbl127
                    if (fieldMapper != null) break block82;
                    filterValues = Queries.MATCH_NO_FILTER;
                    if (smartNameFieldMappers == null || !smartNameFieldMappers.explicitTypeInNameWithDocMapper()) break block83;
                    QueryParseContext.setTypes(previousTypes);
                }
                return filterValues;
            }
            try {
                block86: {
                    filter = fieldMapper.fieldDataTermsFilter(terms, parseContext);
                    if (cache != null && cache.booleanValue()) {
                        filter = parseContext.cacheFilter(filter, cacheKey);
                    }
                    break block86;
lbl127:
                    // 1 sources

                    if ("bool".equals(execution)) {
                        boolFiler = new XBooleanFilter();
                        if (fieldMapper != null) {
                            for (E term : terms) {
                                boolFiler.add(parseContext.cacheFilter(fieldMapper.termFilter(term, parseContext), null), BooleanClause.Occur.SHOULD);
                            }
                        } else {
                            for (E term : terms) {
                                boolFiler.add(parseContext.cacheFilter((Filter)new TermFilter(new Term(fieldName, BytesRefs.toBytesRef(term))), null), BooleanClause.Occur.SHOULD);
                            }
                        }
                        filter = boolFiler;
                        if (cache != null && cache.booleanValue()) {
                            filter = parseContext.cacheFilter(filter, cacheKey);
                        }
                    } else if ("bool_nocache".equals(execution)) {
                        boolFiler = new XBooleanFilter();
                        if (fieldMapper != null) {
                            for (E term : terms) {
                                boolFiler.add(fieldMapper.termFilter(term, parseContext), BooleanClause.Occur.SHOULD);
                            }
                        } else {
                            for (E term : terms) {
                                boolFiler.add((Filter)new TermFilter(new Term(fieldName, BytesRefs.toBytesRef(term))), BooleanClause.Occur.SHOULD);
                            }
                        }
                        filter = boolFiler;
                        if (cache == null || cache.booleanValue()) {
                            filter = parseContext.cacheFilter(filter, cacheKey);
                        }
                    } else if ("and".equals(execution)) {
                        filters = Lists.newArrayList();
                        if (fieldMapper != null) {
                            for (E term : terms) {
                                filters.add(parseContext.cacheFilter(fieldMapper.termFilter(term, parseContext), null));
                            }
                        } else {
                            for (E term : terms) {
                                filters.add(parseContext.cacheFilter((Filter)new TermFilter(new Term(fieldName, BytesRefs.toBytesRef(term))), null));
                            }
                        }
                        filter = new AndFilter(filters);
                        if (cache != null && cache.booleanValue()) {
                            filter = parseContext.cacheFilter(filter, cacheKey);
                        }
                    } else if ("and_nocache".equals(execution)) {
                        filters = Lists.newArrayList();
                        if (fieldMapper != null) {
                            for (E term : terms) {
                                filters.add(fieldMapper.termFilter(term, parseContext));
                            }
                        } else {
                            for (E term : terms) {
                                filters.add(new TermFilter(new Term(fieldName, BytesRefs.toBytesRef(term))));
                            }
                        }
                        filter = new AndFilter(filters);
                        if (cache == null || cache.booleanValue()) {
                            filter = parseContext.cacheFilter(filter, cacheKey);
                        }
                    } else if ("or".equals(execution)) {
                        filters = Lists.newArrayList();
                        if (fieldMapper != null) {
                            for (E term : terms) {
                                filters.add(parseContext.cacheFilter(fieldMapper.termFilter(term, parseContext), null));
                            }
                        } else {
                            for (E term : terms) {
                                filters.add(parseContext.cacheFilter((Filter)new TermFilter(new Term(fieldName, BytesRefs.toBytesRef(term))), null));
                            }
                        }
                        filter = new OrFilter(filters);
                        if (cache != null && cache.booleanValue()) {
                            filter = parseContext.cacheFilter(filter, cacheKey);
                        }
                    } else if ("or_nocache".equals(execution)) {
                        filters = Lists.newArrayList();
                        if (fieldMapper != null) {
                            for (E term : terms) {
                                filters.add(fieldMapper.termFilter(term, parseContext));
                            }
                        } else {
                            for (E term : terms) {
                                filters.add(new TermFilter(new Term(fieldName, BytesRefs.toBytesRef(term))));
                            }
                        }
                        filter = new OrFilter(filters);
                        if (cache == null || cache.booleanValue()) {
                            filter = parseContext.cacheFilter(filter, cacheKey);
                        }
                    } else {
                        throw new QueryParsingException(parseContext.index(), "terms filter execution value [" + execution + "] not supported");
                    }
                }
                filter = QueryParsers.wrapSmartNameFilter(filter, smartNameFieldMappers, parseContext);
                if (filterName != null) {
                    parseContext.addNamedFilter(filterName, filter);
                }
                var21_23 = filter;
                if (smartNameFieldMappers == null || !smartNameFieldMappers.explicitTypeInNameWithDocMapper()) break block84;
            }
            catch (Throwable var24_50) {
                if (smartNameFieldMappers != null && smartNameFieldMappers.explicitTypeInNameWithDocMapper()) {
                    QueryParseContext.setTypes(previousTypes);
                }
                throw var24_50;
            }
            QueryParseContext.setTypes(previousTypes);
        }
        return var21_23;
    }
}

