/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.Sorter;

public abstract class SortingNumericDocValues
extends SortedNumericDocValues {
    protected int count;
    protected long[] values = new long[1];
    private final Sorter sorter = new InPlaceMergeSorter(){

        protected void swap(int i, int j) {
            long tmp = SortingNumericDocValues.this.values[i];
            SortingNumericDocValues.this.values[i] = SortingNumericDocValues.this.values[j];
            SortingNumericDocValues.this.values[j] = tmp;
        }

        protected int compare(int i, int j) {
            return Long.compare(SortingNumericDocValues.this.values[i], SortingNumericDocValues.this.values[j]);
        }
    };

    protected SortingNumericDocValues() {
    }

    protected final void grow() {
        this.values = ArrayUtil.grow((long[])this.values, (int)this.count);
    }

    protected final void sort() {
        this.sorter.sort(0, this.count);
    }

    public final int count() {
        return this.count;
    }

    public final long valueAt(int index) {
        return this.values[index];
    }
}

