/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mustache;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.CacheLoader;
import org.elasticsearch.common.cache.LoadingCache;
import org.elasticsearch.common.mustache.DefaultMustacheVisitor;
import org.elasticsearch.common.mustache.FragmentKey;
import org.elasticsearch.common.mustache.Mustache;
import org.elasticsearch.common.mustache.MustacheException;
import org.elasticsearch.common.mustache.MustacheFactory;
import org.elasticsearch.common.mustache.MustacheParser;
import org.elasticsearch.common.mustache.MustacheVisitor;
import org.elasticsearch.common.mustache.ObjectHandler;
import org.elasticsearch.common.mustache.TemplateContext;
import org.elasticsearch.common.mustache.reflect.ReflectionObjectHandler;
import org.elasticsearch.common.mustache.util.HtmlEscaper;
import org.elasticsearch.common.util.concurrent.ListeningExecutorService;
import org.elasticsearch.common.util.concurrent.MoreExecutors;
import org.elasticsearch.common.util.concurrent.UncheckedExecutionException;

public class DefaultMustacheFactory
implements MustacheFactory {
    protected final LoadingCache<String, Mustache> mustacheCache = this.createMustacheCache();
    protected ObjectHandler oh = new ReflectionObjectHandler();
    protected final MustacheParser mc = new MustacheParser(this);
    protected final LoadingCache<FragmentKey, Mustache> templateCache = this.createLambdaCache();
    protected int recursionLimit = 100;
    private final String resourceRoot;
    private final File fileRoot;
    protected ListeningExecutorService les;

    public DefaultMustacheFactory() {
        this.resourceRoot = null;
        this.fileRoot = null;
    }

    public DefaultMustacheFactory(String resourceRoot) {
        if (!resourceRoot.endsWith("/")) {
            resourceRoot = resourceRoot + "/";
        }
        this.resourceRoot = resourceRoot;
        this.fileRoot = null;
    }

    public DefaultMustacheFactory(File fileRoot) {
        if (!fileRoot.exists()) {
            throw new MustacheException(fileRoot + " does not exist");
        }
        if (!fileRoot.isDirectory()) {
            throw new MustacheException(fileRoot + " is not a directory");
        }
        this.fileRoot = fileRoot;
        this.resourceRoot = null;
    }

    @Override
    public MustacheVisitor createMustacheVisitor() {
        return new DefaultMustacheVisitor(this);
    }

    @Override
    public Reader getReader(String resourceName) {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        InputStream is = ccl.getResourceAsStream((this.resourceRoot == null ? "" : this.resourceRoot) + resourceName);
        if (is == null) {
            File file;
            File file2 = file = this.fileRoot == null ? new File(resourceName) : new File(this.fileRoot, resourceName);
            if (file.exists() && file.isFile()) {
                try {
                    File checkRoot = this.fileRoot == null ? new File("").getCanonicalFile() : this.fileRoot.getCanonicalFile();
                    File parent = file.getCanonicalFile();
                    while ((parent = parent.getParentFile()) != null && !parent.equals(checkRoot)) {
                    }
                    if (parent == null) {
                        throw new MustacheException("File not under root: " + checkRoot.getAbsolutePath());
                    }
                    is = new FileInputStream(file);
                }
                catch (IOException e) {
                    throw new MustacheException("Found file, could not open: " + file, e);
                }
            }
        }
        if (is == null) {
            throw new MustacheException("Template '" + resourceName + "' not found");
        }
        return new BufferedReader(new InputStreamReader(is, Charsets.UTF_8));
    }

    @Override
    public void encode(String value, Writer writer) {
        HtmlEscaper.escape(value, writer, true);
    }

    @Override
    public ObjectHandler getObjectHandler() {
        return this.oh;
    }

    public void setObjectHandler(ObjectHandler oh) {
        this.oh = oh;
    }

    public ExecutorService getExecutorService() {
        return this.les;
    }

    public void setExecutorService(ExecutorService es) {
        this.les = es instanceof ListeningExecutorService ? (ListeningExecutorService)es : MoreExecutors.listeningDecorator(es);
    }

    public Mustache getFragment(FragmentKey templateKey) {
        try {
            Mustache mustache = this.templateCache.get(templateKey);
            mustache.init();
            return mustache;
        }
        catch (ExecutionException e) {
            throw this.handle(e);
        }
    }

    private MustacheException handle(Exception e) {
        Throwable cause = e.getCause();
        if (cause instanceof MustacheException) {
            return (MustacheException)cause;
        }
        return new MustacheException(cause);
    }

    @Override
    public Mustache compile(String name) {
        try {
            Mustache mustache = this.mustacheCache.get(name);
            mustache.init();
            return mustache;
        }
        catch (UncheckedExecutionException e) {
            throw this.handle(e);
        }
        catch (ExecutionException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Mustache compile(Reader reader, String name) {
        return this.compile(reader, name, "{{", "}}");
    }

    public Mustache compile(Reader reader, String file, String sm, String em) {
        Mustache compile = this.mc.compile(reader, file, sm, em);
        compile.init();
        return compile;
    }

    @Override
    public String translate(String from) {
        return from;
    }

    public String filterText(String appended, boolean b) {
        return appended;
    }

    public void setRecursionLimit(int recursionLimit) {
        this.recursionLimit = recursionLimit;
    }

    public int getRecursionLimit() {
        return this.recursionLimit;
    }

    protected LoadingCache<String, Mustache> createMustacheCache() {
        return CacheBuilder.newBuilder().build(new MustacheCacheLoader());
    }

    protected LoadingCache<FragmentKey, Mustache> createLambdaCache() {
        return CacheBuilder.newBuilder().build(new FragmentCacheLoader());
    }

    protected class FragmentCacheLoader
    extends CacheLoader<FragmentKey, Mustache> {
        protected FragmentCacheLoader() {
        }

        @Override
        public Mustache load(FragmentKey fragmentKey) throws Exception {
            StringReader reader = new StringReader(fragmentKey.templateText);
            TemplateContext tc = fragmentKey.tc;
            return DefaultMustacheFactory.this.mc.compile(reader, tc.file(), tc.startChars(), tc.endChars(), tc.startOfLine());
        }
    }

    protected class MustacheCacheLoader
    extends CacheLoader<String, Mustache> {
        protected MustacheCacheLoader() {
        }

        @Override
        public Mustache load(String key) throws Exception {
            return DefaultMustacheFactory.this.mc.compile(key);
        }
    }
}

