/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.joda;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.MutableDateTime;
import org.elasticsearch.common.joda.time.format.DateTimeFormatter;

public class DateMathParser {
    private final FormatDateTimeFormatter dateTimeFormatter;
    private final TimeUnit timeUnit;

    public DateMathParser(FormatDateTimeFormatter dateTimeFormatter, TimeUnit timeUnit) {
        this.dateTimeFormatter = dateTimeFormatter;
        this.timeUnit = timeUnit;
    }

    public long parse(String text, long now) {
        return this.parse(text, now, false, null);
    }

    public long parse(String text, long now, DateTimeZone timeZone) {
        return this.parse(text, now, false, timeZone);
    }

    public long parseRoundCeil(String text, long now) {
        return this.parse(text, now, true, null);
    }

    public long parseRoundCeil(String text, long now, DateTimeZone timeZone) {
        return this.parse(text, now, true, timeZone);
    }

    public long parse(String text, long now, boolean roundCeil) {
        return this.parse(text, now, roundCeil, null);
    }

    public long parse(String text, long now, boolean roundCeil, DateTimeZone timeZone) {
        String mathString;
        long time;
        if (text.startsWith("now")) {
            time = now;
            mathString = text.substring("now".length());
        } else {
            String parseString;
            int index = text.indexOf("||");
            if (index == -1) {
                parseString = text;
                mathString = "";
            } else {
                parseString = text.substring(0, index);
                mathString = text.substring(index + 2);
            }
            time = roundCeil ? this.parseRoundCeilStringValue(parseString, timeZone) : this.parseStringValue(parseString, timeZone);
        }
        if (mathString.isEmpty()) {
            return time;
        }
        return this.parseMath(mathString, time, roundCeil);
    }

    private long parseMath(String mathString, long time, boolean roundUp) throws ElasticsearchParseException {
        MutableDateTime dateTime = new MutableDateTime(time, DateTimeZone.UTC);
        try {
            int i = 0;
            block11: while (i < mathString.length()) {
                int num;
                int type;
                char c;
                if ((c = mathString.charAt(i++)) == '/') {
                    type = 0;
                } else if (c == '+') {
                    type = 1;
                } else if (c == '-') {
                    type = 2;
                } else {
                    throw new ElasticsearchParseException("operator not supported for date math [" + mathString + "]");
                }
                if (!Character.isDigit(mathString.charAt(i))) {
                    num = 1;
                } else {
                    int numFrom = i;
                    while (Character.isDigit(mathString.charAt(i))) {
                        ++i;
                    }
                    num = Integer.parseInt(mathString.substring(numFrom, i));
                }
                if (type == 0 && num != 1) {
                    throw new ElasticsearchParseException("rounding `/` can only be used on single unit types [" + mathString + "]");
                }
                char unit = mathString.charAt(i++);
                switch (unit) {
                    case 'y': {
                        if (type == 0) {
                            if (roundUp) {
                                dateTime.yearOfCentury().roundCeiling();
                                continue block11;
                            }
                            dateTime.yearOfCentury().roundFloor();
                            continue block11;
                        }
                        if (type == 1) {
                            dateTime.addYears(num);
                            continue block11;
                        }
                        if (type != 2) continue block11;
                        dateTime.addYears(-num);
                        continue block11;
                    }
                    case 'M': {
                        if (type == 0) {
                            if (roundUp) {
                                dateTime.monthOfYear().roundCeiling();
                                continue block11;
                            }
                            dateTime.monthOfYear().roundFloor();
                            continue block11;
                        }
                        if (type == 1) {
                            dateTime.addMonths(num);
                            continue block11;
                        }
                        if (type != 2) continue block11;
                        dateTime.addMonths(-num);
                        continue block11;
                    }
                    case 'w': {
                        if (type == 0) {
                            if (roundUp) {
                                dateTime.weekOfWeekyear().roundCeiling();
                                continue block11;
                            }
                            dateTime.weekOfWeekyear().roundFloor();
                            continue block11;
                        }
                        if (type == 1) {
                            dateTime.addWeeks(num);
                            continue block11;
                        }
                        if (type != 2) continue block11;
                        dateTime.addWeeks(-num);
                        continue block11;
                    }
                    case 'd': {
                        if (type == 0) {
                            if (roundUp) {
                                dateTime.dayOfMonth().roundCeiling();
                                continue block11;
                            }
                            dateTime.dayOfMonth().roundFloor();
                            continue block11;
                        }
                        if (type == 1) {
                            dateTime.addDays(num);
                            continue block11;
                        }
                        if (type != 2) continue block11;
                        dateTime.addDays(-num);
                        continue block11;
                    }
                    case 'H': 
                    case 'h': {
                        if (type == 0) {
                            if (roundUp) {
                                dateTime.hourOfDay().roundCeiling();
                                continue block11;
                            }
                            dateTime.hourOfDay().roundFloor();
                            continue block11;
                        }
                        if (type == 1) {
                            dateTime.addHours(num);
                            continue block11;
                        }
                        if (type != 2) continue block11;
                        dateTime.addHours(-num);
                        continue block11;
                    }
                    case 'm': {
                        if (type == 0) {
                            if (roundUp) {
                                dateTime.minuteOfHour().roundCeiling();
                                continue block11;
                            }
                            dateTime.minuteOfHour().roundFloor();
                            continue block11;
                        }
                        if (type == 1) {
                            dateTime.addMinutes(num);
                            continue block11;
                        }
                        if (type != 2) continue block11;
                        dateTime.addMinutes(-num);
                        continue block11;
                    }
                    case 's': {
                        if (type == 0) {
                            if (roundUp) {
                                dateTime.secondOfMinute().roundCeiling();
                                continue block11;
                            }
                            dateTime.secondOfMinute().roundFloor();
                            continue block11;
                        }
                        if (type == 1) {
                            dateTime.addSeconds(num);
                            continue block11;
                        }
                        if (type != 2) continue block11;
                        dateTime.addSeconds(-num);
                        continue block11;
                    }
                }
                throw new ElasticsearchParseException("unit [" + unit + "] not supported for date math [" + mathString + "]");
            }
        }
        catch (Exception e) {
            if (e instanceof ElasticsearchParseException) {
                throw (ElasticsearchParseException)e;
            }
            throw new ElasticsearchParseException("failed to parse date math [" + mathString + "]");
        }
        return dateTime.getMillis();
    }

    public static DateTimeFormatter getDateTimeFormatterParser(FormatDateTimeFormatter dateTimeFormatter, DateTimeZone timeZone) {
        if (dateTimeFormatter == null) {
            return null;
        }
        DateTimeFormatter parser = dateTimeFormatter.parser();
        if (timeZone != null) {
            parser = parser.withZone(timeZone);
        }
        return parser;
    }

    private long parseStringValue(String value, DateTimeZone timeZone) {
        try {
            DateTimeFormatter parser = DateMathParser.getDateTimeFormatterParser(this.dateTimeFormatter, timeZone);
            return parser.parseMillis(value);
        }
        catch (RuntimeException e) {
            try {
                long time = Long.parseLong(value);
                return this.timeUnit.toMillis(time);
            }
            catch (NumberFormatException e1) {
                throw new ElasticsearchParseException("failed to parse date field [" + value + "], tried both date format [" + this.dateTimeFormatter.format() + "], and timestamp number", e);
            }
        }
    }

    private long parseRoundCeilStringValue(String value, DateTimeZone timeZone) {
        try {
            MutableDateTime dateTime = new MutableDateTime(1970, 1, 1, 23, 59, 59, 999, DateTimeZone.UTC);
            DateTimeFormatter parser = DateMathParser.getDateTimeFormatterParser(this.dateTimeFormatter, timeZone);
            int location = parser.parseInto(dateTime, value, 0);
            if (location == value.length()) {
                return dateTime.getMillis();
            }
            if (location <= 0 || dateTime.getYear() > 5000) {
                try {
                    long time = Long.parseLong(value);
                    return this.timeUnit.toMillis(time);
                }
                catch (NumberFormatException e1) {
                    throw new ElasticsearchParseException("failed to parse date field [" + value + "], tried both date format [" + this.dateTimeFormatter.format() + "], and timestamp number");
                }
            }
            return dateTime.getMillis();
        }
        catch (RuntimeException e) {
            try {
                long time = Long.parseLong(value);
                return this.timeUnit.toMillis(time);
            }
            catch (NumberFormatException e1) {
                throw new ElasticsearchParseException("failed to parse date field [" + value + "], tried both date format [" + this.dateTimeFormatter.format() + "], and timestamp number", e);
            }
        }
    }

    public static DateTimeZone parseZone(String text) throws IOException {
        int index = text.indexOf(58);
        if (index != -1) {
            int beginIndex = text.charAt(0) == '+' ? 1 : 0;
            return DateTimeZone.forOffsetHoursMinutes(Integer.parseInt(text.substring(beginIndex, index)), Integer.parseInt(text.substring(index + 1)));
        }
        return DateTimeZone.forID(text);
    }
}

