/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;

public final class UpdateInPlaceMap<K, V> {
    final int switchSize;
    final AtomicBoolean mutating = new AtomicBoolean();
    volatile ImmutableOpenMap<K, V> immutableMap;
    volatile ConcurrentMap<K, V> concurrentMap;

    UpdateInPlaceMap(int switchSize) {
        this.switchSize = switchSize;
        if (switchSize == 0) {
            this.concurrentMap = ConcurrentCollections.newConcurrentMap();
            this.immutableMap = null;
        } else {
            this.concurrentMap = null;
            this.immutableMap = ImmutableOpenMap.of();
        }
    }

    public boolean isEmpty() {
        ImmutableOpenMap<K, V> immutableMap = this.immutableMap;
        ConcurrentMap<K, V> concurrentMap = this.concurrentMap;
        return immutableMap != null ? immutableMap.isEmpty() : concurrentMap.isEmpty();
    }

    public V get(K key) {
        ImmutableOpenMap<K, V> immutableMap = this.immutableMap;
        ConcurrentMap<K, V> concurrentMap = this.concurrentMap;
        return immutableMap != null ? immutableMap.get(key) : concurrentMap.get(key);
    }

    public Iterable<V> values() {
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                ImmutableOpenMap immutableMap = UpdateInPlaceMap.this.immutableMap;
                ConcurrentMap concurrentMap = UpdateInPlaceMap.this.concurrentMap;
                if (immutableMap != null) {
                    return immutableMap.valuesIt();
                }
                return Iterables.unmodifiableIterable(concurrentMap.values()).iterator();
            }
        };
    }

    public Mutator mutator() {
        if (!this.mutating.compareAndSet(false, true)) {
            throw new ElasticsearchIllegalStateException("map is already mutating, can't have another mutator on it");
        }
        return new Mutator();
    }

    public static <K, V> UpdateInPlaceMap<K, V> of(int switchSize) {
        return new UpdateInPlaceMap<K, V>(switchSize);
    }

    public final class Mutator
    implements Releasable {
        private ImmutableOpenMap.Builder<K, V> immutableBuilder;

        private Mutator() {
            this.immutableBuilder = UpdateInPlaceMap.this.immutableMap != null ? ImmutableOpenMap.builder(UpdateInPlaceMap.this.immutableMap) : null;
        }

        public V get(K key) {
            if (this.immutableBuilder != null) {
                return this.immutableBuilder.get(key);
            }
            return UpdateInPlaceMap.this.concurrentMap.get(key);
        }

        public V put(K key, V value) {
            if (this.immutableBuilder != null) {
                Object v = this.immutableBuilder.put(key, value);
                this.switchIfNeeded();
                return v;
            }
            return UpdateInPlaceMap.this.concurrentMap.put(key, value);
        }

        public Mutator putAll(Map<K, V> map) {
            for (Map.Entry entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public V remove(K key) {
            return this.immutableBuilder != null ? this.immutableBuilder.remove(key) : UpdateInPlaceMap.this.concurrentMap.remove(key);
        }

        private void switchIfNeeded() {
            if (UpdateInPlaceMap.this.concurrentMap != null) {
                assert (this.immutableBuilder == null);
                return;
            }
            if (this.immutableBuilder.size() <= UpdateInPlaceMap.this.switchSize) {
                return;
            }
            UpdateInPlaceMap.this.concurrentMap = ConcurrentCollections.newConcurrentMap();
            for (ObjectObjectCursor objectObjectCursor : this.immutableBuilder) {
                UpdateInPlaceMap.this.concurrentMap.put(objectObjectCursor.key, objectObjectCursor.value);
            }
            this.immutableBuilder = null;
            UpdateInPlaceMap.this.immutableMap = null;
        }

        @Override
        public void close() {
            if (this.immutableBuilder != null) {
                UpdateInPlaceMap.this.immutableMap = this.immutableBuilder.build();
            }
            assert (this.immutableBuilder != null && UpdateInPlaceMap.this.concurrentMap == null || this.immutableBuilder == null && UpdateInPlaceMap.this.concurrentMap != null);
            UpdateInPlaceMap.this.mutating.set(false);
        }
    }
}

