/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.url;

import java.net.MalformedURLException;
import java.net.URL;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.BlobStoreException;
import org.elasticsearch.common.blobstore.url.URLBlobContainer;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;

public class URLBlobStore
extends AbstractComponent
implements BlobStore {
    private final URL path;
    private final int bufferSizeInBytes;

    public URLBlobStore(Settings settings, URL path) {
        super(settings);
        this.path = path;
        this.bufferSizeInBytes = (int)settings.getAsBytesSize("buffer_size", new ByteSizeValue(100L, ByteSizeUnit.KB)).bytes();
    }

    public String toString() {
        return this.path.toString();
    }

    public URL path() {
        return this.path;
    }

    public int bufferSizeInBytes() {
        return this.bufferSizeInBytes;
    }

    @Override
    public BlobContainer blobContainer(BlobPath path) {
        try {
            return new URLBlobContainer(this, path, this.buildPath(path));
        }
        catch (MalformedURLException ex) {
            throw new BlobStoreException("malformed URL " + path, ex);
        }
    }

    @Override
    public void delete(BlobPath path) {
        throw new UnsupportedOperationException("URL repository is read only");
    }

    @Override
    public void close() {
    }

    private URL buildPath(BlobPath path) throws MalformedURLException {
        String[] paths = path.toArray();
        if (paths.length == 0) {
            return this.path();
        }
        URL blobPath = new URL(this.path, paths[0] + "/");
        if (paths.length > 1) {
            for (int i = 1; i < paths.length; ++i) {
                blobPath = new URL(blobPath, paths[i] + "/");
            }
        }
        return blobPath;
    }
}

