/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.url;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.elasticsearch.common.blobstore.url.URLBlobStore;
import org.elasticsearch.common.collect.ImmutableMap;

public class URLBlobContainer
extends AbstractBlobContainer {
    protected final URLBlobStore blobStore;
    protected final URL path;

    public URLBlobContainer(URLBlobStore blobStore, BlobPath blobPath, URL path) {
        super(blobPath);
        this.blobStore = blobStore;
        this.path = path;
    }

    public URL url() {
        return this.path;
    }

    @Override
    public ImmutableMap<String, BlobMetaData> listBlobs() throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    @Override
    public boolean deleteBlob(String blobName) throws IOException {
        throw new UnsupportedOperationException("URL repository is read only");
    }

    @Override
    public boolean blobExists(String blobName) {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    @Override
    public InputStream openInput(String name) throws IOException {
        return new BufferedInputStream(new URL(this.path, name).openStream(), this.blobStore.bufferSizeInBytes());
    }

    @Override
    public OutputStream createOutput(String blobName) throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }
}

