/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ImmutableShardRouting;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.FailedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingExplanations;
import org.elasticsearch.cluster.routing.allocation.StartedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocators;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommands;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class AllocationService
extends AbstractComponent {
    private final AllocationDeciders allocationDeciders;
    private final ClusterInfoService clusterInfoService;
    private final ShardsAllocators shardsAllocators;

    @Inject
    public AllocationService(Settings settings, AllocationDeciders allocationDeciders, ShardsAllocators shardsAllocators, ClusterInfoService clusterInfoService) {
        super(settings);
        this.allocationDeciders = allocationDeciders;
        this.shardsAllocators = shardsAllocators;
        this.clusterInfoService = clusterInfoService;
    }

    public RoutingAllocation.Result applyStartedShards(ClusterState clusterState, List<? extends ShardRouting> startedShards) {
        return this.applyStartedShards(clusterState, startedShards, true);
    }

    public RoutingAllocation.Result applyStartedShards(ClusterState clusterState, List<? extends ShardRouting> startedShards, boolean withReroute) {
        RoutingNodes routingNodes = clusterState.routingNodes();
        routingNodes.unassigned().shuffle();
        StartedRerouteAllocation allocation = new StartedRerouteAllocation(this.allocationDeciders, routingNodes, clusterState.nodes(), startedShards, this.clusterInfoService.getClusterInfo());
        boolean changed = this.applyStartedShards(routingNodes, startedShards);
        if (!changed) {
            return new RoutingAllocation.Result(false, clusterState.routingTable());
        }
        this.shardsAllocators.applyStartedShards(allocation);
        if (withReroute) {
            this.reroute(allocation);
        }
        return new RoutingAllocation.Result(true, new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData()));
    }

    public RoutingAllocation.Result applyFailedShard(ClusterState clusterState, ShardRouting failedShard) {
        return this.applyFailedShards(clusterState, ImmutableList.of(failedShard));
    }

    public RoutingAllocation.Result applyFailedShards(ClusterState clusterState, List<ShardRouting> failedShards) {
        RoutingNodes routingNodes = clusterState.routingNodes();
        routingNodes.unassigned().shuffle();
        FailedRerouteAllocation allocation = new FailedRerouteAllocation(this.allocationDeciders, routingNodes, clusterState.nodes(), failedShards, this.clusterInfoService.getClusterInfo());
        boolean changed = false;
        for (ShardRouting failedShard : failedShards) {
            changed |= this.applyFailedShard(allocation, failedShard, true);
        }
        if (!changed) {
            return new RoutingAllocation.Result(false, clusterState.routingTable());
        }
        this.shardsAllocators.applyFailedShards(allocation);
        this.reroute(allocation);
        return new RoutingAllocation.Result(true, new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData()));
    }

    public RoutingAllocation.Result reroute(ClusterState clusterState, AllocationCommands commands) {
        return this.reroute(clusterState, commands, false);
    }

    public RoutingAllocation.Result reroute(ClusterState clusterState, AllocationCommands commands, boolean explain) throws ElasticsearchException {
        RoutingNodes routingNodes = clusterState.routingNodes();
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, clusterState.nodes(), this.clusterInfoService.getClusterInfo());
        allocation.debugDecision(true);
        allocation.ignoreDisable(true);
        RoutingExplanations explanations = commands.execute(allocation, explain);
        allocation.ignoreDisable(false);
        this.reroute(allocation);
        return new RoutingAllocation.Result(true, new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData()), explanations);
    }

    public RoutingAllocation.Result reroute(ClusterState clusterState) {
        return this.reroute(clusterState, false);
    }

    public RoutingAllocation.Result reroute(ClusterState clusterState, boolean debug) {
        RoutingNodes routingNodes = clusterState.routingNodes();
        routingNodes.unassigned().shuffle();
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, clusterState.nodes(), this.clusterInfoService.getClusterInfo());
        allocation.debugDecision(debug);
        if (!this.reroute(allocation)) {
            return new RoutingAllocation.Result(false, clusterState.routingTable());
        }
        return new RoutingAllocation.Result(true, new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData()));
    }

    public RoutingAllocation.Result rerouteWithNoReassign(ClusterState clusterState) {
        return this.rerouteWithNoReassign(clusterState, false);
    }

    public RoutingAllocation.Result rerouteWithNoReassign(ClusterState clusterState, boolean debug) {
        RoutingNodes routingNodes = clusterState.routingNodes();
        routingNodes.unassigned().shuffle();
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, clusterState.nodes(), this.clusterInfoService.getClusterInfo());
        allocation.debugDecision(debug);
        boolean changed = false;
        changed |= this.deassociateDeadNodes(allocation);
        this.applyNewNodes(allocation);
        if (!(changed |= this.electPrimariesAndUnassignedDanglingReplicas(allocation))) {
            return new RoutingAllocation.Result(false, clusterState.routingTable());
        }
        return new RoutingAllocation.Result(true, new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData()));
    }

    private boolean reroute(RoutingAllocation allocation) {
        boolean changed = false;
        changed |= this.deassociateDeadNodes(allocation);
        this.applyNewNodes(allocation);
        changed |= this.electPrimariesAndUnassignedDanglingReplicas(allocation);
        if (allocation.routingNodes().hasUnassigned()) {
            changed |= this.shardsAllocators.allocateUnassigned(allocation);
            changed |= this.electPrimariesAndUnassignedDanglingReplicas(allocation);
        }
        changed |= this.moveShards(allocation);
        changed |= this.shardsAllocators.rebalance(allocation);
        assert (RoutingNodes.assertShardStats(allocation.routingNodes()));
        return changed;
    }

    private boolean moveShards(RoutingAllocation allocation) {
        boolean changed = false;
        ArrayList<MutableShardRouting> shards = new ArrayList<MutableShardRouting>();
        int index = 0;
        boolean found = true;
        RoutingNodes routingNodes = allocation.routingNodes();
        while (found) {
            found = false;
            for (RoutingNode routingNode : routingNodes) {
                if (index >= routingNode.size()) continue;
                found = true;
                shards.add(routingNode.get(index));
            }
            ++index;
        }
        for (int i = 0; i < shards.size(); ++i) {
            MutableShardRouting shardRouting = (MutableShardRouting)shards.get(i);
            if (!shardRouting.started()) continue;
            RoutingNode routingNode = routingNodes.node(shardRouting.currentNodeId());
            Decision decision = allocation.deciders().canRemain(shardRouting, routingNode, allocation);
            if (decision.type() != Decision.Type.NO) continue;
            this.logger.debug("[{}][{}] allocated on [{}], but can no longer be allocated on it, moving...", shardRouting.index(), shardRouting.id(), routingNode.node());
            boolean moved = this.shardsAllocators.move(shardRouting, routingNode, allocation);
            if (!moved) {
                this.logger.debug("[{}][{}] can't move", shardRouting.index(), shardRouting.id());
                continue;
            }
            changed = true;
        }
        return changed;
    }

    private boolean electPrimariesAndUnassignedDanglingReplicas(RoutingAllocation allocation) {
        boolean changed = false;
        RoutingNodes routingNodes = allocation.routingNodes();
        if (!routingNodes.hasUnassignedPrimaries()) {
            return changed;
        }
        ArrayList<MutableShardRouting> shardsToFail = Lists.newArrayList();
        for (MutableShardRouting mutableShardRouting : routingNodes.unassigned()) {
            if (!mutableShardRouting.primary()) continue;
            for (MutableShardRouting routing : routingNodes.assignedShards(mutableShardRouting)) {
                if (routing.primary() || !routing.initializing()) continue;
                shardsToFail.add(routing);
            }
        }
        for (ShardRouting shardRouting : shardsToFail) {
            changed |= this.applyFailedShard(allocation, shardRouting, false);
        }
        block3: for (MutableShardRouting mutableShardRouting : routingNodes.unassigned()) {
            MutableShardRouting candidate;
            if (!mutableShardRouting.primary() || (candidate = allocation.routingNodes().activeReplica(mutableShardRouting)) == null) continue;
            routingNodes.swapPrimaryFlag(mutableShardRouting, candidate);
            if (candidate.relocatingNodeId() == null) continue;
            changed = true;
            RoutingNode node = routingNodes.node(candidate.relocatingNodeId());
            if (node == null) continue;
            for (MutableShardRouting shardRouting : node) {
                if (!shardRouting.shardId().equals(candidate.shardId()) || shardRouting.primary()) continue;
                routingNodes.swapPrimaryFlag(shardRouting);
                continue block3;
            }
        }
        return changed;
    }

    private void applyNewNodes(RoutingAllocation allocation) {
        RoutingNodes routingNodes = allocation.routingNodes();
        for (ObjectCursor<DiscoveryNode> objectCursor : allocation.nodes().dataNodes().values()) {
            DiscoveryNode node = (DiscoveryNode)objectCursor.value;
            if (routingNodes.isKnown(node)) continue;
            routingNodes.addNode(node);
        }
    }

    private boolean deassociateDeadNodes(RoutingAllocation allocation) {
        boolean changed = false;
        RoutingNodes.RoutingNodesIterator it = allocation.routingNodes().nodes();
        while (it.hasNext()) {
            RoutingNode node = it.next();
            if (allocation.nodes().dataNodes().containsKey(node.nodeId())) continue;
            changed = true;
            for (MutableShardRouting shardRouting : node.copyShards()) {
                this.applyFailedShard(allocation, shardRouting, false);
            }
            it.remove();
        }
        return changed;
    }

    private boolean applyStartedShards(RoutingNodes routingNodes, Iterable<? extends ShardRouting> startedShardEntries) {
        boolean dirty = false;
        block0: for (ShardRouting shardRouting : startedShardEntries) {
            RoutingNodes.RoutingNodeIterator sourceRoutingNode;
            assert (shardRouting.state() == ShardRoutingState.INITIALIZING);
            String relocatingNodeId = null;
            RoutingNodes.RoutingNodeIterator currentRoutingNode = routingNodes.routingNodeIter(shardRouting.currentNodeId());
            if (currentRoutingNode != null) {
                for (MutableShardRouting shard : currentRoutingNode) {
                    if (!shard.shardId().equals(shardRouting.shardId())) continue;
                    relocatingNodeId = shard.relocatingNodeId();
                    if (shard.started()) break;
                    dirty = true;
                    routingNodes.started(shard);
                    break;
                }
            }
            if (relocatingNodeId == null || (sourceRoutingNode = routingNodes.routingNodeIter(relocatingNodeId)) == null) continue;
            while (sourceRoutingNode.hasNext()) {
                MutableShardRouting shard;
                shard = sourceRoutingNode.next();
                if (!shard.shardId().equals(shardRouting.shardId()) || !shard.relocating()) continue;
                dirty = true;
                sourceRoutingNode.remove();
                continue block0;
            }
        }
        return dirty;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean applyFailedShard(RoutingAllocation allocation, ShardRouting failedShard, boolean addToIgnoreList) {
        failedShard = new ImmutableShardRouting(failedShard);
        IndexRoutingTable indexRoutingTable = allocation.routingTable().index(failedShard.index());
        if (indexRoutingTable == null) {
            return false;
        }
        RoutingNodes routingNodes = allocation.routingNodes();
        boolean dirty = false;
        if (failedShard.relocatingNodeId() != null) {
            if (failedShard.state() == ShardRoutingState.INITIALIZING) {
                RoutingNodes.RoutingNodeIterator initializingNode = routingNodes.routingNodeIter(failedShard.currentNodeId());
                if (initializingNode != null) {
                    while (initializingNode.hasNext()) {
                        MutableShardRouting shardRouting = initializingNode.next();
                        if (!shardRouting.equals(failedShard)) continue;
                        dirty = true;
                        initializingNode.remove();
                        if (!addToIgnoreList) break;
                        allocation.addIgnoreShardForNode(failedShard.shardId(), failedShard.currentNodeId());
                        break;
                    }
                }
                if (dirty) {
                    RoutingNode relocatingFromNode = routingNodes.node(failedShard.relocatingNodeId());
                    if (relocatingFromNode == null) return dirty;
                    for (MutableShardRouting shardRouting : relocatingFromNode) {
                        if (!shardRouting.shardId().equals(failedShard.shardId()) || !shardRouting.relocating()) continue;
                        dirty = true;
                        routingNodes.cancelRelocation(shardRouting);
                        return dirty;
                    }
                    return dirty;
                }
                this.logger.debug("failed shard {} not found in routingNodes, ignoring it", failedShard);
                return dirty;
            }
            if (failedShard.state() != ShardRoutingState.RELOCATING) throw new ElasticsearchIllegalStateException("illegal state for a failed shard, relocating node id is set, but state does not match: " + failedShard);
            RoutingNodes.RoutingNodeIterator relocatingFromNode = routingNodes.routingNodeIter(failedShard.currentNodeId());
            if (relocatingFromNode != null) {
                while (relocatingFromNode.hasNext()) {
                    MutableShardRouting shardRouting = relocatingFromNode.next();
                    if (!shardRouting.equals(failedShard)) continue;
                    dirty = true;
                    relocatingFromNode.remove();
                    if (addToIgnoreList) {
                        allocation.addIgnoreShardForNode(failedShard.shardId(), failedShard.currentNodeId());
                    }
                    routingNodes.unassigned().add(new MutableShardRouting(failedShard.index(), failedShard.id(), null, failedShard.primary(), ShardRoutingState.UNASSIGNED, failedShard.version() + 1L));
                    break;
                }
            }
            if (dirty) {
                RoutingNodes.RoutingNodeIterator initializingNode = routingNodes.routingNodeIter(failedShard.relocatingNodeId());
                if (initializingNode == null) return dirty;
                while (initializingNode.hasNext()) {
                    MutableShardRouting shardRouting = initializingNode.next();
                    if (!shardRouting.shardId().equals(failedShard.shardId()) || shardRouting.state() != ShardRoutingState.INITIALIZING) continue;
                    dirty = true;
                    initializingNode.remove();
                }
                return dirty;
            } else {
                this.logger.debug("failed shard {} not found in routingNodes, ignoring it", failedShard);
            }
            return dirty;
        }
        RoutingNodes.RoutingNodeIterator node = routingNodes.routingNodeIter(failedShard.currentNodeId());
        if (node != null) {
            while (node.hasNext()) {
                MutableShardRouting shardRouting = node.next();
                if (!shardRouting.equals(failedShard)) continue;
                dirty = true;
                if (addToIgnoreList) {
                    allocation.addIgnoreShardForNode(failedShard.shardId(), failedShard.currentNodeId());
                }
                node.remove();
                ArrayList<MutableShardRouting> shardsToMove = Lists.newArrayList();
                Iterator<MutableShardRouting> unassignedIt = routingNodes.unassigned().iterator();
                while (unassignedIt.hasNext()) {
                    MutableShardRouting unassignedShardRouting = unassignedIt.next();
                    if (!unassignedShardRouting.shardId().equals(failedShard.shardId())) continue;
                    unassignedIt.remove();
                    shardsToMove.add(unassignedShardRouting);
                }
                if (!shardsToMove.isEmpty()) {
                    routingNodes.unassigned().addAll(shardsToMove);
                }
                routingNodes.unassigned().add(new MutableShardRouting(failedShard.index(), failedShard.id(), null, null, failedShard.restoreSource(), failedShard.primary(), ShardRoutingState.UNASSIGNED, failedShard.version() + 1L));
                break;
            }
        }
        if (dirty) return dirty;
        this.logger.debug("failed shard {} not found in routingNodes, ignoring it", failedShard);
        return dirty;
    }
}

