/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.action.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.MetaDataMappingService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class MappingUpdatedAction
extends TransportMasterNodeOperationAction<MappingUpdatedRequest, MappingUpdatedResponse> {
    public static final String INDICES_MAPPING_ADDITIONAL_MAPPING_CHANGE_TIME = "indices.mapping.additional_mapping_change_time";
    public static final String ACTION_NAME = "internal:cluster/mapping_updated";
    private final AtomicLong mappingUpdateOrderGen = new AtomicLong();
    private final MetaDataMappingService metaDataMappingService;
    private volatile MasterMappingUpdater masterMappingUpdater;
    private volatile TimeValue additionalMappingChangeTime;

    @Inject
    public MappingUpdatedAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataMappingService metaDataMappingService, NodeSettingsService nodeSettingsService, ActionFilters actionFilters) {
        super(settings, ACTION_NAME, transportService, clusterService, threadPool, actionFilters);
        this.metaDataMappingService = metaDataMappingService;
        this.additionalMappingChangeTime = settings.getAsTime(INDICES_MAPPING_ADDITIONAL_MAPPING_CHANGE_TIME, TimeValue.timeValueMillis(0L));
        nodeSettingsService.addListener(new ApplySettings());
    }

    public void start() {
        this.masterMappingUpdater = new MasterMappingUpdater(EsExecutors.threadName(this.settings, "master_mapping_updater"));
        this.masterMappingUpdater.start();
    }

    public void stop() {
        this.masterMappingUpdater.close();
        this.masterMappingUpdater = null;
    }

    public void updateMappingOnMaster(String index, DocumentMapper documentMapper, String indexUUID) {
        this.updateMappingOnMaster(index, documentMapper, indexUUID, null);
    }

    public void updateMappingOnMaster(String index, DocumentMapper documentMapper, String indexUUID, MappingUpdateListener listener) {
        assert (!documentMapper.type().equals("_default_")) : "_default_ mapping should not be updated";
        this.masterMappingUpdater.add(new MappingChange(documentMapper, index, indexUUID, listener));
    }

    @Override
    protected ClusterBlockException checkBlock(MappingUpdatedRequest request, ClusterState state) {
        return null;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected MappingUpdatedRequest newRequest() {
        return new MappingUpdatedRequest();
    }

    @Override
    protected MappingUpdatedResponse newResponse() {
        return new MappingUpdatedResponse();
    }

    @Override
    protected void masterOperation(final MappingUpdatedRequest request, ClusterState state, final ActionListener<MappingUpdatedResponse> listener) throws ElasticsearchException {
        this.metaDataMappingService.updateMapping(request.index(), request.indexUUID(), request.type(), request.mappingSource(), request.order, request.nodeId, new ActionListener<ClusterStateUpdateResponse>(){

            @Override
            public void onResponse(ClusterStateUpdateResponse response) {
                listener.onResponse(new MappingUpdatedResponse());
            }

            @Override
            public void onFailure(Throwable t) {
                MappingUpdatedAction.this.logger.warn("[{}] update-mapping [{}] failed to dynamically update the mapping in cluster_state from shard", t, request.index(), request.type());
                listener.onFailure(t);
            }
        });
    }

    private class MasterMappingUpdater
    extends Thread {
        private volatile boolean running;
        private final BlockingQueue<MappingChange> queue;

        public MasterMappingUpdater(String name) {
            super(name);
            this.running = true;
            this.queue = ConcurrentCollections.newBlockingQueue();
        }

        public void add(MappingChange change) {
            this.queue.add(change);
        }

        public void close() {
            this.running = false;
            this.interrupt();
        }

        @Override
        public void run() {
            HashMap<UpdateKey, UpdateValue> pendingUpdates = Maps.newHashMap();
            while (this.running) {
                try {
                    MappingChange polledChange = this.queue.poll(10L, TimeUnit.MINUTES);
                    if (polledChange == null) continue;
                    ArrayList<MappingChange> changes = Lists.newArrayList(polledChange);
                    if (MappingUpdatedAction.this.additionalMappingChangeTime.millis() > 0L) {
                        Thread.sleep(MappingUpdatedAction.this.additionalMappingChangeTime.millis());
                    }
                    this.queue.drainTo(changes);
                    Collections.reverse(changes);
                    for (MappingChange change : changes) {
                        UpdateKey key = new UpdateKey(change.indexUUID, change.documentMapper.type());
                        UpdateValue updateValue = (UpdateValue)pendingUpdates.get(key);
                        if (updateValue == null) {
                            updateValue = new UpdateValue(change);
                            pendingUpdates.put(key, updateValue);
                        }
                        if (change.listener == null) continue;
                        updateValue.listeners.add(change.listener);
                    }
                    Iterator iterator = pendingUpdates.values().iterator();
                    while (iterator.hasNext()) {
                        MappingUpdatedRequest mappingRequest;
                        final UpdateValue updateValue = (UpdateValue)iterator.next();
                        iterator.remove();
                        MappingChange change = updateValue.mainChange;
                        try {
                            long orderId = MappingUpdatedAction.this.mappingUpdateOrderGen.incrementAndGet();
                            change.documentMapper.refreshSource();
                            DiscoveryNode node = MappingUpdatedAction.this.clusterService.localNode();
                            mappingRequest = new MappingUpdatedRequest(change.index, change.indexUUID, change.documentMapper.type(), change.documentMapper.mappingSource(), orderId, node != null ? node.id() : null);
                        }
                        catch (Throwable t) {
                            MappingUpdatedAction.this.logger.warn("Failed to update master on updated mapping for index [" + change.index + "], type [" + change.documentMapper.type() + "]", t, new Object[0]);
                            updateValue.notifyListeners(t);
                            continue;
                        }
                        MappingUpdatedAction.this.logger.trace("sending mapping updated to master: {}", mappingRequest);
                        MappingUpdatedAction.this.execute(mappingRequest, new ActionListener<MappingUpdatedResponse>(){

                            @Override
                            public void onResponse(MappingUpdatedResponse mappingUpdatedResponse) {
                                MappingUpdatedAction.this.logger.debug("successfully updated master with mapping update: {}", mappingRequest);
                                updateValue.notifyListeners(null);
                            }

                            @Override
                            public void onFailure(Throwable e) {
                                MappingUpdatedAction.this.logger.warn("failed to update master on updated mapping for {}", e, mappingRequest);
                                updateValue.notifyListeners(e);
                            }
                        });
                    }
                }
                catch (Throwable t) {
                    if (!(t instanceof InterruptedException) || this.running) {
                        MappingUpdatedAction.this.logger.warn("failed to process mapping updates", t, new Object[0]);
                    }
                    Iterator iterator = pendingUpdates.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        iterator.remove();
                        ((UpdateValue)entry.getValue()).notifyListeners(t);
                    }
                }
            }
        }

        class UpdateValue {
            public final MappingChange mainChange;
            public final List<MappingUpdateListener> listeners = Lists.newArrayList();

            UpdateValue(MappingChange mainChange) {
                this.mainChange = mainChange;
            }

            public void notifyListeners(@Nullable Throwable t) {
                for (MappingUpdateListener listener : this.listeners) {
                    try {
                        if (t == null) {
                            listener.onMappingUpdate();
                            continue;
                        }
                        listener.onFailure(t);
                    }
                    catch (Throwable lisFailure) {
                        MappingUpdatedAction.this.logger.warn("unexpected failure on mapping update listener callback [{}]", lisFailure, listener);
                    }
                }
            }
        }

        class UpdateKey {
            public final String indexUUID;
            public final String type;

            UpdateKey(String indexUUID, String type) {
                this.indexUUID = indexUUID;
                this.type = type;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                UpdateKey updateKey = (UpdateKey)o;
                if (!this.indexUUID.equals(updateKey.indexUUID)) {
                    return false;
                }
                return this.type.equals(updateKey.type);
            }

            public int hashCode() {
                int result = this.indexUUID.hashCode();
                result = 31 * result + this.type.hashCode();
                return result;
            }
        }
    }

    public static interface MappingUpdateListener {
        public void onMappingUpdate();

        public void onFailure(Throwable var1);
    }

    private static class MappingChange {
        public final DocumentMapper documentMapper;
        public final String index;
        public final String indexUUID;
        public final MappingUpdateListener listener;

        MappingChange(DocumentMapper documentMapper, String index, String indexUUID, MappingUpdateListener listener) {
            this.documentMapper = documentMapper;
            this.index = index;
            this.indexUUID = indexUUID;
            this.listener = listener;
        }
    }

    public static class MappingUpdatedRequest
    extends MasterNodeOperationRequest<MappingUpdatedRequest>
    implements IndicesRequest {
        private String index;
        private String indexUUID = "_na_";
        private String type;
        private CompressedString mappingSource;
        private long order = -1L;
        private String nodeId = null;

        MappingUpdatedRequest() {
        }

        public MappingUpdatedRequest(String index, String indexUUID, String type, CompressedString mappingSource, long order, String nodeId) {
            this.index = index;
            this.indexUUID = indexUUID;
            this.type = type;
            this.mappingSource = mappingSource;
            this.order = order;
            this.nodeId = nodeId;
        }

        public String index() {
            return this.index;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        }

        @Override
        public String[] indices() {
            return new String[]{this.index};
        }

        public String indexUUID() {
            return this.indexUUID;
        }

        public String type() {
            return this.type;
        }

        public CompressedString mappingSource() {
            return this.mappingSource;
        }

        public long order() {
            return this.order;
        }

        public String nodeId() {
            return this.nodeId;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.index = in.readString();
            this.type = in.readString();
            this.mappingSource = CompressedString.readCompressedString(in);
            this.indexUUID = in.readString();
            this.order = in.readLong();
            this.nodeId = in.readOptionalString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
            out.writeString(this.type);
            this.mappingSource.writeTo(out);
            out.writeString(this.indexUUID);
            out.writeLong(this.order);
            out.writeOptionalString(this.nodeId);
        }

        public String toString() {
            return "index [" + this.index + "], indexUUID [" + this.indexUUID + "], type [" + this.type + "] and source [" + this.mappingSource + "]";
        }
    }

    public static class MappingUpdatedResponse
    extends ActionResponse {
        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
        }
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            TimeValue newValue;
            TimeValue current = MappingUpdatedAction.this.additionalMappingChangeTime;
            if (!current.equals(newValue = settings.getAsTime(MappingUpdatedAction.INDICES_MAPPING_ADDITIONAL_MAPPING_CHANGE_TIME, current))) {
                MappingUpdatedAction.this.logger.info("updating indices.mapping.additional_mapping_change_time from [{}] to [{}]", current, newValue);
                MappingUpdatedAction.this.additionalMappingChangeTime = newValue;
            }
        }
    }
}

