/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.single.instance;

import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.single.instance.InstanceShardOperationRequest;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportInstanceSingleOperationAction<Request extends InstanceShardOperationRequest, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    final String executor;

    protected TransportInstanceSingleOperationAction(Settings settings, String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super(settings, actionName, threadPool, actionFilters);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.executor = this.executor();
        transportService.registerHandler(actionName, new TransportHandler());
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        new AsyncSingleAction(this, (InstanceShardOperationRequest)request, listener).start();
    }

    protected abstract String executor();

    protected abstract void shardOperation(InternalRequest var1, ActionListener<Response> var2) throws ElasticsearchException;

    protected abstract Request newRequest();

    protected abstract Response newResponse();

    protected ClusterBlockException checkGlobalBlock(ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, InternalRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, request.concreteIndex());
    }

    protected abstract boolean resolveRequest(ClusterState var1, InternalRequest var2, ActionListener<Response> var3);

    protected boolean retryOnFailure(Throwable e) {
        return false;
    }

    protected TransportRequestOptions transportOptions() {
        return TransportRequestOptions.EMPTY;
    }

    protected abstract ShardIterator shards(ClusterState var1, InternalRequest var2) throws ElasticsearchException;

    protected static class InternalRequest {
        final Request request;
        String concreteIndex;
        final /* synthetic */ TransportInstanceSingleOperationAction this$0;

        InternalRequest(Request request) {
            this.this$0 = var1_1;
            this.request = request;
        }

        public Request request() {
            return this.request;
        }

        void concreteIndex(String concreteIndex) {
            this.concreteIndex = concreteIndex;
        }

        public String concreteIndex() {
            return this.concreteIndex;
        }
    }

    class TransportHandler
    extends BaseTransportRequestHandler<Request> {
        TransportHandler() {
        }

        @Override
        public Request newInstance() {
            return TransportInstanceSingleOperationAction.this.newRequest();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            ((ActionRequest)request).listenerThreaded(false);
            TransportInstanceSingleOperationAction.this.execute(request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response result) {
                    try {
                        channel.sendResponse((TransportResponse)result);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportInstanceSingleOperationAction.this.logger.warn("Failed to send response for get", e1, new Object[0]);
                    }
                }
            });
        }
    }

    static class AsyncSingleAction {
        private final ActionListener<Response> listener;
        private final InternalRequest internalRequest;
        private volatile ClusterStateObserver observer;
        private ShardIterator shardIt;
        private DiscoveryNodes nodes;
        private final AtomicBoolean operationStarted = new AtomicBoolean();
        final /* synthetic */ TransportInstanceSingleOperationAction this$0;

        private AsyncSingleAction(Request request, ActionListener<Response> listener) {
            this.this$0 = var1_1;
            this.internalRequest = new InternalRequest((TransportInstanceSingleOperationAction)var1_1, request);
            this.listener = listener;
        }

        public void start() {
            this.observer = new ClusterStateObserver(this.this$0.clusterService, ((InstanceShardOperationRequest)this.internalRequest.request()).timeout(), this.this$0.logger);
            this.doStart();
        }

        protected boolean doStart() throws ElasticsearchException {
            block17: {
                this.nodes = this.observer.observedState().nodes();
                try {
                    ClusterBlockException blockException = this.this$0.checkGlobalBlock(this.observer.observedState());
                    if (blockException != null) {
                        if (blockException.retryable()) {
                            this.retry(blockException);
                            return false;
                        }
                        throw blockException;
                    }
                    this.internalRequest.concreteIndex(this.observer.observedState().metaData().concreteSingleIndex(((InstanceShardOperationRequest)this.internalRequest.request()).index(), ((InstanceShardOperationRequest)this.internalRequest.request()).indicesOptions()));
                    if (!this.this$0.resolveRequest(this.observer.observedState(), this.internalRequest, this.listener)) {
                        return true;
                    }
                    blockException = this.this$0.checkRequestBlock(this.observer.observedState(), this.internalRequest);
                    if (blockException != null) {
                        if (blockException.retryable()) {
                            this.retry(blockException);
                            return false;
                        }
                        throw blockException;
                    }
                    this.shardIt = this.this$0.shards(this.observer.observedState(), this.internalRequest);
                }
                catch (Throwable e) {
                    this.listener.onFailure(e);
                    return true;
                }
                if (this.shardIt.size() == 0) {
                    this.retry(null);
                    return false;
                }
                assert (this.shardIt.size() == 1);
                ShardRouting shard = this.shardIt.nextOrNull();
                assert (shard != null);
                if (!shard.active()) {
                    this.retry(null);
                    return false;
                }
                if (!this.operationStarted.compareAndSet(false, true)) {
                    return true;
                }
                ((InstanceShardOperationRequest)this.internalRequest.request()).shardId = this.shardIt.shardId().id();
                if (shard.currentNodeId().equals(this.nodes.localNodeId())) {
                    ((InstanceShardOperationRequest)this.internalRequest.request()).beforeLocalFork();
                    try {
                        this.this$0.threadPool.executor(this.this$0.executor).execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    AsyncSingleAction.this.this$0.shardOperation(AsyncSingleAction.this.internalRequest, AsyncSingleAction.this.listener);
                                }
                                catch (Throwable e) {
                                    if (AsyncSingleAction.this.this$0.retryOnFailure(e)) {
                                        AsyncSingleAction.this.operationStarted.set(false);
                                        AsyncSingleAction.this.retry(null);
                                    }
                                    AsyncSingleAction.this.listener.onFailure(e);
                                }
                            }
                        });
                    }
                    catch (Throwable e) {
                        if (this.this$0.retryOnFailure(e)) {
                            this.retry(null);
                            break block17;
                        }
                        this.listener.onFailure(e);
                    }
                } else {
                    DiscoveryNode node = this.nodes.get(shard.currentNodeId());
                    this.this$0.transportService.sendRequest(node, this.this$0.actionName, (TransportRequest)this.internalRequest.request(), this.this$0.transportOptions(), new BaseTransportResponseHandler<Response>(){

                        @Override
                        public Response newInstance() {
                            return AsyncSingleAction.this.this$0.newResponse();
                        }

                        @Override
                        public String executor() {
                            return "same";
                        }

                        @Override
                        public void handleResponse(Response response) {
                            AsyncSingleAction.this.listener.onResponse(response);
                        }

                        @Override
                        public void handleException(TransportException exp) {
                            if (exp.unwrapCause() instanceof ConnectTransportException || exp.unwrapCause() instanceof NodeClosedException || AsyncSingleAction.this.this$0.retryOnFailure(exp)) {
                                AsyncSingleAction.this.operationStarted.set(false);
                                AsyncSingleAction.this.retry(null);
                            } else {
                                AsyncSingleAction.this.listener.onFailure(exp);
                            }
                        }
                    });
                }
            }
            return true;
        }

        void retry(final @Nullable Throwable failure) {
            if (this.observer.isTimedOut()) {
                return;
            }
            ((InstanceShardOperationRequest)this.internalRequest.request()).beforeLocalFork();
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    AsyncSingleAction.this.doStart();
                }

                @Override
                public void onClusterServiceClose() {
                    AsyncSingleAction.this.listener.onFailure(new NodeClosedException(AsyncSingleAction.this.nodes.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    if (!AsyncSingleAction.this.doStart()) {
                        Throwable listenFailure = failure;
                        if (listenFailure == null) {
                            listenFailure = AsyncSingleAction.this.shardIt == null ? new UnavailableShardsException(new ShardId(AsyncSingleAction.this.internalRequest.concreteIndex(), -1), "Timeout waiting for [" + timeout + "], request: " + AsyncSingleAction.this.internalRequest.request().toString()) : new UnavailableShardsException(AsyncSingleAction.this.shardIt.shardId(), "[" + AsyncSingleAction.this.shardIt.size() + "] shardIt, [" + AsyncSingleAction.this.shardIt.sizeActive() + "] active : Timeout waiting for [" + timeout + "], request: " + AsyncSingleAction.this.internalRequest.request().toString());
                        }
                        AsyncSingleAction.this.listener.onFailure(listenFailure);
                    }
                }
            }, ((InstanceShardOperationRequest)this.internalRequest.request()).timeout());
        }
    }
}

