/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.action.search.type.TransportSearchTypeAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.hppc.IntArrayList;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.ShardFetchSearchRequest;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.threadpool.ThreadPool;

public class TransportSearchQueryThenFetchAction
extends TransportSearchTypeAction {
    @Inject
    public TransportSearchQueryThenFetchAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController, ActionFilters actionFilters) {
        super(settings, threadPool, clusterService, searchService, searchPhaseController, actionFilters);
    }

    @Override
    protected void doExecute(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        new AsyncAction(searchRequest, listener).start();
    }

    private class AsyncAction
    extends TransportSearchTypeAction.BaseAsyncAction<QuerySearchResultProvider> {
        final AtomicArray<FetchSearchResult> fetchResults;
        final AtomicArray<IntArrayList> docIdsToLoad;

        private AsyncAction(SearchRequest request, ActionListener<SearchResponse> listener) {
            super(request, listener);
            this.fetchResults = new AtomicArray(this.firstResults.length());
            this.docIdsToLoad = new AtomicArray(this.firstResults.length());
        }

        @Override
        protected String firstPhaseName() {
            return "query";
        }

        @Override
        protected void sendExecuteFirstPhase(DiscoveryNode node, ShardSearchTransportRequest request, SearchServiceListener<QuerySearchResultProvider> listener) {
            TransportSearchQueryThenFetchAction.this.searchService.sendExecuteQuery(node, request, listener);
        }

        @Override
        protected void moveToSecondPhase() throws Exception {
            boolean useScroll = !this.useSlowScroll && this.request.scroll() != null;
            this.sortedShardList = TransportSearchQueryThenFetchAction.this.searchPhaseController.sortDocs(useScroll, this.firstResults);
            TransportSearchQueryThenFetchAction.this.searchPhaseController.fillDocIdsToLoad(this.docIdsToLoad, this.sortedShardList);
            if (this.docIdsToLoad.asList().isEmpty()) {
                this.finishHim();
                return;
            }
            ScoreDoc[] lastEmittedDocPerShard = TransportSearchQueryThenFetchAction.this.searchPhaseController.getLastEmittedDocPerShard(this.request, this.sortedShardList, this.firstResults.length());
            AtomicInteger counter = new AtomicInteger(this.docIdsToLoad.asList().size());
            for (AtomicArray.Entry<IntArrayList> entry : this.docIdsToLoad.asList()) {
                QuerySearchResultProvider queryResult = (QuerySearchResultProvider)this.firstResults.get(entry.index);
                DiscoveryNode node = this.nodes.get(queryResult.shardTarget().nodeId());
                ShardFetchSearchRequest fetchSearchRequest = this.createFetchRequest(queryResult.queryResult(), entry, lastEmittedDocPerShard);
                this.executeFetch(entry.index, queryResult.shardTarget(), counter, fetchSearchRequest, node);
            }
        }

        void executeFetch(final int shardIndex, final SearchShardTarget shardTarget, final AtomicInteger counter, final ShardFetchSearchRequest fetchSearchRequest, DiscoveryNode node) {
            TransportSearchQueryThenFetchAction.this.searchService.sendExecuteFetch(node, fetchSearchRequest, new SearchServiceListener<FetchSearchResult>(){

                @Override
                public void onResult(FetchSearchResult result) {
                    result.shardTarget(shardTarget);
                    AsyncAction.this.fetchResults.set(shardIndex, result);
                    if (counter.decrementAndGet() == 0) {
                        AsyncAction.this.finishHim();
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    AsyncAction.this.docIdsToLoad.set(shardIndex, null);
                    AsyncAction.this.onFetchFailure(t, fetchSearchRequest, shardIndex, shardTarget, counter);
                }
            });
        }

        void onFetchFailure(Throwable t, ShardFetchSearchRequest fetchSearchRequest, int shardIndex, SearchShardTarget shardTarget, AtomicInteger counter) {
            if (TransportSearchQueryThenFetchAction.this.logger.isDebugEnabled()) {
                TransportSearchQueryThenFetchAction.this.logger.debug("[{}] Failed to execute fetch phase", t, fetchSearchRequest.id());
            }
            this.addShardFailure(shardIndex, shardTarget, t);
            this.successfulOps.decrementAndGet();
            if (counter.decrementAndGet() == 0) {
                this.finishHim();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finishHim() {
            try {
                TransportSearchQueryThenFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            InternalSearchResponse internalResponse = TransportSearchQueryThenFetchAction.this.searchPhaseController.merge(AsyncAction.this.sortedShardList, AsyncAction.this.firstResults, AsyncAction.this.fetchResults);
                            String scrollId = null;
                            if (AsyncAction.this.request.scroll() != null) {
                                scrollId = TransportSearchHelper.buildScrollId(AsyncAction.this.request.searchType(), (AtomicArray<? extends SearchPhaseResult>)AsyncAction.this.firstResults, null);
                            }
                            AsyncAction.this.listener.onResponse(new SearchResponse(internalResponse, scrollId, AsyncAction.this.expectedSuccessfulOps, AsyncAction.this.successfulOps.get(), AsyncAction.this.buildTookInMillis(), AsyncAction.this.buildShardFailures()));
                        }
                        catch (Throwable e) {
                            ReduceSearchPhaseException failure = new ReduceSearchPhaseException("fetch", "", e, AsyncAction.this.buildShardFailures());
                            if (TransportSearchQueryThenFetchAction.this.logger.isDebugEnabled()) {
                                TransportSearchQueryThenFetchAction.this.logger.debug("failed to reduce search", failure, new Object[0]);
                            }
                            AsyncAction.this.listener.onFailure(failure);
                        }
                        finally {
                            AsyncAction.this.releaseIrrelevantSearchContexts(AsyncAction.this.firstResults, AsyncAction.this.docIdsToLoad);
                        }
                    }
                });
            }
            catch (EsRejectedExecutionException ex) {
                try {
                    this.releaseIrrelevantSearchContexts(this.firstResults, this.docIdsToLoad);
                }
                finally {
                    this.listener.onFailure(ex);
                }
            }
        }
    }
}

