/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.type.ParsedScrollId;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.action.search.type.TransportSearchScrollQueryAndFetchAction;
import org.elasticsearch.action.search.type.TransportSearchScrollQueryThenFetchAction;
import org.elasticsearch.action.search.type.TransportSearchScrollScanAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSearchScrollAction
extends HandledTransportAction<SearchScrollRequest, SearchResponse> {
    private final TransportSearchScrollQueryThenFetchAction queryThenFetchAction;
    private final TransportSearchScrollQueryAndFetchAction queryAndFetchAction;
    private final TransportSearchScrollScanAction scanAction;

    @Inject
    public TransportSearchScrollAction(Settings settings, ThreadPool threadPool, TransportService transportService, TransportSearchScrollQueryThenFetchAction queryThenFetchAction, TransportSearchScrollQueryAndFetchAction queryAndFetchAction, TransportSearchScrollScanAction scanAction, ActionFilters actionFilters) {
        super(settings, "indices:data/read/scroll", threadPool, transportService, actionFilters);
        this.queryThenFetchAction = queryThenFetchAction;
        this.queryAndFetchAction = queryAndFetchAction;
        this.scanAction = scanAction;
    }

    @Override
    protected void doExecute(SearchScrollRequest request, ActionListener<SearchResponse> listener) {
        block5: {
            try {
                ParsedScrollId scrollId = TransportSearchHelper.parseScrollId(request.scrollId());
                if (scrollId.getType().equals("queryThenFetch")) {
                    this.queryThenFetchAction.execute(request, scrollId, listener);
                    break block5;
                }
                if (scrollId.getType().equals("queryAndFetch")) {
                    this.queryAndFetchAction.execute(request, scrollId, listener);
                    break block5;
                }
                if (scrollId.getType().equals("scan")) {
                    this.scanAction.execute(request, scrollId, listener);
                    break block5;
                }
                throw new ElasticsearchIllegalArgumentException("Scroll id type [" + scrollId.getType() + "] unrecognized");
            }
            catch (Throwable e) {
                listener.onFailure(e);
            }
        }
    }

    @Override
    public SearchScrollRequest newRequestInstance() {
        return new SearchScrollRequest();
    }
}

