/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class BulkItemRequest
implements Streamable {
    private int id;
    private ActionRequest request;
    private volatile BulkItemResponse primaryResponse;
    private volatile boolean ignoreOnReplica;

    BulkItemRequest() {
    }

    public BulkItemRequest(int id, ActionRequest request) {
        assert (request instanceof IndicesRequest);
        this.id = id;
        this.request = request;
    }

    public int id() {
        return this.id;
    }

    public ActionRequest request() {
        return this.request;
    }

    public String index() {
        IndicesRequest indicesRequest = (IndicesRequest)((Object)this.request);
        assert (indicesRequest.indices().length == 1);
        return indicesRequest.indices()[0];
    }

    BulkItemResponse getPrimaryResponse() {
        return this.primaryResponse;
    }

    void setPrimaryResponse(BulkItemResponse primaryResponse) {
        this.primaryResponse = primaryResponse;
    }

    void setIgnoreOnReplica() {
        this.ignoreOnReplica = true;
    }

    boolean isIgnoreOnReplica() {
        return this.ignoreOnReplica;
    }

    public static BulkItemRequest readBulkItem(StreamInput in) throws IOException {
        BulkItemRequest item = new BulkItemRequest();
        item.readFrom(in);
        return item;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.id = in.readVInt();
        byte type = in.readByte();
        if (type == 0) {
            this.request = new IndexRequest();
        } else if (type == 1) {
            this.request = new DeleteRequest();
        } else if (type == 2) {
            this.request = new UpdateRequest();
        }
        this.request.readFrom(in);
        if (in.getVersion().onOrAfter(Version.V_1_3_3)) {
            if (in.readBoolean()) {
                this.primaryResponse = BulkItemResponse.readBulkItem(in);
            }
            this.ignoreOnReplica = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.id);
        if (this.request instanceof IndexRequest) {
            out.writeByte((byte)0);
        } else if (this.request instanceof DeleteRequest) {
            out.writeByte((byte)1);
        } else if (this.request instanceof UpdateRequest) {
            out.writeByte((byte)2);
        }
        this.request.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_1_3_3)) {
            out.writeOptionalStreamable(this.primaryResponse);
            out.writeBoolean(this.ignoreOnReplica);
        }
    }
}

