/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.warmer.put;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class PutWarmerRequest
extends AcknowledgedRequest<PutWarmerRequest>
implements IndicesRequest.Replaceable {
    private String name;
    private SearchRequest searchRequest;

    PutWarmerRequest() {
    }

    public PutWarmerRequest(String name) {
        this.name = name;
    }

    public PutWarmerRequest name(String name) {
        this.name = name;
        return this;
    }

    String name() {
        return this.name;
    }

    public PutWarmerRequest searchRequest(SearchRequest searchRequest) {
        this.searchRequest = searchRequest;
        return this;
    }

    public PutWarmerRequest searchRequest(SearchRequestBuilder searchRequest) {
        this.searchRequest = searchRequest.request();
        return this;
    }

    SearchRequest searchRequest() {
        return this.searchRequest;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        validationException = this.searchRequest == null ? ValidateActions.addValidationError("search request is missing", validationException) : this.searchRequest.validate();
        if (this.name == null) {
            validationException = ValidateActions.addValidationError("name is missing", validationException);
        }
        return validationException;
    }

    @Override
    public String[] indices() {
        if (this.searchRequest == null) {
            throw new IllegalStateException("unable to retrieve indices, search request is null");
        }
        return this.searchRequest.indices();
    }

    @Override
    public IndicesRequest indices(String[] indices) {
        if (this.searchRequest == null) {
            throw new IllegalStateException("unable to set indices, search request is null");
        }
        this.searchRequest.indices(indices);
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        if (this.searchRequest == null) {
            throw new IllegalStateException("unable to retrieve indices options, search request is null");
        }
        return this.searchRequest.indicesOptions();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.name = in.readString();
        if (in.readBoolean()) {
            this.searchRequest = new SearchRequest();
            this.searchRequest.readFrom(in);
        }
        this.readTimeout(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
        if (this.searchRequest == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.searchRequest.writeTo(out);
        }
        this.writeTimeout(out);
    }
}

