/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.indices.recovery.ShardRecoveryResponse;
import org.elasticsearch.action.support.broadcast.BroadcastOperationResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class RecoveryResponse
extends BroadcastOperationResponse
implements ToXContent {
    private boolean detailed = false;
    private Map<String, List<ShardRecoveryResponse>> shardResponses = new HashMap<String, List<ShardRecoveryResponse>>();

    public RecoveryResponse() {
    }

    public RecoveryResponse(int totalShards, int successfulShards, int failedShards, boolean detailed, Map<String, List<ShardRecoveryResponse>> shardResponses, List<ShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shardResponses = shardResponses;
        this.detailed = detailed;
    }

    public boolean hasRecoveries() {
        return this.shardResponses.size() > 0;
    }

    public void addShardRecovery(String index, ShardRecoveryResponse shardRecoveryResponse) {
        List<ShardRecoveryResponse> shardRecoveries = this.shardResponses.get(index);
        if (shardRecoveries == null) {
            shardRecoveries = new ArrayList<ShardRecoveryResponse>();
            this.shardResponses.put(index, shardRecoveries);
        }
        shardRecoveries.add(shardRecoveryResponse);
    }

    public boolean detailed() {
        return this.detailed;
    }

    public void detailed(boolean detailed) {
        this.detailed = detailed;
    }

    public Map<String, List<ShardRecoveryResponse>> shardResponses() {
        return this.shardResponses;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.hasRecoveries()) {
            for (String index : this.shardResponses.keySet()) {
                List<ShardRecoveryResponse> responses = this.shardResponses.get(index);
                if (responses == null || responses.size() == 0) continue;
                builder.startObject(index);
                builder.startArray("shards");
                for (ShardRecoveryResponse recoveryResponse : responses) {
                    builder.startObject();
                    recoveryResponse.detailed(this.detailed);
                    recoveryResponse.toXContent(builder, params);
                    builder.endObject();
                }
                builder.endArray();
                builder.endObject();
            }
        }
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.shardResponses.size());
        for (Map.Entry<String, List<ShardRecoveryResponse>> entry : this.shardResponses.entrySet()) {
            out.writeString(entry.getKey());
            out.writeVInt(entry.getValue().size());
            for (ShardRecoveryResponse recoveryResponse : entry.getValue()) {
                recoveryResponse.writeTo(out);
            }
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            String s = in.readString();
            int listSize = in.readVInt();
            ArrayList<ShardRecoveryResponse> list = new ArrayList<ShardRecoveryResponse>(listSize);
            for (int j = 0; j < listSize; ++j) {
                list.add(ShardRecoveryResponse.readShardRecoveryResponse(in));
            }
            this.shardResponses.put(s, list);
        }
    }
}

