/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.hotthreads;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.cluster.node.hotthreads.NodeHotThreads;
import org.elasticsearch.action.admin.cluster.node.hotthreads.NodesHotThreadsRequest;
import org.elasticsearch.action.admin.cluster.node.hotthreads.NodesHotThreadsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.NodeOperationRequest;
import org.elasticsearch.action.support.nodes.TransportNodesOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.monitor.jvm.HotThreads;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportNodesHotThreadsAction
extends TransportNodesOperationAction<NodesHotThreadsRequest, NodesHotThreadsResponse, NodeRequest, NodeHotThreads> {
    @Inject
    public TransportNodesHotThreadsAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super(settings, "cluster:monitor/nodes/hot_threads", clusterName, threadPool, clusterService, transportService, actionFilters);
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected NodesHotThreadsResponse newResponse(NodesHotThreadsRequest request, AtomicReferenceArray responses) {
        ArrayList<NodeHotThreads> nodes = Lists.newArrayList();
        for (int i = 0; i < responses.length(); ++i) {
            Object resp = responses.get(i);
            if (!(resp instanceof NodeHotThreads)) continue;
            nodes.add((NodeHotThreads)resp);
        }
        return new NodesHotThreadsResponse(this.clusterName, nodes.toArray(new NodeHotThreads[nodes.size()]));
    }

    @Override
    protected NodesHotThreadsRequest newRequest() {
        return new NodesHotThreadsRequest(new String[0]);
    }

    @Override
    protected NodeRequest newNodeRequest() {
        return new NodeRequest();
    }

    @Override
    protected NodeRequest newNodeRequest(String nodeId, NodesHotThreadsRequest request) {
        return new NodeRequest(nodeId, request);
    }

    @Override
    protected NodeHotThreads newNodeResponse() {
        return new NodeHotThreads();
    }

    @Override
    protected NodeHotThreads nodeOperation(NodeRequest request) throws ElasticsearchException {
        HotThreads hotThreads = new HotThreads().busiestThreads(request.request.threads).type(request.request.type).interval(request.request.interval).threadElementsSnapshotCount(request.request.snapshots);
        try {
            return new NodeHotThreads(this.clusterService.localNode(), hotThreads.detect());
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to detect hot threads", e);
        }
    }

    @Override
    protected boolean accumulateExceptions() {
        return false;
    }

    static class NodeRequest
    extends NodeOperationRequest {
        NodesHotThreadsRequest request;

        NodeRequest() {
        }

        NodeRequest(String nodeId, NodesHotThreadsRequest request) {
            super(request, nodeId);
            this.request = request;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.request = new NodesHotThreadsRequest(new String[0]);
            this.request.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

