/*
 * Decompiled with CFR 0.152.
 */
package jbundler;

import java.io.PrintStream;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

public class SimpleRepositoryListener
extends AbstractRepositoryListener {
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private final boolean verbose;
    private LocalRepositoryManager lrm;

    public SimpleRepositoryListener(LocalRepositoryManager lrm) {
        this(false, lrm);
    }

    public SimpleRepositoryListener(boolean verbose, LocalRepositoryManager lrm) {
        this.verbose = verbose;
        this.lrm = lrm;
    }

    public void artifactDescriptorInvalid(RepositoryEvent event) {
        this.err.println("artifact descriptor invalid: " + event.getArtifact() + " : " + event.getException().getMessage());
    }

    public void artifactDescriptorMissing(RepositoryEvent event) {
        this.err.println("artifact descriptor missing: " + event.getArtifact());
    }

    public void artifactInstalled(RepositoryEvent event) {
        if (this.verbose) {
            this.out.println("artifact installed: " + event.getArtifact() + " : " + event.getFile());
        }
    }

    public void artifactResolved(RepositoryEvent event) {
        if (this.verbose) {
            this.out.println("artifact resolved: " + event.getArtifact() + " : " + event.getRepository().getId());
        }
    }

    public void artifactDownloading(RepositoryEvent event) {
        this.out.println("downloading " + this.toUrl(event));
    }

    private String toUrl(RepositoryEvent event) {
        RemoteRepository repository = (RemoteRepository)event.getRepository();
        String path = this.lrm.getPathForRemoteArtifact(event.getArtifact(), repository, null);
        String url = repository.getUrl() + "/" + path;
        if (repository.getProxy() != null) {
            url = url + " via proxy " + repository.getProxy();
        }
        return url;
    }

    public void artifactDownloaded(RepositoryEvent event) {
        this.out.println("downloaded " + this.toUrl(event));
    }

    public void metadataInvalid(RepositoryEvent event) {
        this.err.println("metadata invalid: " + event.getMetadata());
    }

    public void metadataResolved(RepositoryEvent event) {
        if (this.verbose) {
            this.out.println("metadata resolved: " + event.getMetadata() + " : " + event.getRepository().getId());
        }
    }
}

