/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.httpclient.impl;

import java.util.Locale;
import org.apache.maven.wagon.providers.http.httpclient.HttpResponse;
import org.apache.maven.wagon.providers.http.httpclient.HttpResponseFactory;
import org.apache.maven.wagon.providers.http.httpclient.ProtocolVersion;
import org.apache.maven.wagon.providers.http.httpclient.ReasonPhraseCatalog;
import org.apache.maven.wagon.providers.http.httpclient.StatusLine;
import org.apache.maven.wagon.providers.http.httpclient.annotation.Immutable;
import org.apache.maven.wagon.providers.http.httpclient.impl.EnglishReasonPhraseCatalog;
import org.apache.maven.wagon.providers.http.httpclient.message.BasicHttpResponse;
import org.apache.maven.wagon.providers.http.httpclient.message.BasicStatusLine;
import org.apache.maven.wagon.providers.http.httpclient.protocol.HttpContext;

@Immutable
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        if (catalog == null) {
            throw new IllegalArgumentException("Reason phrase catalog must not be null.");
        }
        this.reasonCatalog = catalog;
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        if (ver == null) {
            throw new IllegalArgumentException("HTTP version may not be null");
        }
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        if (statusline == null) {
            throw new IllegalArgumentException("Status line may not be null");
        }
        Locale loc = this.determineLocale(context);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

