/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.ruby;

import java.io.File;
import java.io.FilenameFilter;
import org.codehaus.plexus.component.annotations.Component;
import org.sonatype.maven.polyglot.mapping.Mapping;
import org.sonatype.maven.polyglot.mapping.MappingSupport;

@Component(role=Mapping.class, hint="ruby")
public class RubyMapping
extends MappingSupport {
    public RubyMapping() {
        super("ruby");
        this.setPomNames(new String[]{"pom.rb", "Mavenfile", "Gemfile"});
        this.setAcceptLocationExtensions(new String[]{".rb", "Mavenfile", "Gemfile", ".gemspec"});
        this.setAcceptOptionKeys(new String[]{"ruby:4.0.0"});
        this.setPriority(1.0f);
    }

    public File locatePom(File dir) {
        String[] list;
        File result = super.locatePom(dir);
        if (result == null && (list = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".gemspec");
            }
        })).length == 1) {
            result = new File(dir, list[0]);
        }
        return result;
    }
}

