/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.layouting.namespace.NamespaceDefinition;
import org.jfree.layouting.namespace.Namespaces;
import org.jfree.report.JFreeReportBoot;
import org.libreoffice.report.pentaho.parser.AttributeSpecification;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.DefaultConfiguration;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfficeParserUtil {
    private static final Log LOGGER = LogFactory.getLog(OfficeParserUtil.class);
    private static OfficeParserUtil instance;
    private static final String NAMESPACES_PREFIX = "namespaces.";
    private final DefaultConfiguration props = new DefaultConfiguration();
    private final NamespaceDefinition[] namespaces;

    public static synchronized OfficeParserUtil getInstance() {
        if (instance == null) {
            instance = new OfficeParserUtil();
        }
        return instance;
    }

    private OfficeParserUtil() {
        ResourceManager resourceManager = new ResourceManager();
        resourceManager.registerDefaults();
        try {
            Resource resource = resourceManager.createDirectly((Object)"res://org/libreoffice/report/pentaho/parser/selectors.properties", Properties.class);
            Properties properties = (Properties)resource.getResource();
            this.props.putAll((Map)properties);
        }
        catch (ResourceException resourceException) {
            LOGGER.warn("Unable to load mapping rules. Parsing services may not be available.", resourceException);
        }
        this.namespaces = Namespaces.createFromConfig((Configuration)JFreeReportBoot.getInstance().getGlobalConfig(), (String)"org.jfree.report.namespaces.", (ResourceManager)resourceManager);
    }

    public NamespaceDefinition getNamespaceDeclaration(String string) {
        if (string == null) {
            throw new NullPointerException("URI must not be null");
        }
        for (int i = 0; i < this.namespaces.length; ++i) {
            NamespaceDefinition namespaceDefinition = this.namespaces[i];
            if (!string.equals(namespaceDefinition.getURI())) continue;
            return namespaceDefinition;
        }
        return null;
    }

    public String getGenericFont(String string) {
        return this.props.getProperty("font-family." + string.toLowerCase(), string);
    }

    public String getNamespaceURI(String string) {
        return this.props.getProperty(NAMESPACES_PREFIX + string);
    }

    public String getNamespaceForStyleFamily(String string) {
        return this.props.getProperty("style-family." + string);
    }

    public Map<String, String> getNamespaces() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = this.props.findPropertyKeys(NAMESPACES_PREFIX);
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.props.getConfigProperty(string);
            hashMap.put(string.substring(NAMESPACES_PREFIX.length()), string2);
        }
        return hashMap;
    }

    public String getNamespacePrefix(String string) {
        Iterator iterator = this.props.findPropertyKeys(NAMESPACES_PREFIX);
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = this.props.getConfigProperty(string2);
            if (!string.equals(string3)) continue;
            return string2.substring(NAMESPACES_PREFIX.length());
        }
        return null;
    }

    public AttributeSpecification parseStyleAttrDefinition(String string, String string2, String string3) {
        String string4 = "attr." + string2 + "." + string3 + ".";
        String string5 = string.substring(string4.length());
        int n = string5.indexOf(46);
        if (n == -1) {
            return null;
        }
        String string6 = this.getNamespaceURI(string5.substring(0, n));
        String string7 = string5.substring(n + 1);
        String string8 = this.props.getProperty(string);
        return new AttributeSpecification(string6, string7, string8);
    }

    public Iterator findStylesForElement(String string, String string2) {
        String string3 = "attr." + string + "." + string2 + ".";
        return this.props.findPropertyKeys(string3);
    }

    public boolean isValidStyleElement(String string, String string2) {
        String string3 = this.getNamespacePrefix(string);
        if (string3 == null) {
            return false;
        }
        Iterator iterator = this.findStylesForElement(string3, string2);
        return iterator.hasNext();
    }

    public String getSelectorPattern() {
        return this.props.getConfigProperty("style-selector.pattern");
    }

    public static void main(String[] stringArray) {
        JFreeReportBoot.getInstance().start();
        System.out.print(OfficeParserUtil.getInstance().getNamespaces());
    }
}

