/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.output.chart;

import java.io.IOException;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataFlags;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.flow.ReportTargetUtil;
import org.libreoffice.report.DataSourceFactory;
import org.libreoffice.report.ImageService;
import org.libreoffice.report.InputRepository;
import org.libreoffice.report.OutputRepository;
import org.libreoffice.report.pentaho.output.OfficeDocumentReportTarget;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class ChartRawReportTarget
extends OfficeDocumentReportTarget {
    private boolean inFilterElements = false;
    private boolean tableRowsStarted = false;
    private int tableCount = 0;
    private int closeTags = 0;

    public ChartRawReportTarget(ReportJob reportJob, ResourceManager resourceManager, ResourceKey resourceKey, InputRepository inputRepository, OutputRepository outputRepository, String string, ImageService imageService, DataSourceFactory dataSourceFactory) throws ReportProcessingException {
        super(reportJob, resourceManager, resourceKey, inputRepository, outputRepository, string, imageService, dataSourceFactory);
    }

    protected String getTargetMimeType() {
        return "application/vnd.oasis.opendocument.chart";
    }

    protected String getStartContent() {
        return "chart";
    }

    public String getExportDescriptor() {
        return "raw/application/vnd.oasis.opendocument.chart";
    }

    protected void startContent(AttributeMap attributeMap) throws IOException, DataSourceException, ReportProcessingException {
        this.inFilterElements = false;
        this.closeTags = 0;
        this.tableCount = 0;
        XmlWriter xmlWriter = this.getXmlWriter();
        xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", this.getStartContent(), null, false);
        this.writeNullDate();
        ++this.closeTags;
    }

    protected void endContent(AttributeMap attributeMap) throws IOException, DataSourceException, ReportProcessingException {
        XmlWriter xmlWriter = this.getXmlWriter();
        while (this.closeTags > 0) {
            xmlWriter.writeCloseTag();
            --this.closeTags;
        }
    }

    protected void startReportSection(AttributeMap attributeMap, int n) throws IOException, DataSourceException, ReportProcessingException {
    }

    protected void endReportSection(AttributeMap attributeMap, int n) throws IOException, DataSourceException, ReportProcessingException {
    }

    protected void startOther(AttributeMap attributeMap) throws IOException, DataSourceException, ReportProcessingException {
        String string = ReportTargetUtil.getNamespaceFromAttribute(attributeMap);
        if (!this.isFilteredNamespace(string)) {
            String string2 = ReportTargetUtil.getElemenTypeFromAttribute(attributeMap);
            try {
                this.processElement(attributeMap, string, string2);
            }
            catch (IOException iOException) {
                throw new ReportProcessingException("Failed", iOException);
            }
        }
    }

    private boolean isFiltered(String string) {
        return "table-header-columns".equals(string) || "table-header-rows".equals(string) || "table-columns".equals(string);
    }

    protected void endOther(AttributeMap attributeMap) throws IOException, DataSourceException, ReportProcessingException {
        if (this.tableRowsStarted && this.getCurrentRole() == 11) {
            return;
        }
        String string = ReportTargetUtil.getNamespaceFromAttribute(attributeMap);
        if (!this.isFilteredNamespace(string)) {
            String string2 = ReportTargetUtil.getElemenTypeFromAttribute(attributeMap);
            if ("urn:oasis:names:tc:opendocument:xmlns:table:1.0".equals(string)) {
                if ("table".equals(string2) || "table-rows".equals(string2)) {
                    return;
                }
                if (this.isFiltered(string2)) {
                    this.inFilterElements = false;
                    if (this.tableCount > 1) {
                        return;
                    }
                }
            } else if ("urn:oasis:names:tc:opendocument:xmlns:chart:1.0".equals(string) && "chart".equals(string2)) {
                return;
            }
            if (this.inFilterElements && this.tableCount > 1) {
                return;
            }
            XmlWriter xmlWriter = this.getXmlWriter();
            xmlWriter.writeCloseTag();
            --this.closeTags;
        }
    }

    public void processContent(DataFlags dataFlags) throws DataSourceException, ReportProcessingException {
        if (!this.tableRowsStarted || this.getCurrentRole() != 11) {
            super.processContent(dataFlags);
        }
    }

    private void processElement(AttributeMap attributeMap, String string, String string2) throws IOException, ReportProcessingException {
        if (this.tableRowsStarted && this.getCurrentRole() == 11) {
            return;
        }
        if ("urn:oasis:names:tc:opendocument:xmlns:table:1.0".equals(string)) {
            if ("table".equals(string2)) {
                ++this.tableCount;
                if (this.tableCount > 1) {
                    return;
                }
            } else if ("table-rows".equals(string2)) {
                if (this.tableCount > 1) {
                    return;
                }
                this.tableRowsStarted = true;
            } else if (this.isFiltered(string2)) {
                this.inFilterElements = true;
                if (this.tableCount > 1) {
                    return;
                }
            }
        }
        if (this.inFilterElements && this.tableCount > 1) {
            return;
        }
        this.performStyleProcessing(attributeMap);
        AttributeList attributeList = this.buildAttributeList(attributeMap);
        XmlWriter xmlWriter = this.getXmlWriter();
        xmlWriter.writeTag(string, string2, attributeList, false);
        ++this.closeTags;
    }

    public void processText(String string) throws DataSourceException, ReportProcessingException {
        if (this.inFilterElements && this.tableCount > 1) {
            return;
        }
        super.processText(string);
    }

    public void endReport(ReportStructureRoot reportStructureRoot) throws DataSourceException, ReportProcessingException {
        super.endReport(reportStructureRoot);
        this.copyMeta();
    }
}

