/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.layoutprocessor;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.text.SimpleDateFormat;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataFlags;
import org.jfree.report.DataRow;
import org.jfree.report.DataSourceException;
import org.jfree.report.data.DefaultDataFlags;
import org.jfree.report.expressions.Expression;
import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutControllerUtil;
import org.jfree.report.flow.layoutprocessor.SectionLayoutController;
import org.jfree.report.structure.DetailSection;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Group;
import org.libreoffice.report.pentaho.layoutprocessor.AbstractReportElementLayoutController;
import org.libreoffice.report.pentaho.layoutprocessor.TableCellLayoutController;
import org.libreoffice.report.pentaho.model.FormattedTextElement;
import org.libreoffice.report.pentaho.model.ReportElement;
import org.pentaho.reporting.libraries.formula.lvalues.ContextLookup;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;

public class FormatValueUtility {
    private static final String BOOLEAN_VALUE = "boolean-value";
    private static final String STRING_VALUE = "string-value";
    public static final String VALUE_TYPE = "value-type";
    public static final String VALUE = "value";
    private static SimpleDateFormat dateFormat;
    private static SimpleDateFormat timeFormat;

    private FormatValueUtility() {
    }

    public static String applyValueForVariable(Object object, AttributeMap attributeMap) {
        String string = null;
        if (object instanceof Time) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"time");
            string = FormatValueUtility.formatTime((Time)object);
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "time-value", (Object)string);
        } else if (object instanceof Date) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"date");
            string = FormatValueUtility.formatDate((java.util.Date)object);
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "date-value", (Object)string);
        } else if (object instanceof java.util.Date) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"date");
            string = FormatValueUtility.formatDate((java.util.Date)object);
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "date-value", (Object)string);
        } else if (object instanceof Number) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"float");
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE, (Object)String.valueOf(object));
        } else if (object instanceof Boolean) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"boolean");
            if (Boolean.TRUE.equals(object)) {
                attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", BOOLEAN_VALUE, (Object)"true");
            } else {
                attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", BOOLEAN_VALUE, (Object)"false");
            }
        } else if (object != null) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"string");
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", STRING_VALUE, (Object)String.valueOf(object));
        } else {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"void");
        }
        return string;
    }

    public static void applyValueForCell(Object object, AttributeMap attributeMap, String string) {
        if (object instanceof Time) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"time");
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "time-value", (Object)FormatValueUtility.formatTime((Time)object));
        } else if (object instanceof Date) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"date");
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "date-value", (Object)FormatValueUtility.formatDate((java.util.Date)object));
        } else if (object instanceof java.util.Date) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"date");
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "date-value", (Object)FormatValueUtility.formatDate((java.util.Date)object));
        } else if (object instanceof BigDecimal) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"float");
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE, (Object)String.valueOf(object));
        } else if (object instanceof Number) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"float");
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE, (Object)String.valueOf(object));
        } else if (object instanceof Boolean) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"boolean");
            if (Boolean.TRUE.equals(object)) {
                attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", BOOLEAN_VALUE, (Object)"true");
            } else {
                attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", BOOLEAN_VALUE, (Object)"false");
            }
        } else if (object != null) {
            try {
                Float f = Float.valueOf(String.valueOf(object));
                FormatValueUtility.applyValueForCell(f, attributeMap, string);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                if (!"string".equals(string)) {
                    attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"string");
                }
                attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", STRING_VALUE, (Object)String.valueOf(object));
            }
        } else {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"void");
        }
    }

    private static synchronized String formatDate(java.util.Date date) {
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'S'Z'");
        }
        return dateFormat.format(date);
    }

    private static synchronized String formatTime(java.util.Date date) {
        if (timeFormat == null) {
            timeFormat = new SimpleDateFormat("'PT'HH'H'mm'M'ss'S'");
        }
        return timeFormat.format(date);
    }

    public static DataFlags computeDataFlag(FormattedTextElement formattedTextElement, FlowController flowController) throws DataSourceException {
        FormulaExpression formulaExpression = formattedTextElement.getValueExpression();
        Object object = LayoutControllerUtil.evaluateExpression(flowController, formattedTextElement, formulaExpression);
        if (object == null) {
            return null;
        }
        if (object instanceof DataFlags) {
            return (DataFlags)object;
        }
        return new DefaultDataFlags(null, object, true);
    }

    public static boolean shouldPrint(LayoutController layoutController, ReportElement reportElement) throws DataSourceException {
        Object object;
        boolean bl;
        if (layoutController instanceof AbstractReportElementLayoutController) {
            bl = ((AbstractReportElementLayoutController)layoutController).isValueChanged();
        } else if (layoutController instanceof TableCellLayoutController) {
            bl = ((TableCellLayoutController)layoutController).isValueChanged();
        } else {
            throw new AssertionError((Object)"org.libreoffice.report.pentaho.layoutprocessor.FormatValueUtility.shouldPrint expects an implementor of isValueChanged as first argument");
        }
        if (!(bl || reportElement.isPrintRepeatedValues() || reportElement.isPrintWhenGroupChange() && FormatValueUtility.isGroupChanged(layoutController))) {
            return false;
        }
        Expression expression = reportElement.getDisplayCondition();
        return expression == null || !Boolean.FALSE.equals(object = LayoutControllerUtil.evaluateExpression(layoutController.getFlowController(), reportElement, expression));
    }

    private static boolean isGroupChanged(LayoutController layoutController) {
        SectionLayoutController sectionLayoutController = FormatValueUtility.findGroupOrDetail(layoutController);
        if (sectionLayoutController == null) {
            return true;
        }
        return sectionLayoutController.getIterationCount() == 0;
    }

    private static SectionLayoutController findGroupOrDetail(LayoutController layoutController) {
        LayoutController layoutController2 = layoutController.getParent();
        while (layoutController2 != null) {
            if (!(layoutController2 instanceof SectionLayoutController)) {
                layoutController2 = layoutController2.getParent();
                continue;
            }
            SectionLayoutController sectionLayoutController = (SectionLayoutController)layoutController2;
            Element element = sectionLayoutController.getElement();
            if (!(element instanceof Group) && !(element instanceof DetailSection)) {
                layoutController2 = layoutController2.getParent();
                continue;
            }
            return (SectionLayoutController)layoutController2;
        }
        return null;
    }

    public static boolean isReferenceChanged(LayoutController layoutController, LValue lValue) {
        DataRow dataRow;
        LValue[] lValueArray;
        if (lValue instanceof ContextLookup) {
            lValueArray = (LValue[])lValue;
            String string = lValueArray.getName();
            dataRow = layoutController.getFlowController().getMasterRow().getGlobalView();
            try {
                DataFlags dataFlags = dataRow.getFlags(string);
                if (dataFlags != null && dataFlags.isChanged()) {
                    return true;
                }
            }
            catch (DataSourceException dataSourceException) {
                // empty catch block
            }
        }
        lValueArray = lValue.getChildValues();
        for (int i = 0; i < lValueArray.length; ++i) {
            dataRow = lValueArray[i];
            if (!FormatValueUtility.isReferenceChanged(layoutController, (LValue)dataRow)) continue;
            return true;
        }
        return false;
    }
}

