/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.container;

import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.io.XInputStream;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.script.framework.container.Parcel;
import com.sun.star.script.framework.container.ParcelDescriptor;
import com.sun.star.script.framework.container.ParsedScriptUri;
import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.io.XInputStreamImpl;
import com.sun.star.script.framework.io.XInputStreamWrapper;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.PathUtils;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.ucb.XSimpleFileAccess2;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uri.XUriReference;
import com.sun.star.uri.XUriReferenceFactory;
import com.sun.star.uri.XVndSunStarScriptUrl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

public class ParcelContainer
implements XNameAccess {
    protected String language;
    protected String containerUrl;
    protected Collection<Parcel> parcels = new ArrayList<Parcel>(10);
    protected static XSimpleFileAccess m_xSFA;
    protected XComponentContext m_xCtx;
    private ParcelContainer parent = null;
    private Collection<ParcelContainer> childContainers = new ArrayList<ParcelContainer>(10);
    private boolean isPkgContainer = false;

    public boolean isUnoPkg() {
        return this.isPkgContainer;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public ParcelContainer parent() {
        return this.parent;
    }

    public ParcelContainer[] getChildContainers() {
        if (this.childContainers.isEmpty()) {
            return new ParcelContainer[0];
        }
        return this.childContainers.toArray(new ParcelContainer[this.childContainers.size()]);
    }

    public boolean removeChildContainer(ParcelContainer parcelContainer) {
        return this.childContainers.remove(parcelContainer);
    }

    public void addChildContainer(ParcelContainer parcelContainer) {
        this.childContainers.add(parcelContainer);
    }

    public ParcelContainer getChildContainer(String string) {
        ParcelContainer parcelContainer = null;
        for (ParcelContainer parcelContainer2 : this.childContainers) {
            String string2 = ScriptMetaData.getLocationPlaceHolder(parcelContainer2.containerUrl, parcelContainer2.getName());
            if (!string.equals(string2)) continue;
            parcelContainer = parcelContainer2;
            break;
        }
        return parcelContainer;
    }

    public ParcelContainer getChildContainerForURL(String string) {
        ParcelContainer parcelContainer = null;
        for (ParcelContainer parcelContainer2 : this.childContainers) {
            if (!string.equals(parcelContainer2.containerUrl)) continue;
            parcelContainer = parcelContainer2;
            break;
        }
        return parcelContainer;
    }

    public String getName() {
        String string = null;
        if (!this.containerUrl.startsWith("vnd.sun.star.tdoc:")) {
            String string2 = URLDecoder.decode(this.containerUrl);
            int n = string2.lastIndexOf("/");
            if (n != -1) {
                string = string2.substring(n + 1);
            }
        } else {
            string = "document";
        }
        return string;
    }

    public ParcelContainer(XComponentContext xComponentContext, String string, String string2) throws IllegalArgumentException, WrappedTargetException {
        this(null, xComponentContext, string, string2, true);
    }

    public ParcelContainer(XComponentContext xComponentContext, String string, String string2, boolean bl) throws IllegalArgumentException, WrappedTargetException {
        this(null, xComponentContext, string, string2, bl);
    }

    public ParcelContainer(ParcelContainer parcelContainer, XComponentContext xComponentContext, String string, String string2, boolean bl) throws IllegalArgumentException, WrappedTargetException {
        LogUtils.DEBUG("Creating ParcelContainer for " + string + " loadParcels = " + bl + " language = " + string2);
        this.m_xCtx = xComponentContext;
        this.language = string2;
        this.parent = parcelContainer;
        this.containerUrl = string;
        this.initSimpleFileAccess();
        boolean bl2 = false;
        if (parcelContainer != null) {
            bl2 = parcelContainer.isUnoPkg();
        }
        if (string.endsWith("uno_packages") || bl2) {
            this.isPkgContainer = true;
        }
        if (bl) {
            this.loadParcels();
        }
    }

    public String getContainerURL() {
        return this.containerUrl;
    }

    private synchronized void initSimpleFileAccess() {
        if (m_xSFA != null) {
            return;
        }
        try {
            m_xSFA = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)this.m_xCtx.getServiceManager().createInstanceWithContext("com.sun.star.ucb.SimpleFileAccess", this.m_xCtx));
        }
        catch (Exception exception) {
            LogUtils.DEBUG("Error instantiating simplefile access ");
            LogUtils.DEBUG(LogUtils.getTrace(exception));
        }
    }

    public String getParcelContainerDir() {
        if (!this.isUnoPkg()) {
            return PathUtils.make_url(this.containerUrl, "Scripts/" + this.language.toLowerCase());
        }
        return this.containerUrl;
    }

    public Object getByName(String string) throws NoSuchElementException, WrappedTargetException {
        Parcel parcel;
        block4: {
            parcel = null;
            try {
                if (!this.hasElements()) break block4;
                for (Parcel parcel2 : this.parcels) {
                    if (!parcel2.getName().equals(string)) continue;
                    parcel = parcel2;
                    break;
                }
            }
            catch (Exception exception) {
                throw new WrappedTargetException(exception.toString());
            }
        }
        if (parcel == null) {
            throw new NoSuchElementException("Macro Library " + string + " not found");
        }
        return parcel;
    }

    public String[] getElementNames() {
        if (this.hasElements()) {
            Parcel[] parcelArray = this.parcels.toArray(new Parcel[this.parcels.size()]);
            String[] stringArray = new String[parcelArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = parcelArray[i].getName();
            }
            return stringArray;
        }
        return new String[0];
    }

    public boolean hasByName(String string) {
        boolean bl = false;
        try {
            if (this.getByName(string) != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public Type getElementType() {
        return new Type();
    }

    public boolean hasElements() {
        return this.parcels != null && !this.parcels.isEmpty();
    }

    private void loadParcels() throws IllegalArgumentException, WrappedTargetException {
        try {
            LogUtils.DEBUG("About to load parcels from " + this.containerUrl);
            if (m_xSFA.isFolder(this.getParcelContainerDir())) {
                LogUtils.DEBUG(this.getParcelContainerDir() + " is a folder ");
                String[] stringArray = m_xSFA.getFolderContents(this.getParcelContainerDir(), true);
                this.parcels = new ArrayList<Parcel>(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    LogUtils.DEBUG("Processing " + stringArray[i]);
                    try {
                        this.loadParcel(stringArray[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        LogUtils.DEBUG("ParcelContainer.loadParcels caught " + exception.getClass().getName() + " exception loading parcel " + stringArray[i] + ": " + exception.getMessage());
                    }
                }
            } else {
                LogUtils.DEBUG(" ParcelCOntainer.loadParcels " + this.getParcelContainerDir() + " is not a folder ");
            }
        }
        catch (CommandAbortedException commandAbortedException) {
            LogUtils.DEBUG("ParcelContainer.loadParcels caught exception processing folders for " + this.getParcelContainerDir());
            LogUtils.DEBUG("TRACE: " + LogUtils.getTrace((Exception)((Object)commandAbortedException)));
            throw new WrappedTargetException(commandAbortedException.toString());
        }
        catch (com.sun.star.uno.Exception exception) {
            LogUtils.DEBUG("ParcelContainer.loadParcels caught exception processing folders for " + this.getParcelContainerDir());
            LogUtils.DEBUG("TRACE: " + LogUtils.getTrace((Exception)((Object)exception)));
            throw new WrappedTargetException(exception.toString());
        }
    }

    public XNameContainer createParcel(String string) throws ElementExistException, WrappedTargetException {
        Parcel parcel = null;
        if (this.hasByName(string)) {
            throw new ElementExistException("Parcel " + string + " already exists");
        }
        String string2 = PathUtils.make_url(this.getParcelContainerDir(), string);
        try {
            LogUtils.DEBUG("ParcelContainer.createParcel, creating folder " + string2);
            m_xSFA.createFolder(string2);
            LogUtils.DEBUG("ParcelContainer.createParcel, folder " + string2 + " created ");
            ParcelDescriptor parcelDescriptor = new ParcelDescriptor();
            parcelDescriptor.setLanguage(this.language);
            String string3 = PathUtils.make_url(string2, "parcel-descriptor.xml");
            XSimpleFileAccess2 xSimpleFileAccess2 = (XSimpleFileAccess2)UnoRuntime.queryInterface(XSimpleFileAccess2.class, (Object)m_xSFA);
            if (xSimpleFileAccess2 != null) {
                LogUtils.DEBUG("createParcel() Using XSIMPLEFILEACCESS2 " + string3);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                parcelDescriptor.write(byteArrayOutputStream);
                byteArrayOutputStream.close();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                XInputStreamImpl xInputStreamImpl = new XInputStreamImpl(byteArrayInputStream);
                xSimpleFileAccess2.writeFile(string3, (XInputStream)xInputStreamImpl);
                xInputStreamImpl.closeInput();
                parcel = this.loadParcel(string2);
            }
        }
        catch (Exception exception) {
            LogUtils.DEBUG("createParcel() Exception while attempting to create = " + string);
            throw new WrappedTargetException(exception.toString());
        }
        return parcel;
    }

    public Parcel loadParcel(String string) throws WrappedTargetException, IllegalArgumentException {
        Parcel parcel;
        block27: {
            String string2 = null;
            String string3 = PathUtils.make_url(string, "parcel-descriptor.xml");
            parcel = null;
            XInputStream xInputStream = null;
            InputStream inputStream = null;
            try {
                if (m_xSFA.exists(string3)) {
                    LogUtils.DEBUG("ParcelContainer.loadParcel opening " + string3);
                    xInputStream = m_xSFA.openFileRead(string3);
                    inputStream = new XInputStreamWrapper(xInputStream);
                    ParcelDescriptor parcelDescriptor = new ParcelDescriptor(inputStream);
                    try {
                        inputStream.close();
                        inputStream = null;
                    }
                    catch (Exception exception) {
                        LogUtils.DEBUG("ParcelContainer.loadParcel Exception when closing stream for  " + string3 + " :" + exception);
                    }
                    LogUtils.DEBUG("ParcelContainer.loadParcel closed " + string3);
                    if (!parcelDescriptor.getLanguage().equals(this.language)) {
                        LogUtils.DEBUG("ParcelContainer.loadParcel Language of Parcel does not match this container ");
                        Parcel parcel2 = null;
                        return parcel2;
                    }
                    LogUtils.DEBUG("Processing " + string3 + " closed ");
                    int n = string.lastIndexOf("/");
                    string2 = string.substring(n + 1);
                    parcel = new Parcel(m_xSFA, this, parcelDescriptor, string2);
                    LogUtils.DEBUG(" ParcelContainer.loadParcel created parcel for " + string3 + " for language " + this.language);
                    this.parcels.add(parcel);
                    break block27;
                }
                throw new IOException(string3 + " does NOT exist!");
            }
            catch (CommandAbortedException commandAbortedException) {
                LogUtils.DEBUG("loadParcel() Exception while accessing filesystem url = " + string3 + (Object)((Object)commandAbortedException));
                throw new WrappedTargetException(commandAbortedException.toString());
            }
            catch (IOException iOException) {
                LogUtils.DEBUG("ParcelContainer.loadParcel() caught IOException while accessing " + string3 + ": " + iOException);
                throw new WrappedTargetException(iOException.toString());
            }
            catch (com.sun.star.uno.Exception exception) {
                LogUtils.DEBUG("loadParcel() Exception while accessing filesystem url = " + string3 + (Object)((Object)exception));
                throw new WrappedTargetException(exception.toString());
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                } else if (xInputStream != null) {
                    try {
                        xInputStream.closeInput();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return parcel;
    }

    public void renameParcel(String string, String string2) throws NoSuchElementException, WrappedTargetException {
        LogUtils.DEBUG(" ** ParcelContainer Renaming parcel " + string + " to " + string2);
        LogUtils.DEBUG(" ** ParcelContainer is " + this);
        Parcel parcel = (Parcel)this.getByName(string);
        if (parcel == null) {
            throw new NoSuchElementException("No parcel named " + string);
        }
        String string3 = PathUtils.make_url(this.getParcelContainerDir(), string);
        String string4 = PathUtils.make_url(this.getParcelContainerDir(), string2);
        try {
            if (!m_xSFA.isFolder(string3)) {
                com.sun.star.io.IOException iOException = new com.sun.star.io.IOException("Invalid Parcel directory: " + string);
                throw new WrappedTargetException(iOException.toString());
            }
            LogUtils.DEBUG(" ** ParcelContainer Renaming folder " + string3 + " to " + string4);
            m_xSFA.move(string3, string4);
        }
        catch (CommandAbortedException commandAbortedException) {
            LogUtils.DEBUG(" ** ParcelContainer Renaming failed with " + (Object)((Object)commandAbortedException));
            throw new WrappedTargetException(commandAbortedException.toString());
        }
        catch (com.sun.star.uno.Exception exception) {
            LogUtils.DEBUG(" ** ParcelContainer Renaming failed with " + (Object)((Object)exception));
            throw new WrappedTargetException(exception.toString());
        }
        parcel.rename(string2);
    }

    public boolean removeParcel(String string) throws NoSuchElementException, WrappedTargetException {
        boolean bl = false;
        Parcel parcel = (Parcel)this.getByName(string);
        if (parcel == null) {
            throw new NoSuchElementException("No parcel named " + string);
        }
        bl = this.parcels.remove(parcel);
        return bl;
    }

    public boolean deleteParcel(String string) throws NoSuchElementException, WrappedTargetException {
        LogUtils.DEBUG("deleteParcel for containerURL " + this.containerUrl + " name = " + string + " Langueg = " + this.language);
        boolean bl = false;
        Parcel parcel = (Parcel)this.getByName(string);
        if (parcel == null) {
            throw new NoSuchElementException("No parcel named " + string);
        }
        try {
            String string2 = PathUtils.make_url(this.getParcelContainerDir(), string);
            m_xSFA.kill(string2);
        }
        catch (Exception exception) {
            LogUtils.DEBUG("Error deleteing parcel " + string);
            throw new WrappedTargetException(exception.toString());
        }
        bl = this.parcels.remove(parcel);
        return bl;
    }

    public String getLanguage() {
        return this.language;
    }

    public ScriptMetaData findScript(ParsedScriptUri parsedScriptUri) throws NoSuchElementException, WrappedTargetException {
        ScriptMetaData scriptMetaData = null;
        Parcel parcel = null;
        parcel = (Parcel)this.getByName(parsedScriptUri.parcel);
        scriptMetaData = (ScriptMetaData)parcel.getByName(parsedScriptUri.function);
        LogUtils.DEBUG("** found script data for " + parsedScriptUri.function + " script is " + scriptMetaData);
        return scriptMetaData;
    }

    public ParsedScriptUri parseScriptUri(String string) throws IllegalArgumentException {
        XMultiComponentFactory xMultiComponentFactory = null;
        XUriReferenceFactory xUriReferenceFactory = null;
        try {
            xMultiComponentFactory = this.m_xCtx.getServiceManager();
            xUriReferenceFactory = (XUriReferenceFactory)UnoRuntime.queryInterface(XUriReferenceFactory.class, (Object)xMultiComponentFactory.createInstanceWithContext("com.sun.star.uri.UriReferenceFactory", this.m_xCtx));
        }
        catch (com.sun.star.uno.Exception exception) {
            LogUtils.DEBUG("Problems parsing  URL:" + exception.toString());
            throw new IllegalArgumentException("Problems parsing  URL reason: " + exception.toString());
        }
        if (xUriReferenceFactory == null) {
            LogUtils.DEBUG("Failed to create UrlReference factory");
            throw new IllegalArgumentException("Failed to create UrlReference factory for url " + string);
        }
        XUriReference xUriReference = xUriReferenceFactory.parse(string);
        XVndSunStarScriptUrl xVndSunStarScriptUrl = (XVndSunStarScriptUrl)UnoRuntime.queryInterface(XVndSunStarScriptUrl.class, (Object)xUriReference);
        if (xVndSunStarScriptUrl == null) {
            LogUtils.DEBUG("Failed to parse url");
            throw new IllegalArgumentException("Failed to parse url " + string);
        }
        ParsedScriptUri parsedScriptUri = new ParsedScriptUri();
        parsedScriptUri.language = xVndSunStarScriptUrl.getParameter("language");
        parsedScriptUri.function = xVndSunStarScriptUrl.getName();
        parsedScriptUri.parcel = "";
        StringTokenizer stringTokenizer = new StringTokenizer(parsedScriptUri.function, ".");
        if (stringTokenizer.hasMoreElements()) {
            parsedScriptUri.parcel = (String)stringTokenizer.nextElement();
            LogUtils.DEBUG("** parcelName = " + parsedScriptUri.parcel);
        }
        if (parsedScriptUri.function != null && parsedScriptUri.function.length() > 0) {
            parsedScriptUri.function = parsedScriptUri.function.substring(parsedScriptUri.parcel.length() + 1);
        }
        parsedScriptUri.location = xVndSunStarScriptUrl.getParameter("location");
        LogUtils.DEBUG("** location = " + parsedScriptUri.location + "\nfunction = " + parsedScriptUri.function + "\nparcel = " + parsedScriptUri.parcel + "\nlocation = " + parsedScriptUri.location);
        return parsedScriptUri;
    }
}

